// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetBackupPlanFromJSONInput struct {
	_ struct{} `type:"structure"`

	// A customer-supplied backup plan document in JSON format.
	//
	// BackupPlanTemplateJson is a required field
	BackupPlanTemplateJson *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetBackupPlanFromJSONInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackupPlanFromJSONInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBackupPlanFromJSONInput"}

	if s.BackupPlanTemplateJson == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupPlanTemplateJson"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBackupPlanFromJSONInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BackupPlanTemplateJson != nil {
		v := *s.BackupPlanTemplateJson

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupPlanTemplateJson", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetBackupPlanFromJSONOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the body of a backup plan. Includes a BackupPlanName and one or
	// more sets of Rules.
	BackupPlan *BackupPlan `type:"structure"`
}

// String returns the string representation
func (s GetBackupPlanFromJSONOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBackupPlanFromJSONOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupPlan != nil {
		v := s.BackupPlan

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "BackupPlan", v, metadata)
	}
	return nil
}

const opGetBackupPlanFromJSON = "GetBackupPlanFromJSON"

// GetBackupPlanFromJSONRequest returns a request value for making API operation for
// AWS Backup.
//
// Returns a valid JSON document specifying a backup plan or an error.
//
//    // Example sending a request using GetBackupPlanFromJSONRequest.
//    req := client.GetBackupPlanFromJSONRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromJSON
func (c *Client) GetBackupPlanFromJSONRequest(input *GetBackupPlanFromJSONInput) GetBackupPlanFromJSONRequest {
	op := &aws.Operation{
		Name:       opGetBackupPlanFromJSON,
		HTTPMethod: "POST",
		HTTPPath:   "/backup/template/json/toPlan",
	}

	if input == nil {
		input = &GetBackupPlanFromJSONInput{}
	}

	req := c.newRequest(op, input, &GetBackupPlanFromJSONOutput{})
	return GetBackupPlanFromJSONRequest{Request: req, Input: input, Copy: c.GetBackupPlanFromJSONRequest}
}

// GetBackupPlanFromJSONRequest is the request type for the
// GetBackupPlanFromJSON API operation.
type GetBackupPlanFromJSONRequest struct {
	*aws.Request
	Input *GetBackupPlanFromJSONInput
	Copy  func(*GetBackupPlanFromJSONInput) GetBackupPlanFromJSONRequest
}

// Send marshals and sends the GetBackupPlanFromJSON API request.
func (r GetBackupPlanFromJSONRequest) Send(ctx context.Context) (*GetBackupPlanFromJSONResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetBackupPlanFromJSONResponse{
		GetBackupPlanFromJSONOutput: r.Request.Data.(*GetBackupPlanFromJSONOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetBackupPlanFromJSONResponse is the response type for the
// GetBackupPlanFromJSON API operation.
type GetBackupPlanFromJSONResponse struct {
	*GetBackupPlanFromJSONOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetBackupPlanFromJSON request.
func (r *GetBackupPlanFromJSONResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
