// Code generated by go-bindata.
// sources:
// config/apiserver/apiservice.yaml
// config/apiserver/deployment.yaml
// config/apiserver/hiveapi_rbac_role.yaml
// config/apiserver/hiveapi_rbac_role_binding.yaml
// config/apiserver/service-account.yaml
// config/apiserver/service.yaml
// config/hiveadmission/apiservice.yaml
// config/hiveadmission/clusterdeployment-webhook.yaml
// config/hiveadmission/clusterimageset-webhook.yaml
// config/hiveadmission/clusterprovision-webhook.yaml
// config/hiveadmission/deployment.yaml
// config/hiveadmission/dnszones-webhook.yaml
// config/hiveadmission/hiveadmission_rbac_role.yaml
// config/hiveadmission/hiveadmission_rbac_role_binding.yaml
// config/hiveadmission/machinepool-webhook.yaml
// config/hiveadmission/selectorsyncset-webhook.yaml
// config/hiveadmission/service-account.yaml
// config/hiveadmission/service.yaml
// config/hiveadmission/syncset-webhook.yaml
// config/manager/deployment.yaml
// config/manager/service.yaml
// config/rbac/hive_admin_role.yaml
// config/rbac/hive_admin_role_binding.yaml
// config/rbac/hive_controllers_role.yaml
// config/rbac/hive_controllers_role_binding.yaml
// config/rbac/hive_frontend_role.yaml
// config/rbac/hive_frontend_role_binding.yaml
// config/rbac/hive_frontend_serviceaccount.yaml
// config/rbac/hive_reader_role.yaml
// config/rbac/hive_reader_role_binding.yaml
// config/crds/hive_v1_checkpoint.yaml
// config/crds/hive_v1_clusterdeployment.yaml
// config/crds/hive_v1_clusterdeprovision.yaml
// config/crds/hive_v1_clusterimageset.yaml
// config/crds/hive_v1_clusterprovision.yaml
// config/crds/hive_v1_clusterstate.yaml
// config/crds/hive_v1_dnszone.yaml
// config/crds/hive_v1_hiveconfig.yaml
// config/crds/hive_v1_machinepool.yaml
// config/crds/hive_v1_machinepoolnamelease.yaml
// config/crds/hive_v1_selectorsyncidentityprovider.yaml
// config/crds/hive_v1_selectorsyncset.yaml
// config/crds/hive_v1_syncidentityprovider.yaml
// config/crds/hive_v1_syncset.yaml
// config/crds/hive_v1_syncsetinstance.yaml
// config/configmaps/install-log-regexes-configmap.yaml
// DO NOT EDIT!

package assets

import (
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _configApiserverApiserviceYaml = []byte(`---
apiVersion: apiregistration.k8s.io/v1
kind: APIService
metadata:
  name: v1alpha1.hive.openshift.io
  labels:
    api: hiveapi
    apiserver: "true"
  annotations:
    service.alpha.openshift.io/inject-cabundle: "true"
spec:
  group: hive.openshift.io
  groupPriorityMinimum: 2000
  service:
    name: hiveapi
    namespace: hive
  version: v1alpha1
  versionPriority: 10
`)

func configApiserverApiserviceYamlBytes() ([]byte, error) {
	return _configApiserverApiserviceYaml, nil
}

func configApiserverApiserviceYaml() (*asset, error) {
	bytes, err := configApiserverApiserviceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/apiserver/apiservice.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configApiserverDeploymentYaml = []byte(`apiVersion: apps/v1
kind: Deployment
metadata:
  name: hiveapi
  namespace: hive
  labels:
    api: hiveapi
    apiserver: "true"
spec:
  replicas: 1
  selector:
    matchLabels:
      api: hiveapi
      apiserver: "true"
  template:
    metadata:
      labels:
        api: hiveapi
        apiserver: "true"
    spec:
      containers:
      # By default we will use the latest CI images published from hive master:
      - image: registry.svc.ci.openshift.org/openshift/hive-v4.0:hive
        name: apiserver
        resources:
          requests:
            cpu: 100m
            memory: 400Mi
          limits:
            cpu: 100m
            memory: 600Mi
        command:
          - "/opt/services/hive-apiserver"
        args:
          - "start"
          - "--v=2"
          - "--secure-port=10443"
          - "--logtostderr"
          - "--tls-cert-file=/apiserver.local.config/certificates/tls.crt"
          - "--tls-private-key-file=/apiserver.local.config/certificates/tls.key"
        volumeMounts:
        - name: apiserver-certs
          mountPath: /apiserver.local.config/certificates
          readOnly: true
      serviceAccountName: hiveapi-sa
      volumes:
        - name: apiserver-certs
          secret:
            secretName: hiveapi-serving-cert
`)

func configApiserverDeploymentYamlBytes() ([]byte, error) {
	return _configApiserverDeploymentYaml, nil
}

func configApiserverDeploymentYaml() (*asset, error) {
	bytes, err := configApiserverDeploymentYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/apiserver/deployment.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configApiserverHiveapi_rbac_roleYaml = []byte(`apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRole
metadata:
  annotations:
  name: system:openshift:hive:hiveapi
rules:
  - apiGroups: [""]
    resources: ["configmaps"]
    verbs: ["get"]
  - apiGroups: ["authorization.k8s.io"]
    resources: ["subjectaccessreviews"]
    verbs: ["create"]
  - apiGroups: ["hive.openshift.io"]
    resources: ["*"]
    verbs: ["*"]
  - apiGroups: [""]
    resources: ["secrets"]
    verbs: ["*"]
`)

func configApiserverHiveapi_rbac_roleYamlBytes() ([]byte, error) {
	return _configApiserverHiveapi_rbac_roleYaml, nil
}

func configApiserverHiveapi_rbac_roleYaml() (*asset, error) {
	bytes, err := configApiserverHiveapi_rbac_roleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/apiserver/hiveapi_rbac_role.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configApiserverHiveapi_rbac_role_bindingYaml = []byte(`apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  name: hiveapi-hive-hiveapi
roleRef:
  kind: ClusterRole
  apiGroup: rbac.authorization.k8s.io
  name: system:openshift:hive:hiveapi
subjects:
  - kind: ServiceAccount
    namespace: hive
    name: hiveapi-sa
`)

func configApiserverHiveapi_rbac_role_bindingYamlBytes() ([]byte, error) {
	return _configApiserverHiveapi_rbac_role_bindingYaml, nil
}

func configApiserverHiveapi_rbac_role_bindingYaml() (*asset, error) {
	bytes, err := configApiserverHiveapi_rbac_role_bindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/apiserver/hiveapi_rbac_role_binding.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configApiserverServiceAccountYaml = []byte(`---
apiVersion: v1
kind: ServiceAccount
metadata:
  namespace: hive
  name: hiveapi-sa
`)

func configApiserverServiceAccountYamlBytes() ([]byte, error) {
	return _configApiserverServiceAccountYaml, nil
}

func configApiserverServiceAccountYaml() (*asset, error) {
	bytes, err := configApiserverServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/apiserver/service-account.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configApiserverServiceYaml = []byte(`---
apiVersion: v1
kind: Service
metadata:
  annotations:
    service.alpha.openshift.io/serving-cert-secret-name: hiveapi-serving-cert
  labels:
    api: hiveapi
    apiserver: "true"
  name: hiveapi
  namespace: hive
spec:
  ports:
  - port: 443
    protocol: TCP
    targetPort: 10443
  selector:
    api: hiveapi
    apiserver: "true"
`)

func configApiserverServiceYamlBytes() ([]byte, error) {
	return _configApiserverServiceYaml, nil
}

func configApiserverServiceYaml() (*asset, error) {
	bytes, err := configApiserverServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/apiserver/service.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionApiserviceYaml = []byte(`---
# register as aggregated apiserver; this has a number of benefits:
#
# - allows other kubernetes components to talk to the the admission webhook using the ` + "`" + `kubernetes.default.svc` + "`" + ` service
# - allows other kubernetes components to use their in-cluster credentials to communicate with the webhook
# - allows you to test the webhook using kubectl
# - allows you to govern access to the webhook using RBAC
# - prevents other extension API servers from leaking their service account tokens to the webhook
#
# for more information, see: https://kubernetes.io/blog/2018/01/extensible-admission-is-beta
apiVersion: apiregistration.k8s.io/v1
kind: APIService
metadata:
  name: v1.admission.hive.openshift.io
  annotations:
    service.alpha.openshift.io/inject-cabundle: "true"
spec:
  group: admission.hive.openshift.io
  groupPriorityMinimum: 1000
  versionPriority: 15
  service:
    name: hiveadmission
    namespace: hive
  version: v1
`)

func configHiveadmissionApiserviceYamlBytes() ([]byte, error) {
	return _configHiveadmissionApiserviceYaml, nil
}

func configHiveadmissionApiserviceYaml() (*asset, error) {
	bytes, err := configHiveadmissionApiserviceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/apiservice.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionClusterdeploymentWebhookYaml = []byte(`---
apiVersion: admissionregistration.k8s.io/v1beta1
kind: ValidatingWebhookConfiguration
metadata:
  name: clusterdeploymentvalidators.admission.hive.openshift.io
webhooks:
- name: clusterdeploymentvalidators.admission.hive.openshift.io
  clientConfig:
    service:
      # reach the webhook via the registered aggregated API
      namespace: default
      name: kubernetes
      path: /apis/admission.hive.openshift.io/v1/clusterdeploymentvalidators
  rules:
  - operations:
    - CREATE
    - UPDATE
    apiGroups:
    - hive.openshift.io
    apiVersions:
    - v1
    resources:
    - clusterdeployments
  failurePolicy: Fail
`)

func configHiveadmissionClusterdeploymentWebhookYamlBytes() ([]byte, error) {
	return _configHiveadmissionClusterdeploymentWebhookYaml, nil
}

func configHiveadmissionClusterdeploymentWebhookYaml() (*asset, error) {
	bytes, err := configHiveadmissionClusterdeploymentWebhookYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/clusterdeployment-webhook.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionClusterimagesetWebhookYaml = []byte(`---
apiVersion: admissionregistration.k8s.io/v1beta1
kind: ValidatingWebhookConfiguration
metadata:
  name: clusterimagesetvalidators.admission.hive.openshift.io
webhooks:
- name: clusterimagesetvalidators.admission.hive.openshift.io
  clientConfig:
    service:
      # reach the webhook via the registered aggregated API
      namespace: default
      name: kubernetes
      path: /apis/admission.hive.openshift.io/v1/clusterimagesetvalidators
  rules:
  - operations:
    - CREATE
    - UPDATE
    apiGroups:
    - hive.openshift.io
    apiVersions:
    - v1
    resources:
    - clusterimagesets
  failurePolicy: Fail
`)

func configHiveadmissionClusterimagesetWebhookYamlBytes() ([]byte, error) {
	return _configHiveadmissionClusterimagesetWebhookYaml, nil
}

func configHiveadmissionClusterimagesetWebhookYaml() (*asset, error) {
	bytes, err := configHiveadmissionClusterimagesetWebhookYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/clusterimageset-webhook.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionClusterprovisionWebhookYaml = []byte(`---
apiVersion: admissionregistration.k8s.io/v1beta1
kind: ValidatingWebhookConfiguration
metadata:
  name: clusterprovisionvalidators.admission.hive.openshift.io
webhooks:
- name: clusterprovisionvalidators.admission.hive.openshift.io
  clientConfig:
    service:
      # reach the webhook via the registered aggregated API
      namespace: default
      name: kubernetes
      path: /apis/admission.hive.openshift.io/v1/clusterprovisionvalidators
  rules:
  - operations:
    - CREATE
    - UPDATE
    apiGroups:
    - hive.openshift.io
    apiVersions:
    - v1
    resources:
    - clusterprovisions
  failurePolicy: Fail
`)

func configHiveadmissionClusterprovisionWebhookYamlBytes() ([]byte, error) {
	return _configHiveadmissionClusterprovisionWebhookYaml, nil
}

func configHiveadmissionClusterprovisionWebhookYaml() (*asset, error) {
	bytes, err := configHiveadmissionClusterprovisionWebhookYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/clusterprovision-webhook.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionDeploymentYaml = []byte(`---
# to create the namespace-reservation-server
apiVersion: apps/v1
kind: Deployment
metadata:
  namespace: hive
  name: hiveadmission
  labels:
    app: hiveadmission
    hiveadmission: "true"
spec:
  replicas: 2
  selector:
    matchLabels:
      app: hiveadmission
      hiveadmission: "true"
  updateStrategy:
    rollingUpdate:
      maxUnavailable: 1
    type: RollingUpdate
  template:
    metadata:
      name: hiveadmission
      labels:
        app: hiveadmission
        hiveadmission: "true"
    spec:
      serviceAccountName: hiveadmission
      containers:
      - name: hiveadmission
        image: registry.svc.ci.openshift.org/openshift/hive-v4.0:hive
        imagePullPolicy: Always
        command:
        - "/opt/services/hiveadmission"
        - "--secure-port=9443"
        - "--audit-log-path=-"
        - "--tls-cert-file=/var/serving-cert/tls.crt"
        - "--tls-private-key-file=/var/serving-cert/tls.key"
        - "--v=2"
        ports:
        - containerPort: 9443
        volumeMounts:
        - mountPath: /var/serving-cert
          name: serving-cert
        readinessProbe:
          httpGet:
            path: /healthz
            port: 9443
            scheme: HTTPS
      volumes:
      - name: serving-cert
        secret:
          defaultMode: 420
          secretName: hiveadmission-serving-cert
`)

func configHiveadmissionDeploymentYamlBytes() ([]byte, error) {
	return _configHiveadmissionDeploymentYaml, nil
}

func configHiveadmissionDeploymentYaml() (*asset, error) {
	bytes, err := configHiveadmissionDeploymentYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/deployment.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionDnszonesWebhookYaml = []byte(`---
# register to intercept DNSZone object creates and updates
apiVersion: admissionregistration.k8s.io/v1beta1
kind: ValidatingWebhookConfiguration
metadata:
  name: dnszonevalidators.admission.hive.openshift.io
webhooks:
- name: dnszonevalidators.admission.hive.openshift.io
  clientConfig:
    service:
      # reach the webhook via the registered aggregated API
      namespace: default
      name: kubernetes
      path: /apis/admission.hive.openshift.io/v1/dnszonevalidators
  rules:
  - operations:
    - CREATE
    - UPDATE
    apiGroups:
    - hive.openshift.io
    apiVersions:
    - v1
    resources:
    - dnszones
  failurePolicy: Fail
`)

func configHiveadmissionDnszonesWebhookYamlBytes() ([]byte, error) {
	return _configHiveadmissionDnszonesWebhookYaml, nil
}

func configHiveadmissionDnszonesWebhookYaml() (*asset, error) {
	bytes, err := configHiveadmissionDnszonesWebhookYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/dnszones-webhook.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionHiveadmission_rbac_roleYaml = []byte(`apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRole
metadata:
  annotations:
  name: system:openshift:hive:hiveadmission
rules:
- apiGroups:
  - admission.hive.openshift.io
  resources:
  - dnszones
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - ""
  resources:
  - configmaps
  verbs:
  - get
- apiGroups:
  - admissionregistration.k8s.io
  resources:
  - validatingwebhookconfigurations
  - mutatingwebhookconfigurations
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - ""
  resources:
  - namespaces
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - authorization.k8s.io
  resources:
  - subjectaccessreviews
  verbs:
  - create

`)

func configHiveadmissionHiveadmission_rbac_roleYamlBytes() ([]byte, error) {
	return _configHiveadmissionHiveadmission_rbac_roleYaml, nil
}

func configHiveadmissionHiveadmission_rbac_roleYaml() (*asset, error) {
	bytes, err := configHiveadmissionHiveadmission_rbac_roleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/hiveadmission_rbac_role.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionHiveadmission_rbac_role_bindingYaml = []byte(`apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  name: hiveadmission-hive-hiveadmission
roleRef:
  kind: ClusterRole
  apiGroup: rbac.authorization.k8s.io
  name: system:openshift:hive:hiveadmission
subjects:
- kind: ServiceAccount
  namespace: hive
  name: hiveadmission
`)

func configHiveadmissionHiveadmission_rbac_role_bindingYamlBytes() ([]byte, error) {
	return _configHiveadmissionHiveadmission_rbac_role_bindingYaml, nil
}

func configHiveadmissionHiveadmission_rbac_role_bindingYaml() (*asset, error) {
	bytes, err := configHiveadmissionHiveadmission_rbac_role_bindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/hiveadmission_rbac_role_binding.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionMachinepoolWebhookYaml = []byte(`---
apiVersion: admissionregistration.k8s.io/v1beta1
kind: ValidatingWebhookConfiguration
metadata:
  name: machinepoolvalidators.admission.hive.openshift.io
webhooks:
- name: machinepoolvalidators.admission.hive.openshift.io
  clientConfig:
    service:
      # reach the webhook via the registered aggregated API
      namespace: default
      name: kubernetes
      path: /apis/admission.hive.openshift.io/v1/machinepoolvalidators
  rules:
  - operations:
    - CREATE
    - UPDATE
    apiGroups:
    - hive.openshift.io
    apiVersions:
    - v1
    resources:
    - machinepools
  failurePolicy: Fail
`)

func configHiveadmissionMachinepoolWebhookYamlBytes() ([]byte, error) {
	return _configHiveadmissionMachinepoolWebhookYaml, nil
}

func configHiveadmissionMachinepoolWebhookYaml() (*asset, error) {
	bytes, err := configHiveadmissionMachinepoolWebhookYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/machinepool-webhook.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionSelectorsyncsetWebhookYaml = []byte(`---
apiVersion: admissionregistration.k8s.io/v1beta1
kind: ValidatingWebhookConfiguration
metadata:
  name: selectorsyncsetvalidators.admission.hive.openshift.io
webhooks:
- name: selectorsyncsetvalidators.admission.hive.openshift.io
  clientConfig:
    service:
      # reach the webhook via the registered aggregated API
      namespace: default
      name: kubernetes
      path: /apis/admission.hive.openshift.io/v1/selectorsyncsetvalidators
  rules:
  - operations:
    - CREATE
    - UPDATE
    apiGroups:
    - hive.openshift.io
    apiVersions:
    - v1
    resources:
    - selectorsyncsets
  failurePolicy: Fail
`)

func configHiveadmissionSelectorsyncsetWebhookYamlBytes() ([]byte, error) {
	return _configHiveadmissionSelectorsyncsetWebhookYaml, nil
}

func configHiveadmissionSelectorsyncsetWebhookYaml() (*asset, error) {
	bytes, err := configHiveadmissionSelectorsyncsetWebhookYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/selectorsyncset-webhook.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionServiceAccountYaml = []byte(`---
# to be able to assign powers to the hiveadmission process
apiVersion: v1
kind: ServiceAccount
metadata:
  namespace: hive
  name: hiveadmission
`)

func configHiveadmissionServiceAccountYamlBytes() ([]byte, error) {
	return _configHiveadmissionServiceAccountYaml, nil
}

func configHiveadmissionServiceAccountYaml() (*asset, error) {
	bytes, err := configHiveadmissionServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/service-account.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionServiceYaml = []byte(`---
apiVersion: v1
kind: Service
metadata:
  namespace: hive
  name: hiveadmission
  annotations:
    service.alpha.openshift.io/serving-cert-secret-name: hiveadmission-serving-cert
spec:
  selector:
    app: hiveadmission
  ports:
  - port: 443
    targetPort: 9443
`)

func configHiveadmissionServiceYamlBytes() ([]byte, error) {
	return _configHiveadmissionServiceYaml, nil
}

func configHiveadmissionServiceYaml() (*asset, error) {
	bytes, err := configHiveadmissionServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/service.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configHiveadmissionSyncsetWebhookYaml = []byte(`---
apiVersion: admissionregistration.k8s.io/v1beta1
kind: ValidatingWebhookConfiguration
metadata:
  name: syncsetvalidators.admission.hive.openshift.io
webhooks:
- name: syncsetvalidators.admission.hive.openshift.io
  clientConfig:
    service:
      # reach the webhook via the registered aggregated API
      namespace: default
      name: kubernetes
      path: /apis/admission.hive.openshift.io/v1/syncsetvalidators
  rules:
  - operations:
    - CREATE
    - UPDATE
    apiGroups:
    - hive.openshift.io
    apiVersions:
    - v1
    resources:
    - syncsets
  failurePolicy: Fail
`)

func configHiveadmissionSyncsetWebhookYamlBytes() ([]byte, error) {
	return _configHiveadmissionSyncsetWebhookYaml, nil
}

func configHiveadmissionSyncsetWebhookYaml() (*asset, error) {
	bytes, err := configHiveadmissionSyncsetWebhookYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/hiveadmission/syncset-webhook.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configManagerDeploymentYaml = []byte(`apiVersion: apps/v1
kind: Deployment
metadata:
  name: hive-controllers
  namespace: hive
  labels:
    control-plane: controller-manager
    controller-tools.k8s.io: "1.0"
spec:
  selector:
    matchLabels:
      control-plane: controller-manager
      controller-tools.k8s.io: "1.0"
  replicas: 1
  revisionHistoryLimit: 4
  template:
    metadata:
      labels:
        control-plane: controller-manager
        controller-tools.k8s.io: "1.0"
    spec:
      serviceAccountName: default
      volumes:
      - name: kubectl-cache
        emptyDir: {}
      containers:
      # By default we will use the latest CI images published from hive master:
      - image: registry.svc.ci.openshift.org/openshift/hive-v4.0:hive
        imagePullPolicy: Always
        name: manager
        resources:
          requests:
            cpu: 50m
            memory: 512Mi
        command:
          - /opt/services/manager
        volumeMounts:
        - name: kubectl-cache
          mountPath: /var/cache/kubectl
        env:
        - name: CLI_CACHE_DIR
          value: /var/cache/kubectl
        livenessProbe:
          httpGet:
            path: /debug/health
            port: 8080
          initialDelaySeconds: 10
          failureThreshold: 1
          periodSeconds: 10
      terminationGracePeriodSeconds: 10
`)

func configManagerDeploymentYamlBytes() ([]byte, error) {
	return _configManagerDeploymentYaml, nil
}

func configManagerDeploymentYaml() (*asset, error) {
	bytes, err := configManagerDeploymentYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/manager/deployment.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configManagerServiceYaml = []byte(`apiVersion: v1
kind: Service
metadata:
  name: hive-controllers
  namespace: hive
  labels:
    control-plane: controller-manager
    controller-tools.k8s.io: "1.0"
spec:
  selector:
    control-plane: controller-manager
    controller-tools.k8s.io: "1.0"
  ports:
  - name: metrics
    port: 2112
`)

func configManagerServiceYamlBytes() ([]byte, error) {
	return _configManagerServiceYaml, nil
}

func configManagerServiceYaml() (*asset, error) {
	bytes, err := configManagerServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/manager/service.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configRbacHive_admin_roleYaml = []byte(`# hive-admin is a role intended for hive administrators who need to be able to debug
# cluster installations, and modify hive configuration.
apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRole
metadata:
  name: hive-admin
rules:
- apiGroups:
  - batch
  resources:
  - jobs
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - ""
  resources:
  - pods
  - pods/log
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterdeployments
  - clusterprovisions
  - dnszones
  - machinepools
  - machinepoolnameleases
  - selectorsyncidentityproviders
  - syncidentityproviders
  - syncsets
  - syncsetinstances
  - clusterdeprovisions
  # TODO: remove once v1alpha1 compat removed
  - clusterdeprovisionrequests
  - clusterstates
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterimagesets
  - hiveconfigs
  - selectorsyncsets
  - selectorsyncidentityproviders
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - admission.hive.openshift.io
  resources:
  - clusterdeployments
  - clusterimagesets
  - clusterprovisions
  - dnszones
  - machinepools
  - selectorsyncsets
  - syncsets
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - apiextensions.k8s.io
  resources:
  - customresourcedefinitions
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - apiregistration.k8s.io
  resources:
  - apiservices
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - admissionregistration.k8s.io
  resources:
  - mutatingwebhookconfigurations
  - validatingwebhookconfigurations
  verbs:
  - get
  - list
  - watch
`)

func configRbacHive_admin_roleYamlBytes() ([]byte, error) {
	return _configRbacHive_admin_roleYaml, nil
}

func configRbacHive_admin_roleYaml() (*asset, error) {
	bytes, err := configRbacHive_admin_roleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/rbac/hive_admin_role.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configRbacHive_admin_role_bindingYaml = []byte(`# NOTE: This binding uses the openshift apigroup as it is the only way to link
# to an openshift user group. This will not work if running hive on vanilla Kube,
# but the Hive operator will detect this and skip creation of the binding.
apiVersion: authorization.openshift.io/v1
kind: ClusterRoleBinding
metadata:
  name: hive-admin
roleRef:
  name: hive-admin
groupNames:
- hive-admins
subjects:
- kind: Group
  name: hive-admins
`)

func configRbacHive_admin_role_bindingYamlBytes() ([]byte, error) {
	return _configRbacHive_admin_role_bindingYaml, nil
}

func configRbacHive_admin_role_bindingYaml() (*asset, error) {
	bytes, err := configRbacHive_admin_role_bindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/rbac/hive_admin_role_binding.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configRbacHive_controllers_roleYaml = []byte(`apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRole
metadata:
  creationTimestamp: null
  name: manager-role
rules:
- apiGroups:
  - batch
  resources:
  - jobs
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - ""
  resources:
  - serviceaccounts
  - secrets
  - configmaps
  - events
  - persistentvolumeclaims
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - ""
  resources:
  - pods
  - namespaces
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - rbac.authorization.k8s.io
  resources:
  - roles
  - rolebindings
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterdeployments
  - clusterdeployments/status
  - clusterdeployments/finalizers
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterprovisions
  verbs:
  - get
  - list
  - watch
  - create
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterimagesets
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterimagesets/status
  verbs:
  - get
  - update
  - patch
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterdeprovisions
  - clusterdeprovisions/finalizers
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterdeprovisions/status
  verbs:
  - get
  - update
  - patch
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterprovisions
  - clusterprovisions/status
  - clusterprovisions/finalizers
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - hive.openshift.io
  resources:
  - machinepools
  - machinepools/status
  - machinepools/finalizers
  - machinepoolnameleases
  - machinepoolnameleases/status
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - batch
  resources:
  - jobs
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterstates
  - clusterstates/status
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - hive.openshift.io
  resources:
  - dnszones
  - dnszones/status
  - dnszones/finalizers
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterdeployments
  verbs:
  - get
  - watch
  - update
- apiGroups:
  - hive.openshift.io
  resources:
  - syncsets
  verbs:
  - get
  - create
  - update
  - delete
  - patch
  - list
  - watch
- apiGroups:
  - hive.openshift.io
  resources:
  - syncidentityproviders
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - hive.openshift.io
  resources:
  - selectorsyncidentityproviders
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterdeployments
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterdeployments
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - hive.openshift.io
  resources:
  - syncsets
  verbs:
  - get
  - create
  - update
  - delete
  - patch
  - list
  - watch
- apiGroups:
  - hive.openshift.io
  resources:
  - selectorsyncsets
  verbs:
  - get
  - create
  - update
  - delete
  - patch
  - list
  - watch
- apiGroups:
  - hive.openshift.io
  resources:
  - syncsetinstances
  - syncsetinstances/status
  verbs:
  - get
  - create
  - update
  - delete
  - patch
  - list
  - watch
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterdeployments
  - syncsets
  verbs:
  - get
  - list
  - watch
  - create
  - update
- apiGroups:
  - velero.io
  resources:
  - backups
  verbs:
  - create
`)

func configRbacHive_controllers_roleYamlBytes() ([]byte, error) {
	return _configRbacHive_controllers_roleYaml, nil
}

func configRbacHive_controllers_roleYaml() (*asset, error) {
	bytes, err := configRbacHive_controllers_roleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/rbac/hive_controllers_role.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configRbacHive_controllers_role_bindingYaml = []byte(`apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  creationTimestamp: null
  name: manager-rolebinding
roleRef:
  apiGroup: rbac.authorization.k8s.io
  kind: ClusterRole
  name: manager-role
subjects:
- kind: ServiceAccount
  name: default
  namespace: system
`)

func configRbacHive_controllers_role_bindingYamlBytes() ([]byte, error) {
	return _configRbacHive_controllers_role_bindingYaml, nil
}

func configRbacHive_controllers_role_bindingYaml() (*asset, error) {
	bytes, err := configRbacHive_controllers_role_bindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/rbac/hive_controllers_role_binding.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configRbacHive_frontend_roleYaml = []byte(`# hive-frontend is a role intended for integrating applications acting as a frontend
# to Hive. These applications will need quite powerful permissions in the Hive cluster
# to create namespaces to organize clusters, as well as all the required objects in those
# clusters.
apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRole
metadata:
  name: hive-frontend
rules:
- apiGroups:
  - batch
  resources:
  - jobs
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - ""
  resources:
  - pods
  - pods/log
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - ""
  resources:
  - secrets
  - configmaps
  - events
  - namespaces
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterdeployments
  - clusterprovisions
  - dnszones
  - machinepools
  - selectorsyncidentityproviders
  - syncidentityproviders
  - selectorsyncsets
  - syncsets
  - clusterdeprovisions
  # TODO: remove once v1alpha1 compat removed
  - clusterdeprovisionrequests
  - clusterstates
  verbs:
  - get
  - list
  - watch
  - create
  - update
  - patch
  - delete
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterimagesets
  - hiveconfigs
  verbs:
  - get
  - list
  - watch
`)

func configRbacHive_frontend_roleYamlBytes() ([]byte, error) {
	return _configRbacHive_frontend_roleYaml, nil
}

func configRbacHive_frontend_roleYaml() (*asset, error) {
	bytes, err := configRbacHive_frontend_roleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/rbac/hive_frontend_role.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configRbacHive_frontend_role_bindingYaml = []byte(`apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  creationTimestamp: null
  name: hive-frontend
roleRef:
  apiGroup: rbac.authorization.k8s.io
  kind: ClusterRole
  name: hive-frontend
subjects:
- kind: ServiceAccount
  name: hive-frontend
  namespace: hive
- kind: Group
  name: hive-frontend
`)

func configRbacHive_frontend_role_bindingYamlBytes() ([]byte, error) {
	return _configRbacHive_frontend_role_bindingYaml, nil
}

func configRbacHive_frontend_role_bindingYaml() (*asset, error) {
	bytes, err := configRbacHive_frontend_role_bindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/rbac/hive_frontend_role_binding.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configRbacHive_frontend_serviceaccountYaml = []byte(`apiVersion: v1
kind: ServiceAccount
metadata:
  name: hive-frontend
  namespace: hive
`)

func configRbacHive_frontend_serviceaccountYamlBytes() ([]byte, error) {
	return _configRbacHive_frontend_serviceaccountYaml, nil
}

func configRbacHive_frontend_serviceaccountYaml() (*asset, error) {
	bytes, err := configRbacHive_frontend_serviceaccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/rbac/hive_frontend_serviceaccount.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configRbacHive_reader_roleYaml = []byte(`# hive-admin is a role intended for hive administrators who need to be able to debug
# cluster installations, and modify hive configuration.
apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRole
metadata:
  name: hive-reader
rules:
- apiGroups:
  - batch
  resources:
  - jobs
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - ""
  resources:
  - pods
  - pods/log
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterdeployments
  - clusterprovisions
  - dnszones
  - machinepools
  - selectorsyncidentityproviders
  - selectorsyncsets
  - syncidentityproviders
  - syncsets
  - syncsetinstances
  - clusterdeprovisions
  # TODO: remove once v1alpha1 compat removed
  - clusterdeprovisionrequests
  - clusterstates
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - hive.openshift.io
  resources:
  - clusterimagesets
  - hiveconfigs
  verbs:
  - get
  - list
  - watch
- apiGroups:
  - apiextensions.k8s.io
  resources:
  - customresourcedefinitions
  verbs:
  - get
  - list
  - watch
`)

func configRbacHive_reader_roleYamlBytes() ([]byte, error) {
	return _configRbacHive_reader_roleYaml, nil
}

func configRbacHive_reader_roleYaml() (*asset, error) {
	bytes, err := configRbacHive_reader_roleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/rbac/hive_reader_role.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configRbacHive_reader_role_bindingYaml = []byte(`# NOTE: This binding uses the openshift apigroup as it is the only way to link
# to an openshift user group. This will not work if running hive on vanilla Kube,
# but the Hive operator will detect this and skip creation of the binding.
apiVersion: authorization.openshift.io/v1
kind: ClusterRoleBinding
metadata:
  name: hive-reader
roleRef:
  name: hive-reader
groupNames:
- hive-readers
subjects:
- kind: Group
  name: hive-readers
`)

func configRbacHive_reader_role_bindingYamlBytes() ([]byte, error) {
	return _configRbacHive_reader_role_bindingYaml, nil
}

func configRbacHive_reader_role_bindingYaml() (*asset, error) {
	bytes, err := configRbacHive_reader_role_bindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/rbac/hive_reader_role_binding.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_checkpointYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: checkpoints.hive.openshift.io
spec:
  group: hive.openshift.io
  names:
    kind: Checkpoint
    plural: checkpoints
  scope: Namespaced
  subresources:
    status: {}
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            lastBackupChecksum:
              description: LastBackupChecksum is the checksum of all Hive objects
                in the namespace at the time of the last backup.
              type: string
            lastBackupRef:
              description: LastBackupRef is a reference to last backup object created
              properties:
                name:
                  type: string
                namespace:
                  type: string
              type: object
            lastBackupTime:
              description: LastBackupTime is the last time we performed a backup of
                the namespace
              format: date-time
              type: string
          type: object
        status:
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_checkpointYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_checkpointYaml, nil
}

func configCrdsHive_v1_checkpointYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_checkpointYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_checkpoint.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_clusterdeploymentYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: clusterdeployments.hive.openshift.io
spec:
  additionalPrinterColumns:
  - JSONPath: .spec.clusterName
    name: ClusterName
    type: string
  - JSONPath: .metadata.labels.hive\.openshift\.io/cluster-type
    name: ClusterType
    type: string
  - JSONPath: .spec.baseDomain
    name: BaseDomain
    type: string
  - JSONPath: .spec.installed
    name: Installed
    type: boolean
  - JSONPath: .spec.clusterMetadata.infraID
    name: InfraID
    type: string
  - JSONPath: .metadata.creationTimestamp
    name: Age
    type: date
  group: hive.openshift.io
  names:
    kind: ClusterDeployment
    plural: clusterdeployments
    shortNames:
    - cd
  scope: Namespaced
  subresources:
    status: {}
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            baseDomain:
              description: BaseDomain is the base domain to which the cluster should
                belong.
              type: string
            certificateBundles:
              description: CertificateBundles is a list of certificate bundles associated
                with this cluster
              items:
                properties:
                  certificateSecretRef:
                    description: CertificateSecretRef is the reference to the secret
                      that contains the certificate bundle. If the certificate bundle
                      is to be generated, it will be generated with the name in this
                      reference. Otherwise, it is expected that the secret should
                      exist in the same namespace as the ClusterDeployment
                    type: object
                  generate:
                    description: Generate indicates whether this bundle should have
                      real certificates generated for it.
                    type: boolean
                  name:
                    description: Name is an identifier that must be unique within
                      the bundle and must be referenced by an ingress or by the control
                      plane serving certs
                    type: string
                required:
                - name
                type: object
              type: array
            clusterMetadata:
              description: ClusterMetadata contains metadata information about the
                installed cluster.
              properties:
                adminKubeconfigSecretRef:
                  description: AdminKubeconfigSecretRef references the secret containing
                    the admin kubeconfig for this cluster.
                  type: object
                adminPasswordSecretRef:
                  description: AdminPasswordSecretRef references the secret containing
                    the admin username/password which can be used to login to this
                    cluster.
                  type: object
                clusterID:
                  description: ClusterID is a globally unique identifier for this
                    cluster generated during installation. Used for reporting metrics
                    among other places.
                  type: string
                infraID:
                  description: InfraID is an identifier for this cluster generated
                    during installation and used for tagging/naming resources in cloud
                    providers.
                  type: string
              type: object
            clusterName:
              description: ClusterName is the friendly name of the cluster. It is
                used for subdomains, some resource tagging, and other instances where
                a friendly name for the cluster is useful.
              type: string
            controlPlaneConfig:
              description: ControlPlaneConfig contains additional configuration for
                the target cluster's control plane
              properties:
                apiURLOverride:
                  description: APIURLOverride is the optional URL override to which
                    Hive will transition for communication with the API server of
                    the remote cluster. When a remote cluster is created, Hive will
                    initially communicate using the API URL established during installation.
                    If an API URL Override is specified, Hive will periodically attempt
                    to connect to the remote cluster using the override URL. Once
                    Hive has determined that the override URL is active, Hive will
                    use the override URL for further communications with the API server
                    of the remote cluster.
                  type: string
                servingCertificates:
                  description: ServingCertificates specifies serving certificates
                    for the control plane
                  properties:
                    additional:
                      description: Additional is a list of additional domains and
                        certificates that are also associated with the control plane's
                        api endpoint.
                      items:
                        properties:
                          domain:
                            description: Domain is the domain of the additional control
                              plane certificate
                            type: string
                          name:
                            description: Name references a CertificateBundle in the
                              ClusterDeployment.Spec that should be used for this
                              additional certificate.
                            type: string
                        type: object
                      type: array
                    default:
                      description: Default references the name of a CertificateBundle
                        in the ClusterDeployment that should be used for the control
                        plane's default endpoint.
                      type: string
                  type: object
              type: object
            ingress:
              description: Ingress allows defining desired clusteringress/shards to
                be configured on the cluster.
              items:
                properties:
                  domain:
                    description: Domain (sometimes referred to as shard) is the full
                      DNS suffix that the resulting IngressController object will
                      service (eg abcd.mycluster.mydomain.com).
                    type: string
                  name:
                    description: Name of the ClusterIngress object to create.
                    type: string
                  namespaceSelector:
                    description: NamespaceSelector allows filtering the list of namespaces
                      serviced by the ingress controller.
                    type: object
                  routeSelector:
                    description: RouteSelector allows filtering the set of Routes
                      serviced by the ingress controller
                    type: object
                  servingCertificate:
                    description: ServingCertificate references a CertificateBundle
                      in the ClusterDeployment.Spec that should be used for this Ingress
                    type: string
                required:
                - name
                - domain
                type: object
              type: array
            installed:
              description: Installed is true if the cluster has been installed
              type: boolean
            manageDNS:
              description: ManageDNS specifies whether a DNSZone should be created
                and managed automatically for this ClusterDeployment
              type: boolean
            platform:
              description: Platform is the configuration for the specific platform
                upon which to perform the installation.
              properties:
                aws:
                  description: AWS is the configuration used when installing on AWS.
                  properties:
                    credentialsSecretRef:
                      description: CredentialsSecretRef refers to a secret that contains
                        the AWS account access credentials.
                      type: object
                    region:
                      description: Region specifies the AWS region where the cluster
                        will be created.
                      type: string
                    userTags:
                      description: UserTags specifies additional tags for AWS resources
                        created for the cluster.
                      type: object
                  type: object
                azure:
                  description: Azure is the configuration used when installing on
                    Azure.
                  properties:
                    baseDomainResourceGroupName:
                      description: BaseDomainResourceGroupName specifies the resource
                        group where the azure DNS zone for the base domain is found
                      type: string
                    credentialsSecretRef:
                      description: CredentialsSecretRef refers to a secret that contains
                        the Azure account access credentials.
                      type: object
                    region:
                      description: Region specifies the Azure region where the cluster
                        will be created.
                      type: string
                  type: object
                bareMetal:
                  description: BareMetal is the configuration used when installing
                    on bare metal.
                  properties:
                    libvirtSSHPrivateKeySecretRef:
                      description: LibvirtSSHPrivateKeySecretRef is the reference
                        to the secret that contains the private SSH key to use for
                        access to the libvirt provisioning host. The SSH private key
                        is expected to be in the secret data under the "ssh-privatekey"
                        key.
                      type: object
                  type: object
                gcp:
                  description: GCP is the configuration used when installing on Google
                    Cloud Platform.
                  properties:
                    credentialsSecretRef:
                      description: CredentialsSecretRef refers to a secret that contains
                        the GCP account access credentials.
                      type: object
                    region:
                      description: Region specifies the GCP region where the cluster
                        will be created.
                      type: string
                  type: object
              type: object
            preserveOnDelete:
              description: PreserveOnDelete allows the user to disconnect a cluster
                from Hive without deprovisioning it
              type: boolean
            provisioning:
              description: Provisioning contains settings used only for initial cluster
                provisioning. May be unset in the case of adopted clusters.
              properties:
                imageSetRef:
                  description: ImageSetRef is a reference to a ClusterImageSet. If
                    a value is specified for ReleaseImage, that will take precedence
                    over the one from the ClusterImageSet.
                  properties:
                    name:
                      description: Name is the name of the ClusterImageSet that this
                        refers to
                      type: string
                  type: object
                installConfigSecretRef:
                  description: InstallConfigSecretRef is the reference to a secret
                    that contains an openshift-install InstallConfig. This file will
                    be passed through directly to the installer. Any version of InstallConfig
                    can be used, provided it can be parsed by the openshift-install
                    version for the release you are provisioning.
                  type: object
                installerEnv:
                  description: InstallerEnv are extra environment variables to pass
                    through to the installer. This may be used to enable additional
                    features of the installer.
                  items:
                    type: object
                  type: array
                manifestsConfigMapRef:
                  description: ManifestsConfigMapRef is a reference to user-provided
                    manifests to add to or replace manifests that are generated by
                    the installer.
                  type: object
                releaseImage:
                  description: ReleaseImage is the image containing metadata for all
                    components that run in the cluster, and is the primary and best
                    way to specify what specific version of OpenShift you wish to
                    install.
                  type: string
                sshKnownHosts:
                  description: SSHKnownHosts are known hosts to be configured in the
                    hive install manager pod to avoid ssh prompts. Use of ssh in the
                    install pod is somewhat limited today (failure log gathering from
                    cluster, some bare metal provisioning scenarios), so this setting
                    is often not needed.
                  items:
                    type: string
                  type: array
                sshPrivateKeySecretRef:
                  description: SSHPrivateKeySecretRef is the reference to the secret
                    that contains the private SSH key to use for access to compute
                    instances. This private key should correspond to the public key
                    included in the InstallConfig. The private key is used by Hive
                    to gather logs on the target cluster if there are install failures.
                    The SSH private key is expected to be in the secret data under
                    the "ssh-privatekey" key.
                  type: object
              type: object
            pullSecretRef:
              description: PullSecretRef is the reference to the secret to use when
                pulling images.
              type: object
          required:
          - clusterName
          - baseDomain
          - platform
          type: object
        status:
          properties:
            apiURL:
              description: APIURL is the URL where the cluster's API can be accessed.
              type: string
            certificateBundles:
              description: CertificateBundles contains of the status of the certificate
                bundles associated with this cluster deployment.
              items:
                properties:
                  generated:
                    description: Generated indicates whether the certificate bundle
                      was generated
                    type: boolean
                  name:
                    description: Name of the certificate bundle
                    type: string
                type: object
              type: array
            cliImage:
              description: CLIImage is the name of the oc cli image to use when installing
                the target cluster
              type: string
            clusterVersionStatus:
              description: ClusterVersionStatus will hold a copy of the remote cluster's
                ClusterVersion.Status
              properties:
                availableUpdates:
                  description: availableUpdates contains the list of updates that
                    are appropriate for this cluster. This list may be empty if no
                    updates are recommended, if the update service is unavailable,
                    or if an invalid channel has been specified.
                  items:
                    properties:
                      force:
                        description: force allows an administrator to update to an
                          image that has failed verification, does not appear in the
                          availableUpdates list, or otherwise would be blocked by
                          normal protections on update. This option should only be
                          used when the authenticity of the provided image has been
                          verified out of band because the provided image will run
                          with full administrative access to the cluster. Do not use
                          this flag with images that comes from unknown or potentially
                          malicious sources.  This flag does not override other forms
                          of consistency checking that are required before a new update
                          is deployed.
                        type: boolean
                      image:
                        description: image is a container image location that contains
                          the update. When this field is part of spec, image is optional
                          if version is specified and the availableUpdates field contains
                          a matching version.
                        type: string
                      version:
                        description: version is a semantic versioning identifying
                          the update version. When this field is part of spec, version
                          is optional if image is specified.
                        type: string
                    type: object
                  nullable: true
                  type: array
                conditions:
                  description: conditions provides information about the cluster version.
                    The condition "Available" is set to true if the desiredUpdate
                    has been reached. The condition "Progressing" is set to true if
                    an update is being applied. The condition "Degraded" is set to
                    true if an update is currently blocked by a temporary or permanent
                    error. Conditions are only valid for the current desiredUpdate
                    when metadata.generation is equal to status.generation.
                  items:
                    properties:
                      lastTransitionTime:
                        description: lastTransitionTime is the time of the last update
                          to the current status object.
                        format: date-time
                        type: string
                      message:
                        description: message provides additional information about
                          the current condition. This is only to be consumed by humans.
                        type: string
                      reason:
                        description: reason is the reason for the condition's last
                          transition.  Reasons are CamelCase
                        type: string
                      status:
                        description: status of the condition, one of True, False,
                          Unknown.
                        type: string
                      type:
                        description: type specifies the state of the operator's reconciliation
                          functionality.
                        type: string
                    type: object
                  type: array
                desired:
                  description: desired is the version that the cluster is reconciling
                    towards. If the cluster is not yet fully initialized desired will
                    be set with the information available, which may be an image or
                    a tag.
                  properties:
                    force:
                      description: force allows an administrator to update to an image
                        that has failed verification, does not appear in the availableUpdates
                        list, or otherwise would be blocked by normal protections
                        on update. This option should only be used when the authenticity
                        of the provided image has been verified out of band because
                        the provided image will run with full administrative access
                        to the cluster. Do not use this flag with images that comes
                        from unknown or potentially malicious sources.  This flag
                        does not override other forms of consistency checking that
                        are required before a new update is deployed.
                      type: boolean
                    image:
                      description: image is a container image location that contains
                        the update. When this field is part of spec, image is optional
                        if version is specified and the availableUpdates field contains
                        a matching version.
                      type: string
                    version:
                      description: version is a semantic versioning identifying the
                        update version. When this field is part of spec, version is
                        optional if image is specified.
                      type: string
                  type: object
                history:
                  description: history contains a list of the most recent versions
                    applied to the cluster. This value may be empty during cluster
                    startup, and then will be updated when a new update is being applied.
                    The newest update is first in the list and it is ordered by recency.
                    Updates in the history have state Completed if the rollout completed
                    - if an update was failing or halfway applied the state will be
                    Partial. Only a limited amount of update history is preserved.
                  items:
                    properties:
                      completionTime:
                        description: completionTime, if set, is when the update was
                          fully applied. The update that is currently being applied
                          will have a null completion time. Completion time will always
                          be set for entries that are not the current update (usually
                          to the started time of the next update).
                        format: date-time
                        nullable: true
                        type: string
                      image:
                        description: image is a container image location that contains
                          the update. This value is always populated.
                        type: string
                      startedTime:
                        description: startedTime is the time at which the update was
                          started.
                        format: date-time
                        type: string
                      state:
                        description: state reflects whether the update was fully applied.
                          The Partial state indicates the update is not fully applied,
                          while the Completed state indicates the update was successfully
                          rolled out at least once (all parts of the update successfully
                          applied).
                        type: string
                      verified:
                        description: verified indicates whether the provided update
                          was properly verified before it was installed. If this is
                          false the cluster may not be trusted.
                        type: boolean
                      version:
                        description: version is a semantic versioning identifying
                          the update version. If the requested image does not define
                          a version, or if a failure occurs retrieving the image,
                          this value may be empty.
                        type: string
                    type: object
                  type: array
                observedGeneration:
                  description: observedGeneration reports which version of the spec
                    is being synced. If this value is not equal to metadata.generation,
                    then the desired and conditions fields may represent from a previous
                    version.
                  format: int64
                  type: integer
                versionHash:
                  description: versionHash is a fingerprint of the content that the
                    cluster will be updated with. It is used by the operator to avoid
                    unnecessary work and is for internal use only.
                  type: string
              type: object
            conditions:
              description: Conditions includes more detailed status for the cluster
                deployment
              items:
                properties:
                  lastProbeTime:
                    description: LastProbeTime is the last time we probed the condition.
                    format: date-time
                    type: string
                  lastTransitionTime:
                    description: LastTransitionTime is the last time the condition
                      transitioned from one status to another.
                    format: date-time
                    type: string
                  message:
                    description: Message is a human-readable message indicating details
                      about last transition.
                    type: string
                  reason:
                    description: Reason is a unique, one-word, CamelCase reason for
                      the condition's last transition.
                    type: string
                  status:
                    description: Status is the status of the condition.
                    type: string
                  type:
                    description: Type is the type of the condition.
                    type: string
                type: object
              type: array
            installRestarts:
              description: InstallRestarts is the total count of container restarts
                on the clusters install job.
              format: int64
              type: integer
            installedTimestamp:
              description: InstalledTimestamp is the time we first detected that the
                cluster has been successfully installed.
              format: date-time
              type: string
            installerImage:
              description: InstallerImage is the name of the installer image to use
                when installing the target cluster
              type: string
            provisionRef:
              description: ProvisionRef is a reference to the last ClusterProvision
                created for the deployment
              type: object
            webConsoleURL:
              description: WebConsoleURL is the URL for the cluster's web console
                UI.
              type: string
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_clusterdeploymentYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_clusterdeploymentYaml, nil
}

func configCrdsHive_v1_clusterdeploymentYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_clusterdeploymentYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_clusterdeployment.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_clusterdeprovisionYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: clusterdeprovisions.hive.openshift.io
spec:
  additionalPrinterColumns:
  - JSONPath: .spec.infraID
    name: InfraID
    type: string
  - JSONPath: .spec.clusterID
    name: ClusterID
    type: string
  - JSONPath: .status.completed
    name: Completed
    type: boolean
  - JSONPath: .metadata.creationTimestamp
    name: Age
    type: date
  group: hive.openshift.io
  names:
    kind: ClusterDeprovision
    plural: clusterdeprovisions
    shortNames:
    - cdr
  scope: Namespaced
  subresources:
    status: {}
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            clusterID:
              description: ClusterID is a globally unique identifier for the cluster
                to deprovision. It will be used if specified.
              type: string
            infraID:
              description: InfraID is the identifier generated during installation
                for a cluster. It is used for tagging/naming resources in cloud providers.
              type: string
            platform:
              description: Platform contains platform-specific configuration for a
                ClusterDeprovision
              properties:
                aws:
                  description: AWS contains AWS-specific deprovision settings
                  properties:
                    credentialsSecretRef:
                      description: CredentialsSecretRef is the AWS account credentials
                        to use for deprovisioning the cluster
                      type: object
                    region:
                      description: Region is the AWS region for this deprovisioning
                      type: string
                  type: object
                azure:
                  description: Azure contains Azure-specific deprovision settings
                  properties:
                    credentialsSecretRef:
                      description: CredentialsSecretRef is the Azure account credentials
                        to use for deprovisioning the cluster
                      type: object
                  type: object
                gcp:
                  description: GCP contains GCP-specific deprovision settings
                  properties:
                    credentialsSecretRef:
                      description: CredentialsSecretRef is the GCP account credentials
                        to use for deprovisioning the cluster
                      type: object
                    region:
                      description: Region is the GCP region for this deprovision
                      type: string
                  type: object
              type: object
          type: object
        status:
          properties:
            completed:
              description: Completed is true when the uninstall has completed successfully
              type: boolean
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_clusterdeprovisionYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_clusterdeprovisionYaml, nil
}

func configCrdsHive_v1_clusterdeprovisionYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_clusterdeprovisionYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_clusterdeprovision.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_clusterimagesetYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: clusterimagesets.hive.openshift.io
spec:
  additionalPrinterColumns:
  - JSONPath: .spec.releaseImage
    name: Release
    type: string
  group: hive.openshift.io
  names:
    kind: ClusterImageSet
    plural: clusterimagesets
    shortNames:
    - imgset
  scope: Cluster
  subresources:
    status: {}
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            releaseImage:
              description: ReleaseImage is the image that contains the payload to
                use when installing a cluster.
              type: string
          type: object
        status:
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_clusterimagesetYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_clusterimagesetYaml, nil
}

func configCrdsHive_v1_clusterimagesetYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_clusterimagesetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_clusterimageset.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_clusterprovisionYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: clusterprovisions.hive.openshift.io
spec:
  additionalPrinterColumns:
  - JSONPath: .spec.clusterDeploymentRef.name
    name: ClusterDeployment
    type: string
  - JSONPath: .spec.stage
    name: Stage
    type: string
  - JSONPath: .spec.infraID
    name: InfraID
    type: string
  group: hive.openshift.io
  names:
    kind: ClusterProvision
    plural: clusterprovisions
  scope: Namespaced
  subresources:
    status: {}
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            adminKubeconfigSecretRef:
              description: AdminKubeconfigSecretRef references the secret containing
                the admin kubeconfig for this cluster.
              type: object
            adminPasswordSecretRef:
              description: AdminPasswordSecretRef references the secret containing
                the admin username/password which can be used to login to this cluster.
              type: object
            attempt:
              description: Attempt is which attempt number of the cluster deployment
                that this ClusterProvision is
              format: int64
              type: integer
            clusterDeploymentRef:
              description: ClusterDeploymentRef references the cluster deployment
                provisioned.
              type: object
            clusterID:
              description: ClusterID is a globally unique identifier for this cluster
                generated during installation. Used for reporting metrics among other
                places.
              type: string
            infraID:
              description: InfraID is an identifier for this cluster generated during
                installation and used for tagging/naming resources in cloud providers.
              type: string
            installLog:
              description: InstallLog is the log from the installer.
              type: string
            metadata:
              description: Metadata is the metadata.json generated by the installer,
                providing metadata information about the cluster created.
              type: object
            podSpec:
              description: PodSpec is the spec to use for the installer pod.
              type: object
            prevClusterID:
              description: PrevClusterID is the cluster ID of the previous failed
                provision attempt.
              type: string
            prevInfraID:
              description: PrevInfraID is the infra ID of the previous failed provision
                attempt.
              type: string
            stage:
              description: Stage is the stage of provisioning that the cluster deployment
                has reached.
              type: string
          type: object
        status:
          properties:
            conditions:
              description: Conditions includes more detailed status for the cluster
                provision
              items:
                properties:
                  lastProbeTime:
                    description: LastProbeTime is the last time we probed the condition.
                    format: date-time
                    type: string
                  lastTransitionTime:
                    description: LastTransitionTime is the last time the condition
                      transitioned from one status to another.
                    format: date-time
                    type: string
                  message:
                    description: Message is a human-readable message indicating details
                      about last transition.
                    type: string
                  reason:
                    description: Reason is a unique, one-word, CamelCase reason for
                      the condition's last transition.
                    type: string
                  status:
                    description: Status is the status of the condition.
                    type: string
                  type:
                    description: Type is the type of the condition.
                    type: string
                type: object
              type: array
            jobRef:
              description: JobRef is the reference to the job performing the provision.
              type: object
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_clusterprovisionYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_clusterprovisionYaml, nil
}

func configCrdsHive_v1_clusterprovisionYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_clusterprovisionYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_clusterprovision.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_clusterstateYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: clusterstates.hive.openshift.io
spec:
  group: hive.openshift.io
  names:
    kind: ClusterState
    plural: clusterstates
  scope: Namespaced
  subresources:
    status: {}
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          type: object
        status:
          properties:
            clusterOperators:
              description: ClusterOperators contains the state for every cluster operator
                in the target cluster
              items:
                properties:
                  conditions:
                    description: Conditions is the set of conditions in the status
                      of the cluster operator on the target cluster
                    items:
                      properties:
                        lastTransitionTime:
                          description: lastTransitionTime is the time of the last
                            update to the current status object.
                          format: date-time
                          type: string
                        message:
                          description: message provides additional information about
                            the current condition. This is only to be consumed by
                            humans.
                          type: string
                        reason:
                          description: reason is the reason for the condition's last
                            transition.  Reasons are CamelCase
                          type: string
                        status:
                          description: status of the condition, one of True, False,
                            Unknown.
                          type: string
                        type:
                          description: type specifies the state of the operator's
                            reconciliation functionality.
                          type: string
                      type: object
                    type: array
                  name:
                    description: Name is the name of the cluster operator
                    type: string
                type: object
              type: array
            lastUpdated:
              description: LastUpdated is the last time that operator state was updated
              format: date-time
              type: string
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_clusterstateYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_clusterstateYaml, nil
}

func configCrdsHive_v1_clusterstateYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_clusterstateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_clusterstate.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_dnszoneYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: dnszones.hive.openshift.io
spec:
  group: hive.openshift.io
  names:
    kind: DNSZone
    plural: dnszones
  scope: Namespaced
  subresources:
    status: {}
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            aws:
              description: AWS specifies AWS-specific cloud configuration
              properties:
                additionalTags:
                  description: AdditionalTags is a set of additional tags to set on
                    the DNS hosted zone. In addition to these tags,the DNS Zone controller
                    will set a hive.openhsift.io/hostedzone tag identifying the HostedZone
                    record that it belongs to.
                  items:
                    properties:
                      key:
                        description: Key is the key for the tag
                        type: string
                      value:
                        description: Value is the value for the tag
                        type: string
                    type: object
                  type: array
                credentialsSecretRef:
                  description: CredentialsSecretRef contains a reference to a secret
                    that contains AWS credentials for CRUD operations
                  type: object
                region:
                  description: Region is the AWS region to use for route53 operations.
                    This defaults to us-east-1. For AWS China, use cn-northwest-1.
                  type: string
              type: object
            gcp:
              description: GCP specifies GCP-specific cloud configuration
              properties:
                credentialsSecretRef:
                  description: CredentialsSecretRef references a secret that will
                    be used to authenticate with GCP CloudDNS. It will need permission
                    to create and manage CloudDNS Hosted Zones. Secret should have
                    a key named 'osServiceAccount.json'. The credentials must specify
                    the project to use.
                  type: object
              type: object
            linkToParentDomain:
              description: LinkToParentDomain specifies whether DNS records should
                be automatically created to link this DNSZone with a parent domain.
              type: boolean
            zone:
              description: Zone is the DNS zone to host
              type: string
          type: object
        status:
          properties:
            aws:
              description: AWSDNSZoneStatus contains status information specific to
                AWS
              properties:
                zoneID:
                  description: ZoneID is the ID of the zone in AWS
                  type: string
              type: object
            conditions:
              description: Conditions includes more detailed status for the DNSZone
              items:
                properties:
                  lastProbeTime:
                    description: LastProbeTime is the last time we probed the condition.
                    format: date-time
                    type: string
                  lastTransitionTime:
                    description: LastTransitionTime is the last time the condition
                      transitioned from one status to another.
                    format: date-time
                    type: string
                  message:
                    description: Message is a human-readable message indicating details
                      about last transition.
                    type: string
                  reason:
                    description: Reason is a unique, one-word, CamelCase reason for
                      the condition's last transition.
                    type: string
                  status:
                    description: Status is the status of the condition.
                    type: string
                  type:
                    description: Type is the type of the condition.
                    type: string
                type: object
              type: array
            gcp:
              description: GCPDNSZoneStatus contains status information specific to
                GCP
              properties:
                zoneName:
                  description: ZoneName is the name of the zone in GCP Cloud DNS
                  type: string
              type: object
            lastSyncGeneration:
              description: LastSyncGeneration is the generation of the zone resource
                that was last sync'd. This is used to know if the Object has changed
                and we should sync immediately.
              format: int64
              type: integer
            lastSyncTimestamp:
              description: LastSyncTimestamp is the time that the zone was last sync'd.
              format: date-time
              type: string
            nameServers:
              description: NameServers is a list of nameservers for this DNS zone
              items:
                type: string
              type: array
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_dnszoneYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_dnszoneYaml, nil
}

func configCrdsHive_v1_dnszoneYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_dnszoneYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_dnszone.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_hiveconfigYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: hiveconfigs.hive.openshift.io
spec:
  group: hive.openshift.io
  names:
    kind: HiveConfig
    plural: hiveconfigs
  scope: Cluster
  subresources:
    status: {}
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            additionalCertificateAuthoritiesSecretRef:
              description: AdditionalCertificateAuthoritiesSecretRef is a list of
                references to secrets in the 'hive' namespace that contain an additional
                Certificate Authority to use when communicating with target clusters.
                These certificate authorities will be used in addition to any self-signed
                CA generated by each cluster on installation.
              items:
                type: object
              type: array
            backup:
              description: Backup specifies configuration for backup integration.
                If absent, backup integration will be disabled.
              properties:
                minBackupPeriodSeconds:
                  description: MinBackupPeriodSeconds specifies that a minimum of
                    MinBackupPeriodSeconds will occur in between each backup. This
                    is used to rate limit backups. This potentially batches together
                    multiple changes into 1 backup. No backups will be lost as changes
                    that happen during this interval are queued up and will result
                    in a backup happening once the interval has been completed.
                  format: int64
                  type: integer
                velero:
                  description: Velero specifies configuration for the Velero backup
                    integration.
                  properties:
                    enabled:
                      description: Enabled dictates if Velero backup integration is
                        enabled. If not specified, the default is disabled.
                      type: boolean
                  type: object
              type: object
            deprovisionsDisabled:
              description: DeprovisionsDisabled can be set to true to block deprovision
                jobs from running.
              type: boolean
            failedProvisionConfig:
              description: FailedProvisionConfig is used to configure settings related
                to handling provision failures.
              properties:
                skipGatherLogs:
                  description: SkipGatherLogs disables functionality that attempts
                    to gather full logs from the cluster if an installation fails
                    for any reason. The logs will be stored in a persistent volume
                    for up to 7 days.
                  type: boolean
              type: object
            globalPullSecretRef:
              description: GlobalPullSecretRef is used to specify a pull secret that
                will be used globally by all of the cluster deployments. For each
                cluster deployment, the contents of GlobalPullSecret will be merged
                with the specific pull secret for a cluster deployment(if specified),
                with precedence given to the contents of the pull secret for the cluster
                deployment.
              type: object
            hiveAPIEnabled:
              description: HiveAPIEnabled is a boolean controlling whether or not
                the Hive operator will start up the v1alpha1 aggregated API server.
              type: boolean
            logLevel:
              description: LogLevel is the level of logging to use for the Hive controllers.
                Acceptable levels, from coarsest to finest, are panic, fatal, error,
                warn, info, debug, and trace. The default level is info.
              type: string
            maintenanceMode:
              description: MaintenanceMode can be set to true to disable the hive
                controllers in situations where we need to ensure nothing is running
                that will add or act upon finalizers on Hive types. This should rarely
                be needed. Sets replicas to 0 for the hive-controllers deployment
                to accomplish this.
              type: boolean
            managedDomains:
              description: 'ManagedDomains is the list of DNS domains that are managed
                by the Hive cluster When specifying ''managedDNS: true'' in a ClusterDeployment,
                the ClusterDeployment''s baseDomain should be a direct child of one
                of these domains, otherwise the ClusterDeployment creation will result
                in a validation error.'
              items:
                properties:
                  aws:
                    description: AWS contains AWS-specific settings for external DNS
                    properties:
                      credentialsSecretRef:
                        description: CredentialsSecretRef references a secret that
                          will be used to authenticate with AWS Route53. It will need
                          permission to manage entries for the domain listed in the
                          parent ManageDNSConfig object. Secret should have AWS keys
                          named 'aws_access_key_id' and 'aws_secret_access_key'.
                        type: object
                      region:
                        description: Region is the AWS region to use for route53 operations.
                          This defaults to us-east-1. For AWS China, use cn-northwest-1.
                        type: string
                    type: object
                  domains:
                    description: Domains is the list of domains that hive will be
                      managing entries for with the provided credentials.
                    items:
                      type: string
                    type: array
                  gcp:
                    description: GCP contains GCP-specific settings for external DNS
                    properties:
                      credentialsSecretRef:
                        description: CredentialsSecretRef references a secret that
                          will be used to authenticate with GCP DNS. It will need
                          permission to manage entries in each of the managed domains
                          for this cluster. listed in the parent ManageDNSConfig object.
                          Secret should have a key named 'osServiceAccount.json'.
                          The credentials must specify the project to use.
                        type: object
                    type: object
                type: object
              type: array
            syncSetReapplyInterval:
              description: SyncSetReapplyInterval is a string duration indicating
                how much time must pass before SyncSet resources will be reapplied.
                The default reapply interval is two hours.
              type: string
          type: object
        status:
          properties:
            aggregatorClientCAHash:
              description: AggregatorClientCAHash keeps an md5 hash of the aggregator
                client CA configmap data from the openshift-config-managed namespace.
                When the configmap changes, admission is redeployed.
              type: string
            configApplied:
              description: ConfigApplied will be set by the hive operator to indicate
                whether or not the LastGenerationObserved was successfully reconciled.
              type: boolean
            observedGeneration:
              description: ObservedGeneration will record the most recently processed
                HiveConfig object's generation.
              format: int64
              type: integer
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_hiveconfigYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_hiveconfigYaml, nil
}

func configCrdsHive_v1_hiveconfigYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_hiveconfigYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_hiveconfig.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_machinepoolYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: machinepools.hive.openshift.io
spec:
  additionalPrinterColumns:
  - JSONPath: .spec.name
    name: PoolName
    type: string
  - JSONPath: .spec.clusterDeploymentRef.name
    name: ClusterDeployment
    type: string
  - JSONPath: .spec.replicas
    name: Replicas
    type: integer
  group: hive.openshift.io
  names:
    kind: MachinePool
    plural: machinepools
  scope: Namespaced
  subresources:
    scale:
      specReplicasPath: .spec.replicas
      statusReplicasPath: .status.replicas
    status: {}
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            autoscaling:
              description: Autoscaling is the details for auto-scaling the machine
                pool. Replicas and autoscaling cannot be used together.
              properties:
                maxReplicas:
                  description: MaxReplicas is the maximum number of replicas for the
                    machine pool.
                  format: int32
                  type: integer
                minReplicas:
                  description: MinReplicas is the minimum number of replicas for the
                    machine pool.
                  format: int32
                  type: integer
              type: object
            clusterDeploymentRef:
              description: ClusterDeploymentRef references the cluster deployment
                to which this machine pool belongs.
              type: object
            labels:
              description: Map of label string keys and values that will be applied
                to the created MachineSet's MachineSpec. This list will overwrite
                any modifications made to Node labels on an ongoing basis.
              type: object
            name:
              description: Name is the name of the machine pool.
              type: string
            platform:
              description: Platform is configuration for machine pool specific to
                the platform.
              properties:
                aws:
                  description: AWS is the configuration used when installing on AWS.
                  properties:
                    rootVolume:
                      description: EC2RootVolume defines the storage for ec2 instance.
                      properties:
                        iops:
                          description: IOPS defines the iops for the storage.
                          format: int64
                          type: integer
                        size:
                          description: Size defines the size of the storage.
                          format: int64
                          type: integer
                        type:
                          description: Type defines the type of the storage.
                          type: string
                      type: object
                    type:
                      description: InstanceType defines the ec2 instance type. eg.
                        m4-large
                      type: string
                    zones:
                      description: Zones is list of availability zones that can be
                        used.
                      items:
                        type: string
                      type: array
                  type: object
                azure:
                  description: Azure is the configuration used when installing on
                    Azure.
                  properties:
                    osDisk:
                      description: OSDisk defines the storage for instance.
                      properties:
                        diskSizeGB:
                          description: DiskSizeGB defines the size of disk in GB.
                          format: int32
                          type: integer
                      type: object
                    type:
                      description: InstanceType defines the azure instance type. eg.
                        Standard_DS_V2
                      type: string
                    zones:
                      description: Zones is list of availability zones that can be
                        used. eg. ["1", "2", "3"]
                      items:
                        type: string
                      type: array
                  type: object
                gcp:
                  description: GCP is the configuration used when installing on GCP.
                  properties:
                    type:
                      description: InstanceType defines the GCP instance type. eg.
                        n1-standard-4
                      type: string
                    zones:
                      description: Zones is list of availability zones that can be
                        used.
                      items:
                        type: string
                      type: array
                  type: object
              type: object
            replicas:
              description: Replicas is the count of machines for this machine pool.
                Replicas and autoscaling cannot be used together. Default is 1, if
                autoscaling is not used.
              format: int64
              type: integer
            taints:
              description: List of taints that will be applied to the created MachineSet's
                MachineSpec. This list will overwrite any modifications made to Node
                taints on an ongoing basis.
              items:
                type: object
              type: array
          type: object
        status:
          properties:
            conditions:
              description: Conditions includes more detailed status for the cluster
                deployment
              items:
                properties:
                  lastProbeTime:
                    description: LastProbeTime is the last time we probed the condition.
                    format: date-time
                    type: string
                  lastTransitionTime:
                    description: LastTransitionTime is the last time the condition
                      transitioned from one status to another.
                    format: date-time
                    type: string
                  message:
                    description: Message is a human-readable message indicating details
                      about last transition.
                    type: string
                  reason:
                    description: Reason is a unique, one-word, CamelCase reason for
                      the condition's last transition.
                    type: string
                  status:
                    description: Status is the status of the condition.
                    type: string
                  type:
                    description: Type is the type of the condition.
                    type: string
                type: object
              type: array
            machineSets:
              description: MachineSets is the status of the machine sets for the machine
                pool on the remote cluster.
              items:
                properties:
                  maxReplicas:
                    description: MaxReplicas is the maximum number of replicas for
                      the machine set.
                    format: int32
                    type: integer
                  minReplicas:
                    description: MinReplicas is the minimum number of replicas for
                      the machine set.
                    format: int32
                    type: integer
                  name:
                    description: Name is the name of the machine set.
                    type: string
                  replicas:
                    description: Replicas is the current number of replicas for the
                      machine set.
                    format: int32
                    type: integer
                type: object
              type: array
            replicas:
              description: Replicas is the current number of replicas for the machine
                pool.
              format: int32
              type: integer
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_machinepoolYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_machinepoolYaml, nil
}

func configCrdsHive_v1_machinepoolYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_machinepoolYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_machinepool.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_machinepoolnameleaseYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: machinepoolnameleases.hive.openshift.io
spec:
  additionalPrinterColumns:
  - JSONPath: .metadata.labels.hive\.openshift\.io/machine-pool-name
    name: MachinePool
    type: string
  - JSONPath: .metadata.labels.hive\.openshift\.io/cluster-deployment-name
    name: Cluster
    type: string
  - JSONPath: .metadata.creationTimestamp
    name: Age
    type: date
  group: hive.openshift.io
  names:
    kind: MachinePoolNameLease
    plural: machinepoolnameleases
  scope: Namespaced
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          type: object
        status:
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_machinepoolnameleaseYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_machinepoolnameleaseYaml, nil
}

func configCrdsHive_v1_machinepoolnameleaseYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_machinepoolnameleaseYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_machinepoolnamelease.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_selectorsyncidentityproviderYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: selectorsyncidentityproviders.hive.openshift.io
spec:
  group: hive.openshift.io
  names:
    kind: SelectorSyncIdentityProvider
    plural: selectorsyncidentityproviders
  scope: Cluster
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            clusterDeploymentSelector:
              description: ClusterDeploymentSelector is a LabelSelector indicating
                which clusters the SelectorIdentityProvider applies to in any namespace.
              type: object
            identityProviders:
              description: IdentityProviders is an ordered list of ways for a user
                to identify themselves
              items:
                properties:
                  basicAuth:
                    description: basicAuth contains configuration options for the
                      BasicAuth IdP
                    properties:
                      ca:
                        description: ca is an optional reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. The key "ca.crt" is used to locate
                          the data. If specified and the config map or expected key
                          is not found, the identity provider is not honored. If the
                          specified ca data is not valid, the identity provider is
                          not honored. If empty, the default system roots are used.
                          The namespace for this config map is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      tlsClientCert:
                        description: tlsClientCert is an optional reference to a secret
                          by name that contains the PEM-encoded TLS client certificate
                          to present when connecting to the server. The key "tls.crt"
                          is used to locate the data. If specified and the secret
                          or expected key is not found, the identity provider is not
                          honored. If the specified certificate data is not valid,
                          the identity provider is not honored. The namespace for
                          this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      tlsClientKey:
                        description: tlsClientKey is an optional reference to a secret
                          by name that contains the PEM-encoded TLS private key for
                          the client certificate referenced in tlsClientCert. The
                          key "tls.key" is used to locate the data. If specified and
                          the secret or expected key is not found, the identity provider
                          is not honored. If the specified certificate data is not
                          valid, the identity provider is not honored. The namespace
                          for this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      url:
                        description: url is the remote URL to connect to
                        type: string
                    type: object
                  github:
                    description: github enables user authentication using GitHub credentials
                    properties:
                      ca:
                        description: ca is an optional reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. The key "ca.crt" is used to locate
                          the data. If specified and the config map or expected key
                          is not found, the identity provider is not honored. If the
                          specified ca data is not valid, the identity provider is
                          not honored. If empty, the default system roots are used.
                          This can only be configured when hostname is set to a non-empty
                          value. The namespace for this config map is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      clientID:
                        description: clientID is the oauth client ID
                        type: string
                      clientSecret:
                        description: clientSecret is a required reference to the secret
                          by name containing the oauth client secret. The key "clientSecret"
                          is used to locate the data. If the secret or expected key
                          is not found, the identity provider is not honored. The
                          namespace for this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      hostname:
                        description: hostname is the optional domain (e.g. "mycompany.com")
                          for use with a hosted instance of GitHub Enterprise. It
                          must match the GitHub Enterprise settings value configured
                          at /setup/settings#hostname.
                        type: string
                      organizations:
                        description: organizations optionally restricts which organizations
                          are allowed to log in
                        items:
                          type: string
                        type: array
                      teams:
                        description: teams optionally restricts which teams are allowed
                          to log in. Format is <org>/<team>.
                        items:
                          type: string
                        type: array
                    type: object
                  gitlab:
                    description: gitlab enables user authentication using GitLab credentials
                    properties:
                      ca:
                        description: ca is an optional reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. The key "ca.crt" is used to locate
                          the data. If specified and the config map or expected key
                          is not found, the identity provider is not honored. If the
                          specified ca data is not valid, the identity provider is
                          not honored. If empty, the default system roots are used.
                          The namespace for this config map is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      clientID:
                        description: clientID is the oauth client ID
                        type: string
                      clientSecret:
                        description: clientSecret is a required reference to the secret
                          by name containing the oauth client secret. The key "clientSecret"
                          is used to locate the data. If the secret or expected key
                          is not found, the identity provider is not honored. The
                          namespace for this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      url:
                        description: url is the oauth server base URL
                        type: string
                    type: object
                  google:
                    description: google enables user authentication using Google credentials
                    properties:
                      clientID:
                        description: clientID is the oauth client ID
                        type: string
                      clientSecret:
                        description: clientSecret is a required reference to the secret
                          by name containing the oauth client secret. The key "clientSecret"
                          is used to locate the data. If the secret or expected key
                          is not found, the identity provider is not honored. The
                          namespace for this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      hostedDomain:
                        description: hostedDomain is the optional Google App domain
                          (e.g. "mycompany.com") to restrict logins to
                        type: string
                    type: object
                  htpasswd:
                    description: htpasswd enables user authentication using an HTPasswd
                      file to validate credentials
                    properties:
                      fileData:
                        description: fileData is a required reference to a secret
                          by name containing the data to use as the htpasswd file.
                          The key "htpasswd" is used to locate the data. If the secret
                          or expected key is not found, the identity provider is not
                          honored. If the specified htpasswd data is not valid, the
                          identity provider is not honored. The namespace for this
                          secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                    type: object
                  keystone:
                    description: keystone enables user authentication using keystone
                      password credentials
                    properties:
                      ca:
                        description: ca is an optional reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. The key "ca.crt" is used to locate
                          the data. If specified and the config map or expected key
                          is not found, the identity provider is not honored. If the
                          specified ca data is not valid, the identity provider is
                          not honored. If empty, the default system roots are used.
                          The namespace for this config map is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      domainName:
                        description: domainName is required for keystone v3
                        type: string
                      tlsClientCert:
                        description: tlsClientCert is an optional reference to a secret
                          by name that contains the PEM-encoded TLS client certificate
                          to present when connecting to the server. The key "tls.crt"
                          is used to locate the data. If specified and the secret
                          or expected key is not found, the identity provider is not
                          honored. If the specified certificate data is not valid,
                          the identity provider is not honored. The namespace for
                          this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      tlsClientKey:
                        description: tlsClientKey is an optional reference to a secret
                          by name that contains the PEM-encoded TLS private key for
                          the client certificate referenced in tlsClientCert. The
                          key "tls.key" is used to locate the data. If specified and
                          the secret or expected key is not found, the identity provider
                          is not honored. If the specified certificate data is not
                          valid, the identity provider is not honored. The namespace
                          for this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      url:
                        description: url is the remote URL to connect to
                        type: string
                    type: object
                  ldap:
                    description: ldap enables user authentication using LDAP credentials
                    properties:
                      attributes:
                        description: attributes maps LDAP attributes to identities
                        properties:
                          email:
                            description: email is the list of attributes whose values
                              should be used as the email address. Optional. If unspecified,
                              no email is set for the identity
                            items:
                              type: string
                            type: array
                          id:
                            description: id is the list of attributes whose values
                              should be used as the user ID. Required. First non-empty
                              attribute is used. At least one attribute is required.
                              If none of the listed attribute have a value, authentication
                              fails. LDAP standard identity attribute is "dn"
                            items:
                              type: string
                            type: array
                          name:
                            description: name is the list of attributes whose values
                              should be used as the display name. Optional. If unspecified,
                              no display name is set for the identity LDAP standard
                              display name attribute is "cn"
                            items:
                              type: string
                            type: array
                          preferredUsername:
                            description: preferredUsername is the list of attributes
                              whose values should be used as the preferred username.
                              LDAP standard login attribute is "uid"
                            items:
                              type: string
                            type: array
                        type: object
                      bindDN:
                        description: bindDN is an optional DN to bind with during
                          the search phase.
                        type: string
                      bindPassword:
                        description: bindPassword is an optional reference to a secret
                          by name containing a password to bind with during the search
                          phase. The key "bindPassword" is used to locate the data.
                          If specified and the secret or expected key is not found,
                          the identity provider is not honored. The namespace for
                          this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      ca:
                        description: ca is an optional reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. The key "ca.crt" is used to locate
                          the data. If specified and the config map or expected key
                          is not found, the identity provider is not honored. If the
                          specified ca data is not valid, the identity provider is
                          not honored. If empty, the default system roots are used.
                          The namespace for this config map is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      insecure:
                        description: 'insecure, if true, indicates the connection
                          should not use TLS WARNING: Should not be set to ` + "`" + `true` + "`" + `
                          with the URL scheme "ldaps://" as "ldaps://" URLs always          attempt
                          to connect using TLS, even when ` + "`" + `insecure` + "`" + ` is set to ` + "`" + `true` + "`" + `
                          When ` + "`" + `true` + "`" + `, "ldap://" URLS connect insecurely. When ` + "`" + `false` + "`" + `,
                          "ldap://" URLs are upgraded to a TLS connection using StartTLS
                          as specified in https://tools.ietf.org/html/rfc2830.'
                        type: boolean
                      url:
                        description: 'url is an RFC 2255 URL which specifies the LDAP
                          search parameters to use. The syntax of the URL is: ldap://host:port/basedn?attribute?scope?filter'
                        type: string
                    type: object
                  mappingMethod:
                    description: mappingMethod determines how identities from this
                      provider are mapped to users Defaults to "claim"
                    type: string
                  name:
                    description: 'name is used to qualify the identities returned
                      by this provider. - It MUST be unique and not shared by any
                      other identity provider used - It MUST be a valid path segment:
                      name cannot equal "." or ".." or contain "/" or "%" or ":"   Ref:
                      https://godoc.org/github.com/openshift/origin/pkg/user/apis/user/validation#ValidateIdentityProviderName'
                    type: string
                  openID:
                    description: openID enables user authentication using OpenID credentials
                    properties:
                      ca:
                        description: ca is an optional reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. The key "ca.crt" is used to locate
                          the data. If specified and the config map or expected key
                          is not found, the identity provider is not honored. If the
                          specified ca data is not valid, the identity provider is
                          not honored. If empty, the default system roots are used.
                          The namespace for this config map is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      claims:
                        description: claims mappings
                        properties:
                          email:
                            description: email is the list of claims whose values
                              should be used as the email address. Optional. If unspecified,
                              no email is set for the identity
                            items:
                              type: string
                            type: array
                          name:
                            description: name is the list of claims whose values should
                              be used as the display name. Optional. If unspecified,
                              no display name is set for the identity
                            items:
                              type: string
                            type: array
                          preferredUsername:
                            description: preferredUsername is the list of claims whose
                              values should be used as the preferred username. If
                              unspecified, the preferred username is determined from
                              the value of the sub claim
                            items:
                              type: string
                            type: array
                        type: object
                      clientID:
                        description: clientID is the oauth client ID
                        type: string
                      clientSecret:
                        description: clientSecret is a required reference to the secret
                          by name containing the oauth client secret. The key "clientSecret"
                          is used to locate the data. If the secret or expected key
                          is not found, the identity provider is not honored. The
                          namespace for this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      extraAuthorizeParameters:
                        description: extraAuthorizeParameters are any custom parameters
                          to add to the authorize request.
                        type: object
                      extraScopes:
                        description: extraScopes are any scopes to request in addition
                          to the standard "openid" scope.
                        items:
                          type: string
                        type: array
                      issuer:
                        description: issuer is the URL that the OpenID Provider asserts
                          as its Issuer Identifier. It must use the https scheme with
                          no query or fragment component.
                        type: string
                    type: object
                  requestHeader:
                    description: requestHeader enables user authentication using request
                      header credentials
                    properties:
                      ca:
                        description: ca is a required reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. Specifically, it allows verification
                          of incoming requests to prevent header spoofing. The key
                          "ca.crt" is used to locate the data. If the config map or
                          expected key is not found, the identity provider is not
                          honored. If the specified ca data is not valid, the identity
                          provider is not honored. The namespace for this config map
                          is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      challengeURL:
                        description: challengeURL is a URL to redirect unauthenticated
                          /authorize requests to Unauthenticated requests from OAuth
                          clients which expect WWW-Authenticate challenges will be
                          redirected here. ${url} is replaced with the current URL,
                          escaped to be safe in a query parameter   https://www.example.com/sso-login?then=${url}
                          ${query} is replaced with the current query string   https://www.example.com/auth-proxy/oauth/authorize?${query}
                          Required when challenge is set to true.
                        type: string
                      clientCommonNames:
                        description: clientCommonNames is an optional list of common
                          names to require a match from. If empty, any client certificate
                          validated against the clientCA bundle is considered authoritative.
                        items:
                          type: string
                        type: array
                      emailHeaders:
                        description: emailHeaders is the set of headers to check for
                          the email address
                        items:
                          type: string
                        type: array
                      headers:
                        description: headers is the set of headers to check for identity
                          information
                        items:
                          type: string
                        type: array
                      loginURL:
                        description: loginURL is a URL to redirect unauthenticated
                          /authorize requests to Unauthenticated requests from OAuth
                          clients which expect interactive logins will be redirected
                          here ${url} is replaced with the current URL, escaped to
                          be safe in a query parameter   https://www.example.com/sso-login?then=${url}
                          ${query} is replaced with the current query string   https://www.example.com/auth-proxy/oauth/authorize?${query}
                          Required when login is set to true.
                        type: string
                      nameHeaders:
                        description: nameHeaders is the set of headers to check for
                          the display name
                        items:
                          type: string
                        type: array
                      preferredUsernameHeaders:
                        description: preferredUsernameHeaders is the set of headers
                          to check for the preferred username
                        items:
                          type: string
                        type: array
                    type: object
                  type:
                    description: type identifies the identity provider type for this
                      entry.
                    type: string
                type: object
              type: array
          required:
          - identityProviders
          type: object
        status:
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_selectorsyncidentityproviderYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_selectorsyncidentityproviderYaml, nil
}

func configCrdsHive_v1_selectorsyncidentityproviderYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_selectorsyncidentityproviderYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_selectorsyncidentityprovider.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_selectorsyncsetYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: selectorsyncsets.hive.openshift.io
spec:
  group: hive.openshift.io
  names:
    kind: SelectorSyncSet
    plural: selectorsyncsets
    shortNames:
    - sss
  scope: Cluster
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            clusterDeploymentSelector:
              description: ClusterDeploymentSelector is a LabelSelector indicating
                which clusters the SelectorSyncSet applies to in any namespace.
              type: object
            patches:
              description: Patches is the list of patches to apply.
              items:
                properties:
                  apiVersion:
                    description: APIVersion is the Group and Version of the object
                      to be patched.
                    type: string
                  kind:
                    description: Kind is the Kind of the object to be patched.
                    type: string
                  name:
                    description: Name is the name of the object to be patched.
                    type: string
                  namespace:
                    description: Namespace is the Namespace in which the object to
                      patch exists. Defaults to the SyncSet's Namespace.
                    type: string
                  patch:
                    description: Patch is the patch to apply.
                    type: string
                  patchType:
                    description: PatchType indicates the PatchType as "strategic"
                      (default), "json", or "merge".
                    type: string
                type: object
              type: array
            resourceApplyMode:
              description: ResourceApplyMode indicates if the Resource apply mode
                is "upsert" (default) or "sync". ApplyMode "upsert" indicates create
                and update. ApplyMode "sync" indicates create, update and delete.
              type: string
            resources:
              description: Resources is the list of objects to sync from RawExtension
                definitions.
              items:
                type: object
              type: array
            secretMappings:
              description: Secrets is the list of secrets to sync along with their
                respective destinations.
              items:
                properties:
                  sourceRef:
                    description: SourceRef specifies the name and namespace of a secret
                      on the management cluster
                    properties:
                      name:
                        description: Name is the name of the secret
                        type: string
                      namespace:
                        description: Namespace is the namespace where the secret lives.
                          If not present for the source secret reference, it is assumed
                          to be the same namespace as the syncset with the reference.
                        type: string
                    type: object
                  targetRef:
                    description: TargetRef specifies the target name and namespace
                      of the secret on the target cluster
                    properties:
                      name:
                        description: Name is the name of the secret
                        type: string
                      namespace:
                        description: Namespace is the namespace where the secret lives.
                          If not present for the source secret reference, it is assumed
                          to be the same namespace as the syncset with the reference.
                        type: string
                    type: object
                type: object
              type: array
          type: object
        status:
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_selectorsyncsetYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_selectorsyncsetYaml, nil
}

func configCrdsHive_v1_selectorsyncsetYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_selectorsyncsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_selectorsyncset.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_syncidentityproviderYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: syncidentityproviders.hive.openshift.io
spec:
  group: hive.openshift.io
  names:
    kind: SyncIdentityProvider
    plural: syncidentityproviders
  scope: Namespaced
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            clusterDeploymentRefs:
              description: ClusterDeploymentRefs is the list of LocalObjectReference
                indicating which clusters the SyncSet applies to in the SyncSet's
                namespace.
              items:
                type: object
              type: array
            identityProviders:
              description: IdentityProviders is an ordered list of ways for a user
                to identify themselves
              items:
                properties:
                  basicAuth:
                    description: basicAuth contains configuration options for the
                      BasicAuth IdP
                    properties:
                      ca:
                        description: ca is an optional reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. The key "ca.crt" is used to locate
                          the data. If specified and the config map or expected key
                          is not found, the identity provider is not honored. If the
                          specified ca data is not valid, the identity provider is
                          not honored. If empty, the default system roots are used.
                          The namespace for this config map is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      tlsClientCert:
                        description: tlsClientCert is an optional reference to a secret
                          by name that contains the PEM-encoded TLS client certificate
                          to present when connecting to the server. The key "tls.crt"
                          is used to locate the data. If specified and the secret
                          or expected key is not found, the identity provider is not
                          honored. If the specified certificate data is not valid,
                          the identity provider is not honored. The namespace for
                          this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      tlsClientKey:
                        description: tlsClientKey is an optional reference to a secret
                          by name that contains the PEM-encoded TLS private key for
                          the client certificate referenced in tlsClientCert. The
                          key "tls.key" is used to locate the data. If specified and
                          the secret or expected key is not found, the identity provider
                          is not honored. If the specified certificate data is not
                          valid, the identity provider is not honored. The namespace
                          for this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      url:
                        description: url is the remote URL to connect to
                        type: string
                    type: object
                  github:
                    description: github enables user authentication using GitHub credentials
                    properties:
                      ca:
                        description: ca is an optional reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. The key "ca.crt" is used to locate
                          the data. If specified and the config map or expected key
                          is not found, the identity provider is not honored. If the
                          specified ca data is not valid, the identity provider is
                          not honored. If empty, the default system roots are used.
                          This can only be configured when hostname is set to a non-empty
                          value. The namespace for this config map is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      clientID:
                        description: clientID is the oauth client ID
                        type: string
                      clientSecret:
                        description: clientSecret is a required reference to the secret
                          by name containing the oauth client secret. The key "clientSecret"
                          is used to locate the data. If the secret or expected key
                          is not found, the identity provider is not honored. The
                          namespace for this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      hostname:
                        description: hostname is the optional domain (e.g. "mycompany.com")
                          for use with a hosted instance of GitHub Enterprise. It
                          must match the GitHub Enterprise settings value configured
                          at /setup/settings#hostname.
                        type: string
                      organizations:
                        description: organizations optionally restricts which organizations
                          are allowed to log in
                        items:
                          type: string
                        type: array
                      teams:
                        description: teams optionally restricts which teams are allowed
                          to log in. Format is <org>/<team>.
                        items:
                          type: string
                        type: array
                    type: object
                  gitlab:
                    description: gitlab enables user authentication using GitLab credentials
                    properties:
                      ca:
                        description: ca is an optional reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. The key "ca.crt" is used to locate
                          the data. If specified and the config map or expected key
                          is not found, the identity provider is not honored. If the
                          specified ca data is not valid, the identity provider is
                          not honored. If empty, the default system roots are used.
                          The namespace for this config map is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      clientID:
                        description: clientID is the oauth client ID
                        type: string
                      clientSecret:
                        description: clientSecret is a required reference to the secret
                          by name containing the oauth client secret. The key "clientSecret"
                          is used to locate the data. If the secret or expected key
                          is not found, the identity provider is not honored. The
                          namespace for this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      url:
                        description: url is the oauth server base URL
                        type: string
                    type: object
                  google:
                    description: google enables user authentication using Google credentials
                    properties:
                      clientID:
                        description: clientID is the oauth client ID
                        type: string
                      clientSecret:
                        description: clientSecret is a required reference to the secret
                          by name containing the oauth client secret. The key "clientSecret"
                          is used to locate the data. If the secret or expected key
                          is not found, the identity provider is not honored. The
                          namespace for this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      hostedDomain:
                        description: hostedDomain is the optional Google App domain
                          (e.g. "mycompany.com") to restrict logins to
                        type: string
                    type: object
                  htpasswd:
                    description: htpasswd enables user authentication using an HTPasswd
                      file to validate credentials
                    properties:
                      fileData:
                        description: fileData is a required reference to a secret
                          by name containing the data to use as the htpasswd file.
                          The key "htpasswd" is used to locate the data. If the secret
                          or expected key is not found, the identity provider is not
                          honored. If the specified htpasswd data is not valid, the
                          identity provider is not honored. The namespace for this
                          secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                    type: object
                  keystone:
                    description: keystone enables user authentication using keystone
                      password credentials
                    properties:
                      ca:
                        description: ca is an optional reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. The key "ca.crt" is used to locate
                          the data. If specified and the config map or expected key
                          is not found, the identity provider is not honored. If the
                          specified ca data is not valid, the identity provider is
                          not honored. If empty, the default system roots are used.
                          The namespace for this config map is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      domainName:
                        description: domainName is required for keystone v3
                        type: string
                      tlsClientCert:
                        description: tlsClientCert is an optional reference to a secret
                          by name that contains the PEM-encoded TLS client certificate
                          to present when connecting to the server. The key "tls.crt"
                          is used to locate the data. If specified and the secret
                          or expected key is not found, the identity provider is not
                          honored. If the specified certificate data is not valid,
                          the identity provider is not honored. The namespace for
                          this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      tlsClientKey:
                        description: tlsClientKey is an optional reference to a secret
                          by name that contains the PEM-encoded TLS private key for
                          the client certificate referenced in tlsClientCert. The
                          key "tls.key" is used to locate the data. If specified and
                          the secret or expected key is not found, the identity provider
                          is not honored. If the specified certificate data is not
                          valid, the identity provider is not honored. The namespace
                          for this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      url:
                        description: url is the remote URL to connect to
                        type: string
                    type: object
                  ldap:
                    description: ldap enables user authentication using LDAP credentials
                    properties:
                      attributes:
                        description: attributes maps LDAP attributes to identities
                        properties:
                          email:
                            description: email is the list of attributes whose values
                              should be used as the email address. Optional. If unspecified,
                              no email is set for the identity
                            items:
                              type: string
                            type: array
                          id:
                            description: id is the list of attributes whose values
                              should be used as the user ID. Required. First non-empty
                              attribute is used. At least one attribute is required.
                              If none of the listed attribute have a value, authentication
                              fails. LDAP standard identity attribute is "dn"
                            items:
                              type: string
                            type: array
                          name:
                            description: name is the list of attributes whose values
                              should be used as the display name. Optional. If unspecified,
                              no display name is set for the identity LDAP standard
                              display name attribute is "cn"
                            items:
                              type: string
                            type: array
                          preferredUsername:
                            description: preferredUsername is the list of attributes
                              whose values should be used as the preferred username.
                              LDAP standard login attribute is "uid"
                            items:
                              type: string
                            type: array
                        type: object
                      bindDN:
                        description: bindDN is an optional DN to bind with during
                          the search phase.
                        type: string
                      bindPassword:
                        description: bindPassword is an optional reference to a secret
                          by name containing a password to bind with during the search
                          phase. The key "bindPassword" is used to locate the data.
                          If specified and the secret or expected key is not found,
                          the identity provider is not honored. The namespace for
                          this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      ca:
                        description: ca is an optional reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. The key "ca.crt" is used to locate
                          the data. If specified and the config map or expected key
                          is not found, the identity provider is not honored. If the
                          specified ca data is not valid, the identity provider is
                          not honored. If empty, the default system roots are used.
                          The namespace for this config map is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      insecure:
                        description: 'insecure, if true, indicates the connection
                          should not use TLS WARNING: Should not be set to ` + "`" + `true` + "`" + `
                          with the URL scheme "ldaps://" as "ldaps://" URLs always          attempt
                          to connect using TLS, even when ` + "`" + `insecure` + "`" + ` is set to ` + "`" + `true` + "`" + `
                          When ` + "`" + `true` + "`" + `, "ldap://" URLS connect insecurely. When ` + "`" + `false` + "`" + `,
                          "ldap://" URLs are upgraded to a TLS connection using StartTLS
                          as specified in https://tools.ietf.org/html/rfc2830.'
                        type: boolean
                      url:
                        description: 'url is an RFC 2255 URL which specifies the LDAP
                          search parameters to use. The syntax of the URL is: ldap://host:port/basedn?attribute?scope?filter'
                        type: string
                    type: object
                  mappingMethod:
                    description: mappingMethod determines how identities from this
                      provider are mapped to users Defaults to "claim"
                    type: string
                  name:
                    description: 'name is used to qualify the identities returned
                      by this provider. - It MUST be unique and not shared by any
                      other identity provider used - It MUST be a valid path segment:
                      name cannot equal "." or ".." or contain "/" or "%" or ":"   Ref:
                      https://godoc.org/github.com/openshift/origin/pkg/user/apis/user/validation#ValidateIdentityProviderName'
                    type: string
                  openID:
                    description: openID enables user authentication using OpenID credentials
                    properties:
                      ca:
                        description: ca is an optional reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. The key "ca.crt" is used to locate
                          the data. If specified and the config map or expected key
                          is not found, the identity provider is not honored. If the
                          specified ca data is not valid, the identity provider is
                          not honored. If empty, the default system roots are used.
                          The namespace for this config map is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      claims:
                        description: claims mappings
                        properties:
                          email:
                            description: email is the list of claims whose values
                              should be used as the email address. Optional. If unspecified,
                              no email is set for the identity
                            items:
                              type: string
                            type: array
                          name:
                            description: name is the list of claims whose values should
                              be used as the display name. Optional. If unspecified,
                              no display name is set for the identity
                            items:
                              type: string
                            type: array
                          preferredUsername:
                            description: preferredUsername is the list of claims whose
                              values should be used as the preferred username. If
                              unspecified, the preferred username is determined from
                              the value of the sub claim
                            items:
                              type: string
                            type: array
                        type: object
                      clientID:
                        description: clientID is the oauth client ID
                        type: string
                      clientSecret:
                        description: clientSecret is a required reference to the secret
                          by name containing the oauth client secret. The key "clientSecret"
                          is used to locate the data. If the secret or expected key
                          is not found, the identity provider is not honored. The
                          namespace for this secret is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              secret
                            type: string
                        type: object
                      extraAuthorizeParameters:
                        description: extraAuthorizeParameters are any custom parameters
                          to add to the authorize request.
                        type: object
                      extraScopes:
                        description: extraScopes are any scopes to request in addition
                          to the standard "openid" scope.
                        items:
                          type: string
                        type: array
                      issuer:
                        description: issuer is the URL that the OpenID Provider asserts
                          as its Issuer Identifier. It must use the https scheme with
                          no query or fragment component.
                        type: string
                    type: object
                  requestHeader:
                    description: requestHeader enables user authentication using request
                      header credentials
                    properties:
                      ca:
                        description: ca is a required reference to a config map by
                          name containing the PEM-encoded CA bundle. It is used as
                          a trust anchor to validate the TLS certificate presented
                          by the remote server. Specifically, it allows verification
                          of incoming requests to prevent header spoofing. The key
                          "ca.crt" is used to locate the data. If the config map or
                          expected key is not found, the identity provider is not
                          honored. If the specified ca data is not valid, the identity
                          provider is not honored. The namespace for this config map
                          is openshift-config.
                        properties:
                          name:
                            description: name is the metadata.name of the referenced
                              config map
                            type: string
                        type: object
                      challengeURL:
                        description: challengeURL is a URL to redirect unauthenticated
                          /authorize requests to Unauthenticated requests from OAuth
                          clients which expect WWW-Authenticate challenges will be
                          redirected here. ${url} is replaced with the current URL,
                          escaped to be safe in a query parameter   https://www.example.com/sso-login?then=${url}
                          ${query} is replaced with the current query string   https://www.example.com/auth-proxy/oauth/authorize?${query}
                          Required when challenge is set to true.
                        type: string
                      clientCommonNames:
                        description: clientCommonNames is an optional list of common
                          names to require a match from. If empty, any client certificate
                          validated against the clientCA bundle is considered authoritative.
                        items:
                          type: string
                        type: array
                      emailHeaders:
                        description: emailHeaders is the set of headers to check for
                          the email address
                        items:
                          type: string
                        type: array
                      headers:
                        description: headers is the set of headers to check for identity
                          information
                        items:
                          type: string
                        type: array
                      loginURL:
                        description: loginURL is a URL to redirect unauthenticated
                          /authorize requests to Unauthenticated requests from OAuth
                          clients which expect interactive logins will be redirected
                          here ${url} is replaced with the current URL, escaped to
                          be safe in a query parameter   https://www.example.com/sso-login?then=${url}
                          ${query} is replaced with the current query string   https://www.example.com/auth-proxy/oauth/authorize?${query}
                          Required when login is set to true.
                        type: string
                      nameHeaders:
                        description: nameHeaders is the set of headers to check for
                          the display name
                        items:
                          type: string
                        type: array
                      preferredUsernameHeaders:
                        description: preferredUsernameHeaders is the set of headers
                          to check for the preferred username
                        items:
                          type: string
                        type: array
                    type: object
                  type:
                    description: type identifies the identity provider type for this
                      entry.
                    type: string
                type: object
              type: array
          required:
          - identityProviders
          - clusterDeploymentRefs
          type: object
        status:
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_syncidentityproviderYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_syncidentityproviderYaml, nil
}

func configCrdsHive_v1_syncidentityproviderYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_syncidentityproviderYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_syncidentityprovider.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_syncsetYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: syncsets.hive.openshift.io
spec:
  group: hive.openshift.io
  names:
    kind: SyncSet
    plural: syncsets
    shortNames:
    - ss
  scope: Namespaced
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            clusterDeploymentRefs:
              description: ClusterDeploymentRefs is the list of LocalObjectReference
                indicating which clusters the SyncSet applies to in the SyncSet's
                namespace.
              items:
                type: object
              type: array
            patches:
              description: Patches is the list of patches to apply.
              items:
                properties:
                  apiVersion:
                    description: APIVersion is the Group and Version of the object
                      to be patched.
                    type: string
                  kind:
                    description: Kind is the Kind of the object to be patched.
                    type: string
                  name:
                    description: Name is the name of the object to be patched.
                    type: string
                  namespace:
                    description: Namespace is the Namespace in which the object to
                      patch exists. Defaults to the SyncSet's Namespace.
                    type: string
                  patch:
                    description: Patch is the patch to apply.
                    type: string
                  patchType:
                    description: PatchType indicates the PatchType as "strategic"
                      (default), "json", or "merge".
                    type: string
                type: object
              type: array
            resourceApplyMode:
              description: ResourceApplyMode indicates if the Resource apply mode
                is "upsert" (default) or "sync". ApplyMode "upsert" indicates create
                and update. ApplyMode "sync" indicates create, update and delete.
              type: string
            resources:
              description: Resources is the list of objects to sync from RawExtension
                definitions.
              items:
                type: object
              type: array
            secretMappings:
              description: Secrets is the list of secrets to sync along with their
                respective destinations.
              items:
                properties:
                  sourceRef:
                    description: SourceRef specifies the name and namespace of a secret
                      on the management cluster
                    properties:
                      name:
                        description: Name is the name of the secret
                        type: string
                      namespace:
                        description: Namespace is the namespace where the secret lives.
                          If not present for the source secret reference, it is assumed
                          to be the same namespace as the syncset with the reference.
                        type: string
                    type: object
                  targetRef:
                    description: TargetRef specifies the target name and namespace
                      of the secret on the target cluster
                    properties:
                      name:
                        description: Name is the name of the secret
                        type: string
                      namespace:
                        description: Namespace is the namespace where the secret lives.
                          If not present for the source secret reference, it is assumed
                          to be the same namespace as the syncset with the reference.
                        type: string
                    type: object
                type: object
              type: array
          required:
          - clusterDeploymentRefs
          type: object
        status:
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_syncsetYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_syncsetYaml, nil
}

func configCrdsHive_v1_syncsetYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_syncsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_syncset.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configCrdsHive_v1_syncsetinstanceYaml = []byte(`apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  creationTimestamp: null
  labels:
    controller-tools.k8s.io: "1.0"
  name: syncsetinstances.hive.openshift.io
spec:
  group: hive.openshift.io
  names:
    kind: SyncSetInstance
    plural: syncsetinstances
    shortNames:
    - ssi
  scope: Namespaced
  subresources:
    status: {}
  validation:
    openAPIV3Schema:
      properties:
        apiVersion:
          description: 'APIVersion defines the versioned schema of this representation
            of an object. Servers should convert recognized schemas to the latest
            internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources'
          type: string
        kind:
          description: 'Kind is a string value representing the REST resource this
            object represents. Servers may infer this from the endpoint the client
            submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds'
          type: string
        metadata:
          type: object
        spec:
          properties:
            clusterDeploymentRef:
              description: ClusterDeployment is a reference to to the clusterdeployment
                for this syncsetinstance.
              type: object
            resourceApplyMode:
              description: ResourceApplyMode indicates if the resource apply mode
                is "upsert" (default) or "sync". ApplyMode "upsert" indicates create
                and update. ApplyMode "sync" indicates create, update and delete.
              type: string
            selectorSyncSetRef:
              description: SelectorSyncSetRef is a reference to the selectorsyncset
                for this syncsetinstance.
              properties:
                name:
                  description: Name is the name of the SelectorSyncSet
                  type: string
              type: object
            syncSetHash:
              description: SyncSetHash is a hash of the contents of the syncset or
                selectorsyncset spec. Its purpose is to cause a syncset instance update
                whenever there's a change in its source.
              type: string
            syncSetRef:
              description: SyncSet is a reference to the syncset for this syncsetinstance.
              type: object
          type: object
        status:
          properties:
            applied:
              description: Applied will be true if all resources, patches, or secrets
                have successfully been applied on last attempt.
              type: boolean
            conditions:
              description: Conditions is the list of SyncConditions used to indicate
                UnknownObject when a resource type cannot be determined from a SyncSet
                resource.
              items:
                properties:
                  lastProbeTime:
                    description: LastProbeTime is the last time we probed the condition.
                    format: date-time
                    type: string
                  lastTransitionTime:
                    description: LastTransitionTime is the last time the condition
                      transitioned from one status to another.
                    format: date-time
                    type: string
                  message:
                    description: Message is a human-readable message indicating details
                      about last transition.
                    type: string
                  reason:
                    description: Reason is a unique, one-word, CamelCase reason for
                      the condition's last transition.
                    type: string
                  status:
                    description: Status is the status of the condition.
                    type: string
                  type:
                    description: Type is the type of the condition.
                    type: string
                type: object
              type: array
            patches:
              description: Patches is the list of SyncStatus for patches that have
                been applied.
              items:
                properties:
                  apiVersion:
                    description: APIVersion is the Group and Version of the object
                      that was synced or patched.
                    type: string
                  conditions:
                    description: Conditions is the list of conditions indicating success
                      or failure of object create, update and delete as well as patch
                      application.
                    items:
                      properties:
                        lastProbeTime:
                          description: LastProbeTime is the last time we probed the
                            condition.
                          format: date-time
                          type: string
                        lastTransitionTime:
                          description: LastTransitionTime is the last time the condition
                            transitioned from one status to another.
                          format: date-time
                          type: string
                        message:
                          description: Message is a human-readable message indicating
                            details about last transition.
                          type: string
                        reason:
                          description: Reason is a unique, one-word, CamelCase reason
                            for the condition's last transition.
                          type: string
                        status:
                          description: Status is the status of the condition.
                          type: string
                        type:
                          description: Type is the type of the condition.
                          type: string
                      type: object
                    type: array
                  hash:
                    description: Hash is the unique md5 hash of the resource or patch.
                    type: string
                  kind:
                    description: Kind is the Kind of the object that was synced or
                      patched.
                    type: string
                  name:
                    description: Name is the name of the object that was synced or
                      patched.
                    type: string
                  namespace:
                    description: Namespace is the Namespace of the object that was
                      synced or patched.
                    type: string
                  resource:
                    description: Resource is the resource name for the object that
                      was synced. This will be populated for resources, but not patches
                    type: string
                type: object
              type: array
            resources:
              description: Resources is the list of SyncStatus for objects that have
                been synced.
              items:
                properties:
                  apiVersion:
                    description: APIVersion is the Group and Version of the object
                      that was synced or patched.
                    type: string
                  conditions:
                    description: Conditions is the list of conditions indicating success
                      or failure of object create, update and delete as well as patch
                      application.
                    items:
                      properties:
                        lastProbeTime:
                          description: LastProbeTime is the last time we probed the
                            condition.
                          format: date-time
                          type: string
                        lastTransitionTime:
                          description: LastTransitionTime is the last time the condition
                            transitioned from one status to another.
                          format: date-time
                          type: string
                        message:
                          description: Message is a human-readable message indicating
                            details about last transition.
                          type: string
                        reason:
                          description: Reason is a unique, one-word, CamelCase reason
                            for the condition's last transition.
                          type: string
                        status:
                          description: Status is the status of the condition.
                          type: string
                        type:
                          description: Type is the type of the condition.
                          type: string
                      type: object
                    type: array
                  hash:
                    description: Hash is the unique md5 hash of the resource or patch.
                    type: string
                  kind:
                    description: Kind is the Kind of the object that was synced or
                      patched.
                    type: string
                  name:
                    description: Name is the name of the object that was synced or
                      patched.
                    type: string
                  namespace:
                    description: Namespace is the Namespace of the object that was
                      synced or patched.
                    type: string
                  resource:
                    description: Resource is the resource name for the object that
                      was synced. This will be populated for resources, but not patches
                    type: string
                type: object
              type: array
            secretReferences:
              description: Secrets is the list of SyncStatus for secrets that have
                been synced.
              items:
                properties:
                  apiVersion:
                    description: APIVersion is the Group and Version of the object
                      that was synced or patched.
                    type: string
                  conditions:
                    description: Conditions is the list of conditions indicating success
                      or failure of object create, update and delete as well as patch
                      application.
                    items:
                      properties:
                        lastProbeTime:
                          description: LastProbeTime is the last time we probed the
                            condition.
                          format: date-time
                          type: string
                        lastTransitionTime:
                          description: LastTransitionTime is the last time the condition
                            transitioned from one status to another.
                          format: date-time
                          type: string
                        message:
                          description: Message is a human-readable message indicating
                            details about last transition.
                          type: string
                        reason:
                          description: Reason is a unique, one-word, CamelCase reason
                            for the condition's last transition.
                          type: string
                        status:
                          description: Status is the status of the condition.
                          type: string
                        type:
                          description: Type is the type of the condition.
                          type: string
                      type: object
                    type: array
                  hash:
                    description: Hash is the unique md5 hash of the resource or patch.
                    type: string
                  kind:
                    description: Kind is the Kind of the object that was synced or
                      patched.
                    type: string
                  name:
                    description: Name is the name of the object that was synced or
                      patched.
                    type: string
                  namespace:
                    description: Namespace is the Namespace of the object that was
                      synced or patched.
                    type: string
                  resource:
                    description: Resource is the resource name for the object that
                      was synced. This will be populated for resources, but not patches
                    type: string
                type: object
              type: array
          type: object
  version: v1
status:
  acceptedNames:
    kind: ""
    plural: ""
  conditions: []
  storedVersions: []
`)

func configCrdsHive_v1_syncsetinstanceYamlBytes() ([]byte, error) {
	return _configCrdsHive_v1_syncsetinstanceYaml, nil
}

func configCrdsHive_v1_syncsetinstanceYaml() (*asset, error) {
	bytes, err := configCrdsHive_v1_syncsetinstanceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/crds/hive_v1_syncsetinstance.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _configConfigmapsInstallLogRegexesConfigmapYaml = []byte(`apiVersion: v1
kind: ConfigMap
metadata:
  name: install-log-regexes
  namespace: hive
data:
  regexes: |
    # AWS Specific:
    - name: AWSNATGatewayLimitExceeded
      searchRegexStrings:
      - "NatGatewayLimitExceeded"
      installFailingReason: AWSNATGatewayLimitExceeded
      installFailingMessage: AWS NAT gateway limit exceeded
    - name: DNSAlreadyExists
      searchRegexStrings:
      - "aws_route53_record.*Error building changeset:.*Tried to create resource record set.*but it already exists"
      installFailingReason: DNSAlreadyExists
      installFailingMessage: DNS record already exists
    - name: PendingVerification
      searchRegexStrings:
      - "PendingVerification: Your request for accessing resources in this region is being validated"
      installFailingReason: PendingVerification
      installFailingMessage: Account pending verification for region
    - name: NoMatchingRoute53Zone
      searchRegexStrings:
      - "data.aws_route53_zone.public: no matching Route53Zone found"
      installFailingReason: NoMatchingRoute53Zone
      installFailingMessage: No matching Route53Zone found
    - name: KubeAPIWaitTimeout
      searchRegexStrings:
      - "waiting for Kubernetes API: context deadline exceeded"
      installFailingReason: KubeAPIWaitTimeout
      installFailingMessage: Timeout waiting for the Kubernetes API to begin responding
    - name: MonitoringOperatorStillUpdating
      searchRegexStrings:
      - "failed to initialize the cluster: Cluster operator monitoring is still updating"
      installFailingReason: MonitoringOperatorStillUpdating
      installFailingMessage: Timeout waiting for the monitoring operator to become ready
    # Bare Metal
    - name: LibvirtSSHKeyPermissionDenied
      searchRegexStrings:
      - "platform.baremetal.libvirtURI: Internal error: could not connect to libvirt: virError.Code=38, Domain=7, Message=.Cannot recv data: Permission denied"
      installFailingReason: LibvirtSSHKeyPermissionDenied
      installFailingMessage: "Permission denied connecting to libvirt host, check SSH key configuration and pass phrase"
    # Processing stops at the first match, so this more generic
    # message about the connection failure must always come after the
    # more specific message for LibvirtSSHKeyPermissionDenied.
    - name: LibvirtConnectionFailed
      searchRegexStrings:
      - "could not connect to libvirt"
      installFailingReason: LibvirtConnectionFailed
      installFailingMessage: "Could not connect to libvirt host"
`)

func configConfigmapsInstallLogRegexesConfigmapYamlBytes() ([]byte, error) {
	return _configConfigmapsInstallLogRegexesConfigmapYaml, nil
}

func configConfigmapsInstallLogRegexesConfigmapYaml() (*asset, error) {
	bytes, err := configConfigmapsInstallLogRegexesConfigmapYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "config/configmaps/install-log-regexes-configmap.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"config/apiserver/apiservice.yaml":                          configApiserverApiserviceYaml,
	"config/apiserver/deployment.yaml":                          configApiserverDeploymentYaml,
	"config/apiserver/hiveapi_rbac_role.yaml":                   configApiserverHiveapi_rbac_roleYaml,
	"config/apiserver/hiveapi_rbac_role_binding.yaml":           configApiserverHiveapi_rbac_role_bindingYaml,
	"config/apiserver/service-account.yaml":                     configApiserverServiceAccountYaml,
	"config/apiserver/service.yaml":                             configApiserverServiceYaml,
	"config/hiveadmission/apiservice.yaml":                      configHiveadmissionApiserviceYaml,
	"config/hiveadmission/clusterdeployment-webhook.yaml":       configHiveadmissionClusterdeploymentWebhookYaml,
	"config/hiveadmission/clusterimageset-webhook.yaml":         configHiveadmissionClusterimagesetWebhookYaml,
	"config/hiveadmission/clusterprovision-webhook.yaml":        configHiveadmissionClusterprovisionWebhookYaml,
	"config/hiveadmission/deployment.yaml":                      configHiveadmissionDeploymentYaml,
	"config/hiveadmission/dnszones-webhook.yaml":                configHiveadmissionDnszonesWebhookYaml,
	"config/hiveadmission/hiveadmission_rbac_role.yaml":         configHiveadmissionHiveadmission_rbac_roleYaml,
	"config/hiveadmission/hiveadmission_rbac_role_binding.yaml": configHiveadmissionHiveadmission_rbac_role_bindingYaml,
	"config/hiveadmission/machinepool-webhook.yaml":             configHiveadmissionMachinepoolWebhookYaml,
	"config/hiveadmission/selectorsyncset-webhook.yaml":         configHiveadmissionSelectorsyncsetWebhookYaml,
	"config/hiveadmission/service-account.yaml":                 configHiveadmissionServiceAccountYaml,
	"config/hiveadmission/service.yaml":                         configHiveadmissionServiceYaml,
	"config/hiveadmission/syncset-webhook.yaml":                 configHiveadmissionSyncsetWebhookYaml,
	"config/manager/deployment.yaml":                            configManagerDeploymentYaml,
	"config/manager/service.yaml":                               configManagerServiceYaml,
	"config/rbac/hive_admin_role.yaml":                          configRbacHive_admin_roleYaml,
	"config/rbac/hive_admin_role_binding.yaml":                  configRbacHive_admin_role_bindingYaml,
	"config/rbac/hive_controllers_role.yaml":                    configRbacHive_controllers_roleYaml,
	"config/rbac/hive_controllers_role_binding.yaml":            configRbacHive_controllers_role_bindingYaml,
	"config/rbac/hive_frontend_role.yaml":                       configRbacHive_frontend_roleYaml,
	"config/rbac/hive_frontend_role_binding.yaml":               configRbacHive_frontend_role_bindingYaml,
	"config/rbac/hive_frontend_serviceaccount.yaml":             configRbacHive_frontend_serviceaccountYaml,
	"config/rbac/hive_reader_role.yaml":                         configRbacHive_reader_roleYaml,
	"config/rbac/hive_reader_role_binding.yaml":                 configRbacHive_reader_role_bindingYaml,
	"config/crds/hive_v1_checkpoint.yaml":                       configCrdsHive_v1_checkpointYaml,
	"config/crds/hive_v1_clusterdeployment.yaml":                configCrdsHive_v1_clusterdeploymentYaml,
	"config/crds/hive_v1_clusterdeprovision.yaml":               configCrdsHive_v1_clusterdeprovisionYaml,
	"config/crds/hive_v1_clusterimageset.yaml":                  configCrdsHive_v1_clusterimagesetYaml,
	"config/crds/hive_v1_clusterprovision.yaml":                 configCrdsHive_v1_clusterprovisionYaml,
	"config/crds/hive_v1_clusterstate.yaml":                     configCrdsHive_v1_clusterstateYaml,
	"config/crds/hive_v1_dnszone.yaml":                          configCrdsHive_v1_dnszoneYaml,
	"config/crds/hive_v1_hiveconfig.yaml":                       configCrdsHive_v1_hiveconfigYaml,
	"config/crds/hive_v1_machinepool.yaml":                      configCrdsHive_v1_machinepoolYaml,
	"config/crds/hive_v1_machinepoolnamelease.yaml":             configCrdsHive_v1_machinepoolnameleaseYaml,
	"config/crds/hive_v1_selectorsyncidentityprovider.yaml":     configCrdsHive_v1_selectorsyncidentityproviderYaml,
	"config/crds/hive_v1_selectorsyncset.yaml":                  configCrdsHive_v1_selectorsyncsetYaml,
	"config/crds/hive_v1_syncidentityprovider.yaml":             configCrdsHive_v1_syncidentityproviderYaml,
	"config/crds/hive_v1_syncset.yaml":                          configCrdsHive_v1_syncsetYaml,
	"config/crds/hive_v1_syncsetinstance.yaml":                  configCrdsHive_v1_syncsetinstanceYaml,
	"config/configmaps/install-log-regexes-configmap.yaml":      configConfigmapsInstallLogRegexesConfigmapYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"config": {nil, map[string]*bintree{
		"apiserver": {nil, map[string]*bintree{
			"apiservice.yaml":                {configApiserverApiserviceYaml, map[string]*bintree{}},
			"deployment.yaml":                {configApiserverDeploymentYaml, map[string]*bintree{}},
			"hiveapi_rbac_role.yaml":         {configApiserverHiveapi_rbac_roleYaml, map[string]*bintree{}},
			"hiveapi_rbac_role_binding.yaml": {configApiserverHiveapi_rbac_role_bindingYaml, map[string]*bintree{}},
			"service-account.yaml":           {configApiserverServiceAccountYaml, map[string]*bintree{}},
			"service.yaml":                   {configApiserverServiceYaml, map[string]*bintree{}},
		}},
		"configmaps": {nil, map[string]*bintree{
			"install-log-regexes-configmap.yaml": {configConfigmapsInstallLogRegexesConfigmapYaml, map[string]*bintree{}},
		}},
		"crds": {nil, map[string]*bintree{
			"hive_v1_checkpoint.yaml":                   {configCrdsHive_v1_checkpointYaml, map[string]*bintree{}},
			"hive_v1_clusterdeployment.yaml":            {configCrdsHive_v1_clusterdeploymentYaml, map[string]*bintree{}},
			"hive_v1_clusterdeprovision.yaml":           {configCrdsHive_v1_clusterdeprovisionYaml, map[string]*bintree{}},
			"hive_v1_clusterimageset.yaml":              {configCrdsHive_v1_clusterimagesetYaml, map[string]*bintree{}},
			"hive_v1_clusterprovision.yaml":             {configCrdsHive_v1_clusterprovisionYaml, map[string]*bintree{}},
			"hive_v1_clusterstate.yaml":                 {configCrdsHive_v1_clusterstateYaml, map[string]*bintree{}},
			"hive_v1_dnszone.yaml":                      {configCrdsHive_v1_dnszoneYaml, map[string]*bintree{}},
			"hive_v1_hiveconfig.yaml":                   {configCrdsHive_v1_hiveconfigYaml, map[string]*bintree{}},
			"hive_v1_machinepool.yaml":                  {configCrdsHive_v1_machinepoolYaml, map[string]*bintree{}},
			"hive_v1_machinepoolnamelease.yaml":         {configCrdsHive_v1_machinepoolnameleaseYaml, map[string]*bintree{}},
			"hive_v1_selectorsyncidentityprovider.yaml": {configCrdsHive_v1_selectorsyncidentityproviderYaml, map[string]*bintree{}},
			"hive_v1_selectorsyncset.yaml":              {configCrdsHive_v1_selectorsyncsetYaml, map[string]*bintree{}},
			"hive_v1_syncidentityprovider.yaml":         {configCrdsHive_v1_syncidentityproviderYaml, map[string]*bintree{}},
			"hive_v1_syncset.yaml":                      {configCrdsHive_v1_syncsetYaml, map[string]*bintree{}},
			"hive_v1_syncsetinstance.yaml":              {configCrdsHive_v1_syncsetinstanceYaml, map[string]*bintree{}},
		}},
		"hiveadmission": {nil, map[string]*bintree{
			"apiservice.yaml":                      {configHiveadmissionApiserviceYaml, map[string]*bintree{}},
			"clusterdeployment-webhook.yaml":       {configHiveadmissionClusterdeploymentWebhookYaml, map[string]*bintree{}},
			"clusterimageset-webhook.yaml":         {configHiveadmissionClusterimagesetWebhookYaml, map[string]*bintree{}},
			"clusterprovision-webhook.yaml":        {configHiveadmissionClusterprovisionWebhookYaml, map[string]*bintree{}},
			"deployment.yaml":                      {configHiveadmissionDeploymentYaml, map[string]*bintree{}},
			"dnszones-webhook.yaml":                {configHiveadmissionDnszonesWebhookYaml, map[string]*bintree{}},
			"hiveadmission_rbac_role.yaml":         {configHiveadmissionHiveadmission_rbac_roleYaml, map[string]*bintree{}},
			"hiveadmission_rbac_role_binding.yaml": {configHiveadmissionHiveadmission_rbac_role_bindingYaml, map[string]*bintree{}},
			"machinepool-webhook.yaml":             {configHiveadmissionMachinepoolWebhookYaml, map[string]*bintree{}},
			"selectorsyncset-webhook.yaml":         {configHiveadmissionSelectorsyncsetWebhookYaml, map[string]*bintree{}},
			"service-account.yaml":                 {configHiveadmissionServiceAccountYaml, map[string]*bintree{}},
			"service.yaml":                         {configHiveadmissionServiceYaml, map[string]*bintree{}},
			"syncset-webhook.yaml":                 {configHiveadmissionSyncsetWebhookYaml, map[string]*bintree{}},
		}},
		"manager": {nil, map[string]*bintree{
			"deployment.yaml": {configManagerDeploymentYaml, map[string]*bintree{}},
			"service.yaml":    {configManagerServiceYaml, map[string]*bintree{}},
		}},
		"rbac": {nil, map[string]*bintree{
			"hive_admin_role.yaml":               {configRbacHive_admin_roleYaml, map[string]*bintree{}},
			"hive_admin_role_binding.yaml":       {configRbacHive_admin_role_bindingYaml, map[string]*bintree{}},
			"hive_controllers_role.yaml":         {configRbacHive_controllers_roleYaml, map[string]*bintree{}},
			"hive_controllers_role_binding.yaml": {configRbacHive_controllers_role_bindingYaml, map[string]*bintree{}},
			"hive_frontend_role.yaml":            {configRbacHive_frontend_roleYaml, map[string]*bintree{}},
			"hive_frontend_role_binding.yaml":    {configRbacHive_frontend_role_bindingYaml, map[string]*bintree{}},
			"hive_frontend_serviceaccount.yaml":  {configRbacHive_frontend_serviceaccountYaml, map[string]*bintree{}},
			"hive_reader_role.yaml":              {configRbacHive_reader_roleYaml, map[string]*bintree{}},
			"hive_reader_role_binding.yaml":      {configRbacHive_reader_role_bindingYaml, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
