# redisgraph-tls
[RedisGraph](https://hub.docker.com/r/redislabs/redisgraph/) image extended with stunnel configuration for SSL/TLS.
 
## Development

1. Build docker image 
  ```
  docker build -t redisgraph-tls:latest .
  ```
2. Run docker image
  ```
  docker run -p 6379:6379 --name redis-graph -it --rm -e "REDIS_PASSWORD=thepassword" redisgraph-tls
  ```
3. Starting with ssh tunnel 
   ```
   docker run -p 6380:6380 -v /path/to/certs:/certs --name redis-graph -it --rm -e     "REDIS_PASSWORD=thepassword" -e "REDIS_GRAPH_SSL=true" redisgraph-tls
   ```
   /path/to/certs should have the certificate (server.crt) and key (server.key) files

4. Starting client with ssh
   start stunnel with client.conf file like the one below . => stunnel client.conf
   ```
   [redis-cli]
   client=yes
   accept=localhost:6666
   connect=localhost:6380
   verify=2
   CAfile=server.crt
   debug=7
    ```

## How to update Redis
  1. Download a stable version from: https://redis.io/download
  2. Replace ./vendor/redis.tar.gz with the new file.

## How to update RedisGraph
  1. Clone the RedisGraph repo
  ```
  git clone --recurse-submodules -j8 https://github.com/RedisGraph/RedisGraph.git
  ```
  2. Checkout the desired version
  ```
  git checkout tags/v2.2.13
  ```
  3. Copy the /Redisgraph folder to ./vendor/RedisGraph 


## Update Python dependencies

The Python requirements file is generated from `requirements.in`[requirements.in] by `pip-compile`
from the [pip-tools](https://github.com/jazzband/pip-tools) Python package. All package updates should be made in `requirements.in` and then run

```
$ pip-compile requirements.in -o requirements.txt
```
