#!/bin/bash

if [ "$SAVERDB" == "false" ]; then
   echo 'save ""' >> /usr/local/etc/redis/redis.conf
   echo SAVERDB set to false
else
   echo "save 60 1" >> /usr/local/etc/redis/redis.conf
   echo "dir /redis-data" >> /usr/local/etc/redis/redis.conf
   echo SAVERDB set to true
fi

if [ -z "$REDIS_PASSWORD" ]; then
  echo Starting RedisGraph without a password.
  echo To protect RedisGraph with a password you must use the REDIS_PASSWORD environment.
else
  #allow running redis as non root
  #echo requirepass $REDIS_PASSWORD > /usr/local/etc/redis/redisPwd.conf
  echo requirepass $REDIS_PASSWORD > /rg/redisPwd.conf
fi

redis-server /usr/local/etc/redis/redis.conf
