# Development Report for June 26, 2017


### BuildKit

[Repo](https://github.com/moby/buildkit)
[Proposal](https://github.com/moby/moby/issues/32925)

New development repo is open at https://github.com/moby/buildkit

The readme file provides examples how to get started. You can see an example of building BuildKit with BuildKit.

There are lots of new issues opened as well to track the missing functionality. You are welcomed to help on any of them or discuss the design there.

Last week most of the work was done on improving the `llb` client library for more complicated use cases and providing traces and interactive progress of executed build jobs.

The `llb` client package is a go library that helps you to generate the build definition graph. It uses chained methods to make it easy to describe what steps need to be running. Mounts can be added to the execution steps for defining multiple inputs or outputs. To prepare the graph, you just have to call `Marshal()` on a leaf node that will generate the protobuf definition for everything required to build that node.

### Typed Dockerfile parsing

[PR](https://github.com/moby/moby/pull/33492)

This PR that enables parsing Dockerfiles into typed structures so they can be preprocessed to eliminate unnecessary build stages and reused with different kinds of dispatchers(eg. BuildKit).

The PR had some review and updates in last week. Should be ready to code review soon.

### Merged: Long running session & incremental file sending

[PR](https://github.com/moby/moby/pull/32677) 

Incremental context sending PR was merged and is expected to land in `v17.07`.

This feature experimental feature lets you skip sending the build context to the daemon on repeated builder invocations during development. Currently, this feature requires a CLI flag `--stream=true`. If this flag is used, one first builder invocation full build context is sent to the daemon. On a second attempt, only the changed files are transferred.

Previous build context is saved in the build cache, and you can see how much space it takes form `docker system df`. Build cache will be automatically garbage collected and can also be manually cleared with `docker prune`.

### Quality: Dependency interface switch

[Move file copying from the daemon to the builder](https://github.com/moby/moby/pull/33454) PR was merged.


### Proposals for new Dockerfile features that need design feedback:

[Add IMPORT/EXPORT commands to Dockerfile](https://github.com/moby/moby/issues/32100)

[Add `DOCKEROS/DOCKERARCH` default ARG to Dockerfile](https://github.com/moby/moby/issues/32487)

[Add support for `RUN --mount`](https://github.com/moby/moby/issues/32507)

[DAG image builder](https://github.com/moby/moby/issues/32550)

[Option to export the hash of the build context](https://github.com/moby/moby/issues/32963) (new)

[Allow --cache-from=*](https://github.com/moby/moby/issues/33002#issuecomment-299041162) (new)

[Provide advanced .dockeringore use-cases](https://github.com/moby/moby/issues/12886) [2](https://github.com/moby/moby/issues/12886#issuecomment-306247989)

If you are interested in implementing any of them, leave a comment on the specific issues.

### Other builder PRs merged last week

[Warn/deprecate continuing on empty lines in `Dockerfile`](https://github.com/moby/moby/pull/29161)

[Fix behavior of absolute paths in .dockerignore](https://github.com/moby/moby/pull/32088)

[fix copy —from conflict with force pull](https://github.com/moby/moby/pull/33735)

### Builder features currently in code-review:

[Fix handling of remote "git@" notation](https://github.com/moby/moby/pull/33696)

[builder: Emit a BuildResult after squashing.](https://github.com/moby/moby/pull/33824)

[Fix shallow git clone in docker-build](https://github.com/moby/moby/pull/33704)

### Backlog

[Build secrets](https://github.com/moby/moby/issues/33343) has not got much traction. If you want this feature to become a reality, please make yourself heard.