/*
Copyright (c) 2020 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// IMPORTANT: This file has been generated automatically, refrain from modifying it manually as all
// your changes will be lost when the file is generated again.

package v1 // github.com/openshift-online/ocm-sdk-go/clustersmgmt/v1

// AWSInfrastructureAccessRoleGrantListBuilder contains the data and logic needed to build
// 'AWS_infrastructure_access_role_grant' objects.
type AWSInfrastructureAccessRoleGrantListBuilder struct {
	items []*AWSInfrastructureAccessRoleGrantBuilder
}

// NewAWSInfrastructureAccessRoleGrantList creates a new builder of 'AWS_infrastructure_access_role_grant' objects.
func NewAWSInfrastructureAccessRoleGrantList() *AWSInfrastructureAccessRoleGrantListBuilder {
	return new(AWSInfrastructureAccessRoleGrantListBuilder)
}

// Items sets the items of the list.
func (b *AWSInfrastructureAccessRoleGrantListBuilder) Items(values ...*AWSInfrastructureAccessRoleGrantBuilder) *AWSInfrastructureAccessRoleGrantListBuilder {
	b.items = make([]*AWSInfrastructureAccessRoleGrantBuilder, len(values))
	copy(b.items, values)
	return b
}

// Copy copies the items of the given list into this builder, discarding any previous items.
func (b *AWSInfrastructureAccessRoleGrantListBuilder) Copy(list *AWSInfrastructureAccessRoleGrantList) *AWSInfrastructureAccessRoleGrantListBuilder {
	if list == nil || list.items == nil {
		b.items = nil
	} else {
		b.items = make([]*AWSInfrastructureAccessRoleGrantBuilder, len(list.items))
		for i, v := range list.items {
			b.items[i] = NewAWSInfrastructureAccessRoleGrant().Copy(v)
		}
	}
	return b
}

// Build creates a list of 'AWS_infrastructure_access_role_grant' objects using the
// configuration stored in the builder.
func (b *AWSInfrastructureAccessRoleGrantListBuilder) Build() (list *AWSInfrastructureAccessRoleGrantList, err error) {
	items := make([]*AWSInfrastructureAccessRoleGrant, len(b.items))
	for i, item := range b.items {
		items[i], err = item.Build()
		if err != nil {
			return
		}
	}
	list = new(AWSInfrastructureAccessRoleGrantList)
	list.items = items
	return
}
