// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewUpdateClusterLogsProgressParams creates a new UpdateClusterLogsProgressParams object
// with the default values initialized.
func NewUpdateClusterLogsProgressParams() *UpdateClusterLogsProgressParams {
	var ()
	return &UpdateClusterLogsProgressParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateClusterLogsProgressParamsWithTimeout creates a new UpdateClusterLogsProgressParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewUpdateClusterLogsProgressParamsWithTimeout(timeout time.Duration) *UpdateClusterLogsProgressParams {
	var ()
	return &UpdateClusterLogsProgressParams{

		timeout: timeout,
	}
}

// NewUpdateClusterLogsProgressParamsWithContext creates a new UpdateClusterLogsProgressParams object
// with the default values initialized, and the ability to set a context for a request
func NewUpdateClusterLogsProgressParamsWithContext(ctx context.Context) *UpdateClusterLogsProgressParams {
	var ()
	return &UpdateClusterLogsProgressParams{

		Context: ctx,
	}
}

// NewUpdateClusterLogsProgressParamsWithHTTPClient creates a new UpdateClusterLogsProgressParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewUpdateClusterLogsProgressParamsWithHTTPClient(client *http.Client) *UpdateClusterLogsProgressParams {
	var ()
	return &UpdateClusterLogsProgressParams{
		HTTPClient: client,
	}
}

/*UpdateClusterLogsProgressParams contains all the parameters to send to the API endpoint
for the update cluster logs progress operation typically these are written to a http.Request
*/
type UpdateClusterLogsProgressParams struct {

	/*ClusterID
	  The cluster whose log progress is being updated.

	*/
	ClusterID strfmt.UUID
	/*LogsProgressParams
	  Parameters for updating log progress.

	*/
	LogsProgressParams *models.LogsProgressParams

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the update cluster logs progress params
func (o *UpdateClusterLogsProgressParams) WithTimeout(timeout time.Duration) *UpdateClusterLogsProgressParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update cluster logs progress params
func (o *UpdateClusterLogsProgressParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update cluster logs progress params
func (o *UpdateClusterLogsProgressParams) WithContext(ctx context.Context) *UpdateClusterLogsProgressParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update cluster logs progress params
func (o *UpdateClusterLogsProgressParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update cluster logs progress params
func (o *UpdateClusterLogsProgressParams) WithHTTPClient(client *http.Client) *UpdateClusterLogsProgressParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update cluster logs progress params
func (o *UpdateClusterLogsProgressParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the update cluster logs progress params
func (o *UpdateClusterLogsProgressParams) WithClusterID(clusterID strfmt.UUID) *UpdateClusterLogsProgressParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the update cluster logs progress params
func (o *UpdateClusterLogsProgressParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithLogsProgressParams adds the logsProgressParams to the update cluster logs progress params
func (o *UpdateClusterLogsProgressParams) WithLogsProgressParams(logsProgressParams *models.LogsProgressParams) *UpdateClusterLogsProgressParams {
	o.SetLogsProgressParams(logsProgressParams)
	return o
}

// SetLogsProgressParams adds the logsProgressParams to the update cluster logs progress params
func (o *UpdateClusterLogsProgressParams) SetLogsProgressParams(logsProgressParams *models.LogsProgressParams) {
	o.LogsProgressParams = logsProgressParams
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateClusterLogsProgressParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.LogsProgressParams != nil {
		if err := r.SetBodyParam(o.LogsProgressParams); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
