// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ClusterHostRequirements cluster host requirements
//
// swagger:model cluster-host-requirements
type ClusterHostRequirements struct {

	// Unique identifier of the host the requirements relate to.
	// Format: uuid
	HostID strfmt.UUID `json:"host_id,omitempty"`

	// Host requirements for the OCP installation
	Ocp *ClusterHostRequirementsDetails `json:"ocp,omitempty"`

	// Host requirements related to requested operators
	Operators []*OperatorHostRequirements `json:"operators"`

	// Total host requirements for the cluster configuration
	Total *ClusterHostRequirementsDetails `json:"total,omitempty"`
}

// Validate validates this cluster host requirements
func (m *ClusterHostRequirements) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHostID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOcp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOperators(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTotal(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterHostRequirements) validateHostID(formats strfmt.Registry) error {

	if swag.IsZero(m.HostID) { // not required
		return nil
	}

	if err := validate.FormatOf("host_id", "body", "uuid", m.HostID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ClusterHostRequirements) validateOcp(formats strfmt.Registry) error {

	if swag.IsZero(m.Ocp) { // not required
		return nil
	}

	if m.Ocp != nil {
		if err := m.Ocp.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ocp")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterHostRequirements) validateOperators(formats strfmt.Registry) error {

	if swag.IsZero(m.Operators) { // not required
		return nil
	}

	for i := 0; i < len(m.Operators); i++ {
		if swag.IsZero(m.Operators[i]) { // not required
			continue
		}

		if m.Operators[i] != nil {
			if err := m.Operators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("operators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterHostRequirements) validateTotal(formats strfmt.Registry) error {

	if swag.IsZero(m.Total) { // not required
		return nil
	}

	if m.Total != nil {
		if err := m.Total.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("total")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterHostRequirements) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterHostRequirements) UnmarshalBinary(b []byte) error {
	var res ClusterHostRequirements
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
