// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ManagedDomain managed domain
//
// swagger:model managed-domain
type ManagedDomain struct {

	// domain
	Domain string `json:"domain,omitempty"`

	// provider
	// Enum: [route53]
	Provider string `json:"provider,omitempty"`
}

// Validate validates this managed domain
func (m *ManagedDomain) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateProvider(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var managedDomainTypeProviderPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["route53"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		managedDomainTypeProviderPropEnum = append(managedDomainTypeProviderPropEnum, v)
	}
}

const (

	// ManagedDomainProviderRoute53 captures enum value "route53"
	ManagedDomainProviderRoute53 string = "route53"
)

// prop value enum
func (m *ManagedDomain) validateProviderEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, managedDomainTypeProviderPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ManagedDomain) validateProvider(formats strfmt.Registry) error {

	if swag.IsZero(m.Provider) { // not required
		return nil
	}

	// value enum
	if err := m.validateProviderEnum("provider", "body", m.Provider); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ManagedDomain) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ManagedDomain) UnmarshalBinary(b []byte) error {
	var res ManagedDomain
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
