// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"io"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// NewUpdateClusterInstallConfigParams creates a new UpdateClusterInstallConfigParams object
// no default values defined in spec.
func NewUpdateClusterInstallConfigParams() UpdateClusterInstallConfigParams {

	return UpdateClusterInstallConfigParams{}
}

// UpdateClusterInstallConfigParams contains all the bound params for the update cluster install config operation
// typically these are obtained from a http.Request
//
// swagger:parameters UpdateClusterInstallConfig
type UpdateClusterInstallConfigParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*The cluster whose install config is being updated.
	  Required: true
	  In: path
	*/
	ClusterID strfmt.UUID
	/*Install config overrides.
	  Required: true
	  In: body
	*/
	InstallConfigParams string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewUpdateClusterInstallConfigParams() beforehand.
func (o *UpdateClusterInstallConfigParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	rClusterID, rhkClusterID, _ := route.Params.GetOK("cluster_id")
	if err := o.bindClusterID(rClusterID, rhkClusterID, route.Formats); err != nil {
		res = append(res, err)
	}

	if runtime.HasBody(r) {
		defer r.Body.Close()
		var body string
		if err := route.Consumer.Consume(r.Body, &body); err != nil {
			if err == io.EOF {
				res = append(res, errors.Required("installConfigParams", "body", ""))
			} else {
				res = append(res, errors.NewParseError("installConfigParams", "body", "", err))
			}
		} else {
			// no validation required on inline body
			o.InstallConfigParams = body
		}
	} else {
		res = append(res, errors.Required("installConfigParams", "body", ""))
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindClusterID binds and validates parameter ClusterID from path.
func (o *UpdateClusterInstallConfigParams) bindClusterID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route

	// Format: uuid
	value, err := formats.Parse("uuid", raw)
	if err != nil {
		return errors.InvalidType("cluster_id", "path", "strfmt.UUID", raw)
	}
	o.ClusterID = *(value.(*strfmt.UUID))

	if err := o.validateClusterID(formats); err != nil {
		return err
	}

	return nil
}

// validateClusterID carries on validations for parameter ClusterID
func (o *UpdateClusterInstallConfigParams) validateClusterID(formats strfmt.Registry) error {

	if err := validate.FormatOf("cluster_id", "path", "uuid", o.ClusterID.String(), formats); err != nil {
		return err
	}
	return nil
}
