// Code generated by go-swagger; DO NOT EDIT.

package assisted_service_iso

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// DownloadISOReader is a Reader for the DownloadISO structure.
type DownloadISOReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *DownloadISOReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDownloadISOOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewDownloadISOUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDownloadISOForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDownloadISONotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDownloadISOInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDownloadISOOK creates a DownloadISOOK with default headers values
func NewDownloadISOOK(writer io.Writer) *DownloadISOOK {
	return &DownloadISOOK{
		Payload: writer,
	}
}

/*DownloadISOOK handles this case with default header values.

Success.
*/
type DownloadISOOK struct {
	Payload io.Writer
}

func (o *DownloadISOOK) Error() string {
	return fmt.Sprintf("[GET /assisted-service-iso/data][%d] downloadISOOK  %+v", 200, o.Payload)
}

func (o *DownloadISOOK) GetPayload() io.Writer {
	return o.Payload
}

func (o *DownloadISOOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadISOUnauthorized creates a DownloadISOUnauthorized with default headers values
func NewDownloadISOUnauthorized() *DownloadISOUnauthorized {
	return &DownloadISOUnauthorized{}
}

/*DownloadISOUnauthorized handles this case with default header values.

Unauthorized.
*/
type DownloadISOUnauthorized struct {
	Payload *models.InfraError
}

func (o *DownloadISOUnauthorized) Error() string {
	return fmt.Sprintf("[GET /assisted-service-iso/data][%d] downloadISOUnauthorized  %+v", 401, o.Payload)
}

func (o *DownloadISOUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *DownloadISOUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadISOForbidden creates a DownloadISOForbidden with default headers values
func NewDownloadISOForbidden() *DownloadISOForbidden {
	return &DownloadISOForbidden{}
}

/*DownloadISOForbidden handles this case with default header values.

Forbidden.
*/
type DownloadISOForbidden struct {
	Payload *models.InfraError
}

func (o *DownloadISOForbidden) Error() string {
	return fmt.Sprintf("[GET /assisted-service-iso/data][%d] downloadISOForbidden  %+v", 403, o.Payload)
}

func (o *DownloadISOForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *DownloadISOForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadISONotFound creates a DownloadISONotFound with default headers values
func NewDownloadISONotFound() *DownloadISONotFound {
	return &DownloadISONotFound{}
}

/*DownloadISONotFound handles this case with default header values.

Error.
*/
type DownloadISONotFound struct {
	Payload *models.Error
}

func (o *DownloadISONotFound) Error() string {
	return fmt.Sprintf("[GET /assisted-service-iso/data][%d] downloadISONotFound  %+v", 404, o.Payload)
}

func (o *DownloadISONotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadISONotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadISOInternalServerError creates a DownloadISOInternalServerError with default headers values
func NewDownloadISOInternalServerError() *DownloadISOInternalServerError {
	return &DownloadISOInternalServerError{}
}

/*DownloadISOInternalServerError handles this case with default header values.

Error.
*/
type DownloadISOInternalServerError struct {
	Payload *models.Error
}

func (o *DownloadISOInternalServerError) Error() string {
	return fmt.Sprintf("[GET /assisted-service-iso/data][%d] downloadISOInternalServerError  %+v", 500, o.Payload)
}

func (o *DownloadISOInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadISOInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
