// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/openshift/assisted-service/models"
)

// NewGenerateClusterISOParams creates a new GenerateClusterISOParams object
// with the default values initialized.
func NewGenerateClusterISOParams() *GenerateClusterISOParams {
	var ()
	return &GenerateClusterISOParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewGenerateClusterISOParamsWithTimeout creates a new GenerateClusterISOParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewGenerateClusterISOParamsWithTimeout(timeout time.Duration) *GenerateClusterISOParams {
	var ()
	return &GenerateClusterISOParams{

		timeout: timeout,
	}
}

// NewGenerateClusterISOParamsWithContext creates a new GenerateClusterISOParams object
// with the default values initialized, and the ability to set a context for a request
func NewGenerateClusterISOParamsWithContext(ctx context.Context) *GenerateClusterISOParams {
	var ()
	return &GenerateClusterISOParams{

		Context: ctx,
	}
}

// NewGenerateClusterISOParamsWithHTTPClient creates a new GenerateClusterISOParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewGenerateClusterISOParamsWithHTTPClient(client *http.Client) *GenerateClusterISOParams {
	var ()
	return &GenerateClusterISOParams{
		HTTPClient: client,
	}
}

/*GenerateClusterISOParams contains all the parameters to send to the API endpoint
for the generate cluster i s o operation typically these are written to a http.Request
*/
type GenerateClusterISOParams struct {

	/*ClusterID
	  The cluster whose ISO should be generated.

	*/
	ClusterID strfmt.UUID
	/*ImageCreateParams
	  The parameters for the generated ISO.

	*/
	ImageCreateParams *models.ImageCreateParams

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the generate cluster i s o params
func (o *GenerateClusterISOParams) WithTimeout(timeout time.Duration) *GenerateClusterISOParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the generate cluster i s o params
func (o *GenerateClusterISOParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the generate cluster i s o params
func (o *GenerateClusterISOParams) WithContext(ctx context.Context) *GenerateClusterISOParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the generate cluster i s o params
func (o *GenerateClusterISOParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the generate cluster i s o params
func (o *GenerateClusterISOParams) WithHTTPClient(client *http.Client) *GenerateClusterISOParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the generate cluster i s o params
func (o *GenerateClusterISOParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the generate cluster i s o params
func (o *GenerateClusterISOParams) WithClusterID(clusterID strfmt.UUID) *GenerateClusterISOParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the generate cluster i s o params
func (o *GenerateClusterISOParams) SetClusterID(clusterID strfmt.UUID) {
	o.ClusterID = clusterID
}

// WithImageCreateParams adds the imageCreateParams to the generate cluster i s o params
func (o *GenerateClusterISOParams) WithImageCreateParams(imageCreateParams *models.ImageCreateParams) *GenerateClusterISOParams {
	o.SetImageCreateParams(imageCreateParams)
	return o
}

// SetImageCreateParams adds the imageCreateParams to the generate cluster i s o params
func (o *GenerateClusterISOParams) SetImageCreateParams(imageCreateParams *models.ImageCreateParams) {
	o.ImageCreateParams = imageCreateParams
}

// WriteToRequest writes these params to a swagger request
func (o *GenerateClusterISOParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID.String()); err != nil {
		return err
	}

	if o.ImageCreateParams != nil {
		if err := r.SetBodyParam(o.ImageCreateParams); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
