// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// OpenshiftVersion openshift version
//
// swagger:model openshift-version
type OpenshiftVersion struct {

	// Indication that the version is the recommended one.
	Default bool `json:"default,omitempty"`

	// Name of the version to be presented to the user.
	// Required: true
	DisplayName *string `json:"display_name"`

	// The installation image of the OpenShift cluster.
	// Required: true
	ReleaseImage *string `json:"release_image"`

	// The base RHCOS image used for the discovery iso.
	// Required: true
	RhcosImage *string `json:"rhcos_image"`

	// Build ID of the RHCOS image.
	// Required: true
	RhcosVersion *string `json:"rhcos_version"`

	// Level of support of the version.
	// Required: true
	// Enum: [beta production]
	SupportLevel *string `json:"support_level"`
}

// Validate validates this openshift version
func (m *OpenshiftVersion) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDisplayName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReleaseImage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRhcosImage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRhcosVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSupportLevel(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OpenshiftVersion) validateDisplayName(formats strfmt.Registry) error {

	if err := validate.Required("display_name", "body", m.DisplayName); err != nil {
		return err
	}

	return nil
}

func (m *OpenshiftVersion) validateReleaseImage(formats strfmt.Registry) error {

	if err := validate.Required("release_image", "body", m.ReleaseImage); err != nil {
		return err
	}

	return nil
}

func (m *OpenshiftVersion) validateRhcosImage(formats strfmt.Registry) error {

	if err := validate.Required("rhcos_image", "body", m.RhcosImage); err != nil {
		return err
	}

	return nil
}

func (m *OpenshiftVersion) validateRhcosVersion(formats strfmt.Registry) error {

	if err := validate.Required("rhcos_version", "body", m.RhcosVersion); err != nil {
		return err
	}

	return nil
}

var openshiftVersionTypeSupportLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["beta","production"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		openshiftVersionTypeSupportLevelPropEnum = append(openshiftVersionTypeSupportLevelPropEnum, v)
	}
}

const (

	// OpenshiftVersionSupportLevelBeta captures enum value "beta"
	OpenshiftVersionSupportLevelBeta string = "beta"

	// OpenshiftVersionSupportLevelProduction captures enum value "production"
	OpenshiftVersionSupportLevelProduction string = "production"
)

// prop value enum
func (m *OpenshiftVersion) validateSupportLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, openshiftVersionTypeSupportLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OpenshiftVersion) validateSupportLevel(formats strfmt.Registry) error {

	if err := validate.Required("support_level", "body", m.SupportLevel); err != nil {
		return err
	}

	// value enum
	if err := m.validateSupportLevelEnum("support_level", "body", *m.SupportLevel); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OpenshiftVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OpenshiftVersion) UnmarshalBinary(b []byte) error {
	var res OpenshiftVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
