// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package honeycodeiface provides an interface to enable mocking the Amazon Honeycode service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package honeycodeiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/honeycode"
)

// HoneycodeAPI provides an interface to enable mocking the
// honeycode.Honeycode service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Honeycode.
//    func myFunc(svc honeycodeiface.HoneycodeAPI) bool {
//        // Make svc.GetScreenData request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := honeycode.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockHoneycodeClient struct {
//        honeycodeiface.HoneycodeAPI
//    }
//    func (m *mockHoneycodeClient) GetScreenData(input *honeycode.GetScreenDataInput) (*honeycode.GetScreenDataOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockHoneycodeClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type HoneycodeAPI interface {
	GetScreenData(*honeycode.GetScreenDataInput) (*honeycode.GetScreenDataOutput, error)
	GetScreenDataWithContext(aws.Context, *honeycode.GetScreenDataInput, ...request.Option) (*honeycode.GetScreenDataOutput, error)
	GetScreenDataRequest(*honeycode.GetScreenDataInput) (*request.Request, *honeycode.GetScreenDataOutput)

	InvokeScreenAutomation(*honeycode.InvokeScreenAutomationInput) (*honeycode.InvokeScreenAutomationOutput, error)
	InvokeScreenAutomationWithContext(aws.Context, *honeycode.InvokeScreenAutomationInput, ...request.Option) (*honeycode.InvokeScreenAutomationOutput, error)
	InvokeScreenAutomationRequest(*honeycode.InvokeScreenAutomationInput) (*request.Request, *honeycode.InvokeScreenAutomationOutput)
}

var _ HoneycodeAPI = (*honeycode.Honeycode)(nil)
