// Code generated by go-swagger; DO NOT EDIT.

package installer

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/openshift/assisted-service/models"
)

// DownloadClusterISOHeadersCloneReader is a Reader for the DownloadClusterISOHeadersClone structure.
type DownloadClusterISOHeadersCloneReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DownloadClusterISOHeadersCloneReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDownloadClusterISOHeadersCloneOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDownloadClusterISOHeadersCloneBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDownloadClusterISOHeadersCloneUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDownloadClusterISOHeadersCloneForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDownloadClusterISOHeadersCloneNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 405:
		result := NewDownloadClusterISOHeadersCloneMethodNotAllowed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewDownloadClusterISOHeadersCloneConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDownloadClusterISOHeadersCloneInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDownloadClusterISOHeadersCloneOK creates a DownloadClusterISOHeadersCloneOK with default headers values
func NewDownloadClusterISOHeadersCloneOK() *DownloadClusterISOHeadersCloneOK {
	return &DownloadClusterISOHeadersCloneOK{}
}

/*DownloadClusterISOHeadersCloneOK handles this case with default header values.

Success.
*/
type DownloadClusterISOHeadersCloneOK struct {
	/*Size of the ISO in bytes
	 */
	ContentLength int64
}

func (o *DownloadClusterISOHeadersCloneOK) Error() string {
	return fmt.Sprintf("[HEAD /clusters/{cluster_id}/downloads/image.iso][%d] downloadClusterISOHeadersCloneOK ", 200)
}

func (o *DownloadClusterISOHeadersCloneOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response header Content-Length
	contentLength, err := swag.ConvertInt64(response.GetHeader("Content-Length"))
	if err != nil {
		return errors.InvalidType("Content-Length", "header", "int64", response.GetHeader("Content-Length"))
	}
	o.ContentLength = contentLength

	return nil
}

// NewDownloadClusterISOHeadersCloneBadRequest creates a DownloadClusterISOHeadersCloneBadRequest with default headers values
func NewDownloadClusterISOHeadersCloneBadRequest() *DownloadClusterISOHeadersCloneBadRequest {
	return &DownloadClusterISOHeadersCloneBadRequest{}
}

/*DownloadClusterISOHeadersCloneBadRequest handles this case with default header values.

Error.
*/
type DownloadClusterISOHeadersCloneBadRequest struct {
	Payload *models.Error
}

func (o *DownloadClusterISOHeadersCloneBadRequest) Error() string {
	return fmt.Sprintf("[HEAD /clusters/{cluster_id}/downloads/image.iso][%d] downloadClusterISOHeadersCloneBadRequest  %+v", 400, o.Payload)
}

func (o *DownloadClusterISOHeadersCloneBadRequest) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadClusterISOHeadersCloneBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterISOHeadersCloneUnauthorized creates a DownloadClusterISOHeadersCloneUnauthorized with default headers values
func NewDownloadClusterISOHeadersCloneUnauthorized() *DownloadClusterISOHeadersCloneUnauthorized {
	return &DownloadClusterISOHeadersCloneUnauthorized{}
}

/*DownloadClusterISOHeadersCloneUnauthorized handles this case with default header values.

Unauthorized.
*/
type DownloadClusterISOHeadersCloneUnauthorized struct {
	Payload *models.InfraError
}

func (o *DownloadClusterISOHeadersCloneUnauthorized) Error() string {
	return fmt.Sprintf("[HEAD /clusters/{cluster_id}/downloads/image.iso][%d] downloadClusterISOHeadersCloneUnauthorized  %+v", 401, o.Payload)
}

func (o *DownloadClusterISOHeadersCloneUnauthorized) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *DownloadClusterISOHeadersCloneUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterISOHeadersCloneForbidden creates a DownloadClusterISOHeadersCloneForbidden with default headers values
func NewDownloadClusterISOHeadersCloneForbidden() *DownloadClusterISOHeadersCloneForbidden {
	return &DownloadClusterISOHeadersCloneForbidden{}
}

/*DownloadClusterISOHeadersCloneForbidden handles this case with default header values.

Forbidden.
*/
type DownloadClusterISOHeadersCloneForbidden struct {
	Payload *models.InfraError
}

func (o *DownloadClusterISOHeadersCloneForbidden) Error() string {
	return fmt.Sprintf("[HEAD /clusters/{cluster_id}/downloads/image.iso][%d] downloadClusterISOHeadersCloneForbidden  %+v", 403, o.Payload)
}

func (o *DownloadClusterISOHeadersCloneForbidden) GetPayload() *models.InfraError {
	return o.Payload
}

func (o *DownloadClusterISOHeadersCloneForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InfraError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterISOHeadersCloneNotFound creates a DownloadClusterISOHeadersCloneNotFound with default headers values
func NewDownloadClusterISOHeadersCloneNotFound() *DownloadClusterISOHeadersCloneNotFound {
	return &DownloadClusterISOHeadersCloneNotFound{}
}

/*DownloadClusterISOHeadersCloneNotFound handles this case with default header values.

Error.
*/
type DownloadClusterISOHeadersCloneNotFound struct {
	Payload *models.Error
}

func (o *DownloadClusterISOHeadersCloneNotFound) Error() string {
	return fmt.Sprintf("[HEAD /clusters/{cluster_id}/downloads/image.iso][%d] downloadClusterISOHeadersCloneNotFound  %+v", 404, o.Payload)
}

func (o *DownloadClusterISOHeadersCloneNotFound) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadClusterISOHeadersCloneNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterISOHeadersCloneMethodNotAllowed creates a DownloadClusterISOHeadersCloneMethodNotAllowed with default headers values
func NewDownloadClusterISOHeadersCloneMethodNotAllowed() *DownloadClusterISOHeadersCloneMethodNotAllowed {
	return &DownloadClusterISOHeadersCloneMethodNotAllowed{}
}

/*DownloadClusterISOHeadersCloneMethodNotAllowed handles this case with default header values.

Method Not Allowed.
*/
type DownloadClusterISOHeadersCloneMethodNotAllowed struct {
}

func (o *DownloadClusterISOHeadersCloneMethodNotAllowed) Error() string {
	return fmt.Sprintf("[HEAD /clusters/{cluster_id}/downloads/image.iso][%d] downloadClusterISOHeadersCloneMethodNotAllowed ", 405)
}

func (o *DownloadClusterISOHeadersCloneMethodNotAllowed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDownloadClusterISOHeadersCloneConflict creates a DownloadClusterISOHeadersCloneConflict with default headers values
func NewDownloadClusterISOHeadersCloneConflict() *DownloadClusterISOHeadersCloneConflict {
	return &DownloadClusterISOHeadersCloneConflict{}
}

/*DownloadClusterISOHeadersCloneConflict handles this case with default header values.

Error.
*/
type DownloadClusterISOHeadersCloneConflict struct {
	Payload *models.Error
}

func (o *DownloadClusterISOHeadersCloneConflict) Error() string {
	return fmt.Sprintf("[HEAD /clusters/{cluster_id}/downloads/image.iso][%d] downloadClusterISOHeadersCloneConflict  %+v", 409, o.Payload)
}

func (o *DownloadClusterISOHeadersCloneConflict) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadClusterISOHeadersCloneConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDownloadClusterISOHeadersCloneInternalServerError creates a DownloadClusterISOHeadersCloneInternalServerError with default headers values
func NewDownloadClusterISOHeadersCloneInternalServerError() *DownloadClusterISOHeadersCloneInternalServerError {
	return &DownloadClusterISOHeadersCloneInternalServerError{}
}

/*DownloadClusterISOHeadersCloneInternalServerError handles this case with default header values.

Error.
*/
type DownloadClusterISOHeadersCloneInternalServerError struct {
	Payload *models.Error
}

func (o *DownloadClusterISOHeadersCloneInternalServerError) Error() string {
	return fmt.Sprintf("[HEAD /clusters/{cluster_id}/downloads/image.iso][%d] downloadClusterISOHeadersCloneInternalServerError  %+v", 500, o.Payload)
}

func (o *DownloadClusterISOHeadersCloneInternalServerError) GetPayload() *models.Error {
	return o.Payload
}

func (o *DownloadClusterISOHeadersCloneInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
