// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DhcpAllocationResponse dhcp allocation response
//
// swagger:model dhcp_allocation_response
type DhcpAllocationResponse struct {

	// The IPv4 address that was allocated by DHCP for the API virtual IP.
	// Required: true
	// Format: ipv4
	APIVipAddress *strfmt.IPv4 `json:"api_vip_address"`

	// Contents of last acquired lease for API virtual IP.
	APIVipLease string `json:"api_vip_lease,omitempty"`

	// The IPv4 address that was allocated by DHCP for the Ingress virtual IP.
	// Required: true
	// Format: ipv4
	IngressVipAddress *strfmt.IPv4 `json:"ingress_vip_address"`

	// Contents of last acquired lease for Ingress virtual IP.
	IngressVipLease string `json:"ingress_vip_lease,omitempty"`
}

// Validate validates this dhcp allocation response
func (m *DhcpAllocationResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAPIVipAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIngressVipAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DhcpAllocationResponse) validateAPIVipAddress(formats strfmt.Registry) error {

	if err := validate.Required("api_vip_address", "body", m.APIVipAddress); err != nil {
		return err
	}

	if err := validate.FormatOf("api_vip_address", "body", "ipv4", m.APIVipAddress.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DhcpAllocationResponse) validateIngressVipAddress(formats strfmt.Registry) error {

	if err := validate.Required("ingress_vip_address", "body", m.IngressVipAddress); err != nil {
		return err
	}

	if err := validate.FormatOf("ingress_vip_address", "body", "ipv4", m.IngressVipAddress.String(), formats); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DhcpAllocationResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DhcpAllocationResponse) UnmarshalBinary(b []byte) error {
	var res DhcpAllocationResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
