// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/hive/apis/hive/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SyncIdentityProviderLister helps list SyncIdentityProviders.
// All objects returned here must be treated as read-only.
type SyncIdentityProviderLister interface {
	// List lists all SyncIdentityProviders in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.SyncIdentityProvider, err error)
	// SyncIdentityProviders returns an object that can list and get SyncIdentityProviders.
	SyncIdentityProviders(namespace string) SyncIdentityProviderNamespaceLister
	SyncIdentityProviderListerExpansion
}

// syncIdentityProviderLister implements the SyncIdentityProviderLister interface.
type syncIdentityProviderLister struct {
	indexer cache.Indexer
}

// NewSyncIdentityProviderLister returns a new SyncIdentityProviderLister.
func NewSyncIdentityProviderLister(indexer cache.Indexer) SyncIdentityProviderLister {
	return &syncIdentityProviderLister{indexer: indexer}
}

// List lists all SyncIdentityProviders in the indexer.
func (s *syncIdentityProviderLister) List(selector labels.Selector) (ret []*v1.SyncIdentityProvider, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SyncIdentityProvider))
	})
	return ret, err
}

// SyncIdentityProviders returns an object that can list and get SyncIdentityProviders.
func (s *syncIdentityProviderLister) SyncIdentityProviders(namespace string) SyncIdentityProviderNamespaceLister {
	return syncIdentityProviderNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SyncIdentityProviderNamespaceLister helps list and get SyncIdentityProviders.
// All objects returned here must be treated as read-only.
type SyncIdentityProviderNamespaceLister interface {
	// List lists all SyncIdentityProviders in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.SyncIdentityProvider, err error)
	// Get retrieves the SyncIdentityProvider from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.SyncIdentityProvider, error)
	SyncIdentityProviderNamespaceListerExpansion
}

// syncIdentityProviderNamespaceLister implements the SyncIdentityProviderNamespaceLister
// interface.
type syncIdentityProviderNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all SyncIdentityProviders in the indexer for a given namespace.
func (s syncIdentityProviderNamespaceLister) List(selector labels.Selector) (ret []*v1.SyncIdentityProvider, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SyncIdentityProvider))
	})
	return ret, err
}

// Get retrieves the SyncIdentityProvider from the indexer for a given namespace and name.
func (s syncIdentityProviderNamespaceLister) Get(name string) (*v1.SyncIdentityProvider, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("syncidentityprovider"), name)
	}
	return obj.(*v1.SyncIdentityProvider), nil
}
