package personalizerapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/personalizer/v1.0/personalizer"
	"github.com/Azure/go-autorest/autorest"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	Rank(ctx context.Context, rankRequest personalizer.RankRequest) (result personalizer.RankResponse, err error)
}

var _ BaseClientAPI = (*personalizer.BaseClient)(nil)

// EventsClientAPI contains the set of methods on the EventsClient type.
type EventsClientAPI interface {
	Activate(ctx context.Context, eventID string) (result autorest.Response, err error)
	Reward(ctx context.Context, eventID string, reward personalizer.RewardRequest) (result autorest.Response, err error)
}

var _ EventsClientAPI = (*personalizer.EventsClient)(nil)
