// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by informer-gen. DO NOT EDIT.

package internalversion

import (
	"fmt"

	mcm "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	cache "k8s.io/client-go/tools/cache"
)

// GenericInformer is type of SharedIndexInformer which will locate and delegate to other
// sharedInformers based on type
type GenericInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() cache.GenericLister
}

type genericInformer struct {
	informer cache.SharedIndexInformer
	resource schema.GroupResource
}

// Informer returns the SharedIndexInformer.
func (f *genericInformer) Informer() cache.SharedIndexInformer {
	return f.informer
}

// Lister returns the GenericLister.
func (f *genericInformer) Lister() cache.GenericLister {
	return cache.NewGenericLister(f.Informer().GetIndexer(), f.resource)
}

// ForResource gives generic access to a shared informer of the matching type
// TODO extend this to unknown resources with a client pool
func (f *sharedInformerFactory) ForResource(resource schema.GroupVersionResource) (GenericInformer, error) {
	switch resource {
	// Group=mcm.ibm.com, Version=internalVersion
	case mcm.SchemeGroupVersion.WithResource("clusterjoinrequests"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().InternalVersion().ClusterJoinRequests().Informer()}, nil
	case mcm.SchemeGroupVersion.WithResource("clusterstatuses"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().InternalVersion().ClusterStatuses().Informer()}, nil
	case mcm.SchemeGroupVersion.WithResource("leadervotes"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().InternalVersion().LeaderVotes().Informer()}, nil
	case mcm.SchemeGroupVersion.WithResource("placementbindings"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().InternalVersion().PlacementBindings().Informer()}, nil
	case mcm.SchemeGroupVersion.WithResource("placementpolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().InternalVersion().PlacementPolicies().Informer()}, nil
	case mcm.SchemeGroupVersion.WithResource("resourceviews"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().InternalVersion().ResourceViews().Informer()}, nil
	case mcm.SchemeGroupVersion.WithResource("works"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().InternalVersion().Works().Informer()}, nil
	case mcm.SchemeGroupVersion.WithResource("worksets"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Mcm().InternalVersion().WorkSets().Informer()}, nil

	}

	return nil, fmt.Errorf("no informer found for %v", resource)
}
