export interface BranchSummaryBranch {
    current: boolean;
    name: string;
    commit: string;
    label: string;
}
export interface BranchSummary {
    detached: boolean;
    current: string;
    all: string[];
    branches: {
        [key: string]: BranchSummaryBranch;
    };
}
export declare class BranchSummaryResult implements BranchSummary {
    all: string[];
    branches: {
        [p: string]: BranchSummaryBranch;
    };
    current: string;
    detached: boolean;
    push(current: boolean, detached: boolean, name: string, commit: string, label: string): void;
}
export declare const detachedRegex: RegExp;
export declare const branchRegex: RegExp;
export declare const parseBranchSummary: (commit: string) => BranchSummary;
