"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports._clearCachedJestVersion = void 0;

var _experimentalUtils = require("@typescript-eslint/experimental-utils");

var _utils = require("./utils");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

let cachedJestVersion = null;
/** @internal */

const _clearCachedJestVersion = () => cachedJestVersion = null;

exports._clearCachedJestVersion = _clearCachedJestVersion;

const detectJestVersion = () => {
  if (cachedJestVersion) {
    return cachedJestVersion;
  }

  try {
    const jestPath = require.resolve('jest/package.json', {
      paths: [process.cwd()]
    }); // eslint-disable-next-line @typescript-eslint/no-require-imports


    const jestPackageJson = require(jestPath);

    if (jestPackageJson.version) {
      const [majorVersion] = jestPackageJson.version.split('.');
      return cachedJestVersion = parseInt(majorVersion, 10);
    }
  } catch (_unused) {}

  throw new Error('Unable to detect Jest version - please ensure jest package is installed, or otherwise set version explicitly');
};

var _default = (0, _utils.createRule)({
  name: __filename,
  meta: {
    docs: {
      category: 'Best Practices',
      description: 'Disallow use of deprecated functions',
      recommended: false
    },
    messages: {
      deprecatedFunction: '`{{ deprecation }}` has been deprecated in favor of `{{ replacement }}`'
    },
    type: 'suggestion',
    schema: [],
    fixable: 'code'
  },
  defaultOptions: [],

  create(context) {
    var _ref, _ref$jest;

    const jestVersion = ((_ref = context.settings) === null || _ref === void 0 ? void 0 : (_ref$jest = _ref.jest) === null || _ref$jest === void 0 ? void 0 : _ref$jest.version) || detectJestVersion();

    const deprecations = _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, jestVersion >= 15 && {
      'jest.resetModuleRegistry': 'jest.resetModules'
    }), jestVersion >= 17 && {
      'jest.addMatchers': 'expect.extend'
    }), jestVersion >= 21 && {
      'require.requireMock': 'jest.requireMock',
      'require.requireActual': 'jest.requireActual'
    }), jestVersion >= 22 && {
      'jest.runTimersToTime': 'jest.advanceTimersByTime'
    }), jestVersion >= 26 && {
      'jest.genMockFromModule': 'jest.createMockFromModule'
    });

    return {
      CallExpression(node) {
        if (node.callee.type !== _experimentalUtils.AST_NODE_TYPES.MemberExpression) {
          return;
        }

        const deprecation = (0, _utils.getNodeName)(node);

        if (!deprecation || !(deprecation in deprecations)) {
          return;
        }

        const replacement = deprecations[deprecation];
        const {
          callee
        } = node;
        context.report({
          messageId: 'deprecatedFunction',
          data: {
            deprecation,
            replacement
          },
          node,

          fix(fixer) {
            // eslint-disable-next-line prefer-const
            let [name, func] = replacement.split('.');

            if (callee.property.type === _experimentalUtils.AST_NODE_TYPES.Literal) {
              func = `'${func}'`;
            }

            return [fixer.replaceText(callee.object, name), fixer.replaceText(callee.property, func)];
          }

        });
      }

    };
  }

});

exports.default = _default;