import { GraphQLSchema } from 'graphql';
import { Transform, Request, ExecutionResult } from '@graphql-tools/utils';
import { LeafValueTransformer } from '../types';
export interface MapLeafValuesTransformationContext {
    transformedRequest: Request;
}
export default class MapLeafValues implements Transform<MapLeafValuesTransformationContext> {
    private readonly inputValueTransformer;
    private readonly outputValueTransformer;
    private readonly resultVisitorMap;
    private originalSchema;
    private typeInfo;
    constructor(inputValueTransformer: LeafValueTransformer, outputValueTransformer: LeafValueTransformer);
    transformSchema(originalSchema: GraphQLSchema): GraphQLSchema;
    transformRequest(originalRequest: Request, _delegationContext?: Record<string, any>, transformationContext?: MapLeafValuesTransformationContext): Request;
    transformResult(originalResult: ExecutionResult, _delegationContext?: Record<string, any>, transformationContext?: MapLeafValuesTransformationContext): any;
    private transformOperations;
    private transformFieldNode;
}
