import { Request, Response } from 'apollo-server-env';
import { GraphQLSchema, ValidationContext, ASTVisitor, GraphQLFormattedError, OperationDefinitionNode, DocumentNode, GraphQLError, GraphQLResolveInfo } from 'graphql';
import { KeyValueCache } from 'apollo-server-caching';
import { Trace } from 'apollo-reporting-protobuf';
export declare type BaseContext = Record<string, any>;
export declare type ValueOrPromise<T> = T | Promise<T>;
export declare type WithRequired<T, K extends keyof T> = T & Required<Pick<T, K>>;
export declare type AnyFunction = (...args: any[]) => any;
export declare type AnyFunctionMap = {
    [key: string]: AnyFunction | undefined;
};
declare type Mutable<T> = {
    -readonly [P in keyof T]: T[P];
};
declare type Fauxpaque<K, T> = K & {
    __fauxpaque: T;
};
export declare type SchemaHash = Fauxpaque<string, 'SchemaHash'>;
export interface ApolloConfigInput {
    key?: string;
    graphId?: string;
    graphVariant?: string;
}
export interface ApolloConfig {
    key?: string;
    keyHash?: string;
    graphId?: string;
    graphVariant: string;
}
export interface GraphQLServiceContext {
    logger: Logger;
    schema: GraphQLSchema;
    schemaHash: SchemaHash;
    apollo: ApolloConfig;
    persistedQueries?: {
        cache: KeyValueCache;
    };
    serverlessFramework: boolean;
    engine: {
        serviceID?: string;
        apiKeyHash?: string;
    };
}
export interface GraphQLRequest {
    query?: string;
    operationName?: string;
    variables?: VariableValues;
    extensions?: Record<string, any>;
    http?: Pick<Request, 'url' | 'method' | 'headers'>;
}
export declare type VariableValues = {
    [name: string]: any;
};
export interface GraphQLResponse {
    data?: Record<string, any> | null;
    errors?: ReadonlyArray<GraphQLFormattedError>;
    extensions?: Record<string, any>;
    http?: Pick<Response, 'headers'> & Partial<Pick<Mutable<Response>, 'status'>>;
}
export interface GraphQLRequestMetrics {
    captureTraces?: boolean;
    persistedQueryHit?: boolean;
    persistedQueryRegister?: boolean;
    responseCacheHit?: boolean;
    forbiddenOperation?: boolean;
    registeredOperation?: boolean;
    startHrTime?: [number, number];
    queryPlanTrace?: Trace.QueryPlanNode;
}
export interface GraphQLRequestContext<TContext = Record<string, any>> {
    readonly request: GraphQLRequest;
    readonly response?: GraphQLResponse;
    logger: Logger;
    readonly schema: GraphQLSchema;
    readonly schemaHash: SchemaHash;
    readonly context: TContext;
    readonly cache: KeyValueCache;
    readonly queryHash?: string;
    readonly document?: DocumentNode;
    readonly source?: string;
    readonly operationName?: string | null;
    readonly operation?: OperationDefinitionNode;
    readonly errors?: ReadonlyArray<GraphQLError>;
    readonly metrics: GraphQLRequestMetrics;
    debug?: boolean;
}
export declare type ValidationRule = (context: ValidationContext) => ASTVisitor;
export declare class InvalidGraphQLRequestError extends GraphQLError {
}
export declare type GraphQLExecutor<TContext = Record<string, any>> = (requestContext: GraphQLRequestContextExecutionDidStart<TContext>) => ValueOrPromise<GraphQLExecutionResult>;
export declare type GraphQLExecutionResult = {
    data?: Record<string, any> | null;
    errors?: ReadonlyArray<GraphQLError>;
    extensions?: Record<string, any>;
};
export declare type Logger = {
    debug(message?: any): void;
    info(message?: any): void;
    warn(message?: any): void;
    error(message?: any): void;
};
export declare type GraphQLFieldResolverParams<TSource, TContext, TArgs = {
    [argName: string]: any;
}> = {
    source: TSource;
    args: TArgs;
    context: TContext;
    info: GraphQLResolveInfo;
};
export declare type GraphQLRequestContextDidResolveSource<TContext> = WithRequired<GraphQLRequestContext<TContext>, 'metrics' | 'source' | 'queryHash'>;
export declare type GraphQLRequestContextParsingDidStart<TContext> = GraphQLRequestContextDidResolveSource<TContext>;
export declare type GraphQLRequestContextValidationDidStart<TContext> = GraphQLRequestContextParsingDidStart<TContext> & WithRequired<GraphQLRequestContext<TContext>, 'document'>;
export declare type GraphQLRequestContextDidResolveOperation<TContext> = GraphQLRequestContextValidationDidStart<TContext> & WithRequired<GraphQLRequestContext<TContext>, 'operation' | 'operationName'>;
export declare type GraphQLRequestContextDidEncounterErrors<TContext> = WithRequired<GraphQLRequestContext<TContext>, 'metrics' | 'errors'>;
export declare type GraphQLRequestContextResponseForOperation<TContext> = WithRequired<GraphQLRequestContext<TContext>, 'metrics' | 'source' | 'document' | 'operation' | 'operationName'>;
export declare type GraphQLRequestContextExecutionDidStart<TContext> = GraphQLRequestContextParsingDidStart<TContext> & WithRequired<GraphQLRequestContext<TContext>, 'document' | 'operation' | 'operationName'>;
export declare type GraphQLRequestContextWillSendResponse<TContext> = GraphQLRequestContextDidResolveSource<TContext> & WithRequired<GraphQLRequestContext<TContext>, 'metrics' | 'response'>;
export {};
//# sourceMappingURL=index.d.ts.map