/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
// flowlint ambiguous-object-type:error
'use strict';

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var inferRootArgumentDefinitions = require('../core/inferRootArgumentDefinitions');

var _require = require('../core/CompilerError'),
    createUserError = _require.createUserError,
    eachWithCombinedError = _require.eachWithCombinedError;

var SCHEMA_EXTENSION = 'directive @DEPRECATED__relay_ignore_unused_variables_error on QUERY | MUTATION | SUBSCRIPTION';
/**
 * Validates that there are no unused variables in the operation.
 * former `graphql-js`` NoUnusedVariablesRule
 */

function validateUnusedVariablesTransform(context) {
  var contextWithUsedArguments = inferRootArgumentDefinitions(context);
  eachWithCombinedError(context.documents(), function (node) {
    if (node.kind !== 'Root') {
      return;
    }

    var rootArgumentLocations = new Map(node.argumentDefinitions.map(function (arg) {
      return [arg.name, arg.loc];
    }));
    var nodeWithUsedArguments = contextWithUsedArguments.getRoot(node.name);
    var usedArguments = argumentDefinitionsToMap(nodeWithUsedArguments.argumentDefinitions);

    var _iterator = _createForOfIteratorHelper(usedArguments.keys()),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var usedArgumentName = _step.value;
        rootArgumentLocations["delete"](usedArgumentName);
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    var ignoreErrorDirective = node.directives.find(function (_ref) {
      var name = _ref.name;
      return name === 'DEPRECATED__relay_ignore_unused_variables_error';
    });

    if (rootArgumentLocations.size > 0 && !ignoreErrorDirective) {
      var isPlural = rootArgumentLocations.size > 1;
      throw createUserError("Variable".concat(isPlural ? 's' : '', " '$").concat(Array.from(rootArgumentLocations.keys()).join("', '$"), "' ").concat(isPlural ? 'are' : 'is', " never used in operation '").concat(node.name, "'."), Array.from(rootArgumentLocations.values()));
    }

    if (rootArgumentLocations.size === 0 && ignoreErrorDirective) {
      throw createUserError("Invalid usage of '@DEPRECATED__relay_ignore_unused_variables_error.'" + "No unused variables found in the query '".concat(node.name, "'"), [ignoreErrorDirective.loc]);
    }
  });
  return context;
}

function argumentDefinitionsToMap(argDefs) {
  var map = new Map();

  var _iterator2 = _createForOfIteratorHelper(argDefs),
      _step2;

  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var argDef = _step2.value;
      map.set(argDef.name, argDef);
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }

  return map;
}

module.exports = {
  transform: validateUnusedVariablesTransform,
  SCHEMA_EXTENSION: SCHEMA_EXTENSION
};