"use strict";

/**
 * Module dependencies.
 */
var qs = require('qs');

module.exports = function (res, fn) {
  res.text = '';
  res.setEncoding('ascii');
  res.on('data', function (chunk) {
    res.text += chunk;
  });
  res.on('end', function () {
    try {
      fn(null, qs.parse(res.text));
    } catch (err) {
      fn(err);
    }
  });
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9ub2RlL3BhcnNlcnMvdXJsZW5jb2RlZC5qcyJdLCJuYW1lcyI6WyJxcyIsInJlcXVpcmUiLCJtb2R1bGUiLCJleHBvcnRzIiwicmVzIiwiZm4iLCJ0ZXh0Iiwic2V0RW5jb2RpbmciLCJvbiIsImNodW5rIiwicGFyc2UiLCJlcnIiXSwibWFwcGluZ3MiOiI7O0FBQUE7QUFDQTtBQUNBO0FBRUEsSUFBTUEsRUFBRSxHQUFHQyxPQUFPLENBQUMsSUFBRCxDQUFsQjs7QUFFQUMsTUFBTSxDQUFDQyxPQUFQLEdBQWlCLFVBQUNDLEdBQUQsRUFBTUMsRUFBTixFQUFhO0FBQzVCRCxFQUFBQSxHQUFHLENBQUNFLElBQUosR0FBVyxFQUFYO0FBQ0FGLEVBQUFBLEdBQUcsQ0FBQ0csV0FBSixDQUFnQixPQUFoQjtBQUNBSCxFQUFBQSxHQUFHLENBQUNJLEVBQUosQ0FBTyxNQUFQLEVBQWUsVUFBQ0MsS0FBRCxFQUFXO0FBQ3hCTCxJQUFBQSxHQUFHLENBQUNFLElBQUosSUFBWUcsS0FBWjtBQUNELEdBRkQ7QUFHQUwsRUFBQUEsR0FBRyxDQUFDSSxFQUFKLENBQU8sS0FBUCxFQUFjLFlBQU07QUFDbEIsUUFBSTtBQUNGSCxNQUFBQSxFQUFFLENBQUMsSUFBRCxFQUFPTCxFQUFFLENBQUNVLEtBQUgsQ0FBU04sR0FBRyxDQUFDRSxJQUFiLENBQVAsQ0FBRjtBQUNELEtBRkQsQ0FFRSxPQUFPSyxHQUFQLEVBQVk7QUFDWk4sTUFBQUEsRUFBRSxDQUFDTSxHQUFELENBQUY7QUFDRDtBQUNGLEdBTkQ7QUFPRCxDQWJEIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBNb2R1bGUgZGVwZW5kZW5jaWVzLlxuICovXG5cbmNvbnN0IHFzID0gcmVxdWlyZSgncXMnKTtcblxubW9kdWxlLmV4cG9ydHMgPSAocmVzLCBmbikgPT4ge1xuICByZXMudGV4dCA9ICcnO1xuICByZXMuc2V0RW5jb2RpbmcoJ2FzY2lpJyk7XG4gIHJlcy5vbignZGF0YScsIChjaHVuaykgPT4ge1xuICAgIHJlcy50ZXh0ICs9IGNodW5rO1xuICB9KTtcbiAgcmVzLm9uKCdlbmQnLCAoKSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGZuKG51bGwsIHFzLnBhcnNlKHJlcy50ZXh0KSk7XG4gICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICBmbihlcnIpO1xuICAgIH1cbiAgfSk7XG59O1xuIl19