"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Stream = require('stream');

var util = require('util');

var net = require('net');

var tls = require('tls'); // eslint-disable-next-line node/no-deprecated-api


var _require = require('url'),
    parse = _require.parse;

var process = require('process');

var semverGte = require('semver/functions/gte');

var http2;
if (semverGte(process.version, 'v10.10.0')) http2 = require('http2');else throw new Error('superagent: this version of Node.js does not support http2');
var _http2$constants = http2.constants,
    HTTP2_HEADER_PATH = _http2$constants.HTTP2_HEADER_PATH,
    HTTP2_HEADER_STATUS = _http2$constants.HTTP2_HEADER_STATUS,
    HTTP2_HEADER_METHOD = _http2$constants.HTTP2_HEADER_METHOD,
    HTTP2_HEADER_AUTHORITY = _http2$constants.HTTP2_HEADER_AUTHORITY,
    HTTP2_HEADER_HOST = _http2$constants.HTTP2_HEADER_HOST,
    HTTP2_HEADER_SET_COOKIE = _http2$constants.HTTP2_HEADER_SET_COOKIE,
    NGHTTP2_CANCEL = _http2$constants.NGHTTP2_CANCEL;

function setProtocol(protocol) {
  return {
    request: function request(options) {
      return new Request(protocol, options);
    }
  };
}

function Request(protocol, options) {
  var _this = this;

  Stream.call(this);
  var defaultPort = protocol === 'https:' ? 443 : 80;
  var defaultHost = 'localhost';
  var port = options.port || defaultPort;
  var host = options.host || defaultHost;
  delete options.port;
  delete options.host;
  this.method = options.method;
  this.path = options.path;
  this.protocol = protocol;
  this.host = host;
  delete options.method;
  delete options.path;

  var sessionOptions = _objectSpread({}, options);

  if (options.socketPath) {
    sessionOptions.socketPath = options.socketPath;
    sessionOptions.createConnection = this.createUnixConnection.bind(this);
  }

  this._headers = {};
  var session = http2.connect("".concat(protocol, "//").concat(host, ":").concat(port), sessionOptions);
  this.setHeader('host', "".concat(host, ":").concat(port));
  session.on('error', function (error) {
    return _this.emit('error', error);
  });
  this.session = session;
}
/**
 * Inherit from `Stream` (which inherits from `EventEmitter`).
 */


util.inherits(Request, Stream);

Request.prototype.createUnixConnection = function (authority, options) {
  switch (this.protocol) {
    case 'http:':
      return net.connect(options.socketPath);

    case 'https:':
      options.ALPNProtocols = ['h2'];
      options.servername = this.host;
      options.allowHalfOpen = true;
      return tls.connect(options.socketPath, options);

    default:
      throw new Error('Unsupported protocol', this.protocol);
  }
}; // eslint-disable-next-line no-unused-vars


Request.prototype.setNoDelay = function (bool) {// We can not use setNoDelay with HTTP/2.
  // Node 10 limits http2session.socket methods to ones safe to use with HTTP/2.
  // See also https://nodejs.org/api/http2.html#http2_http2session_socket
};

Request.prototype.getFrame = function () {
  var _method,
      _this2 = this;

  if (this.frame) {
    return this.frame;
  }

  var method = (_method = {}, _defineProperty(_method, HTTP2_HEADER_PATH, this.path), _defineProperty(_method, HTTP2_HEADER_METHOD, this.method), _method);
  var headers = this.mapToHttp2Header(this._headers);
  headers = Object.assign(headers, method);
  var frame = this.session.request(headers); // eslint-disable-next-line no-unused-vars

  frame.once('response', function (headers, flags) {
    headers = _this2.mapToHttpHeader(headers);
    frame.headers = headers;
    frame.statusCode = headers[HTTP2_HEADER_STATUS];
    frame.status = frame.statusCode;

    _this2.emit('response', frame);
  });
  this._headerSent = true;
  frame.once('drain', function () {
    return _this2.emit('drain');
  });
  frame.on('error', function (error) {
    return _this2.emit('error', error);
  });
  frame.on('close', function () {
    return _this2.session.close();
  });
  this.frame = frame;
  return frame;
};

Request.prototype.mapToHttpHeader = function (headers) {
  var keys = Object.keys(headers);
  var http2Headers = {};

  for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
    var key = _keys[_i];
    var value = headers[key];
    key = key.toLowerCase();

    switch (key) {
      case HTTP2_HEADER_SET_COOKIE:
        value = Array.isArray(value) ? value : [value];
        break;

      default:
        break;
    }

    http2Headers[key] = value;
  }

  return http2Headers;
};

Request.prototype.mapToHttp2Header = function (headers) {
  var keys = Object.keys(headers);
  var http2Headers = {};

  for (var _i2 = 0, _keys2 = keys; _i2 < _keys2.length; _i2++) {
    var key = _keys2[_i2];
    var value = headers[key];
    key = key.toLowerCase();

    switch (key) {
      case HTTP2_HEADER_HOST:
        key = HTTP2_HEADER_AUTHORITY;
        value = /^http:\/\/|^https:\/\//.test(value) ? parse(value).host : value;
        break;

      default:
        break;
    }

    http2Headers[key] = value;
  }

  return http2Headers;
};

Request.prototype.setHeader = function (name, value) {
  this._headers[name.toLowerCase()] = value;
};

Request.prototype.getHeader = function (name) {
  return this._headers[name.toLowerCase()];
};

Request.prototype.write = function (data, encoding) {
  var frame = this.getFrame();
  return frame.write(data, encoding);
};

Request.prototype.pipe = function (stream, options) {
  var frame = this.getFrame();
  return frame.pipe(stream, options);
};

Request.prototype.end = function (data) {
  var frame = this.getFrame();
  frame.end(data);
}; // eslint-disable-next-line no-unused-vars


Request.prototype.abort = function (data) {
  var frame = this.getFrame();
  frame.close(NGHTTP2_CANCEL);
  this.session.destroy();
};

exports.setProtocol = setProtocol;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9ub2RlL2h0dHAyd3JhcHBlci5qcyJdLCJuYW1lcyI6WyJTdHJlYW0iLCJyZXF1aXJlIiwidXRpbCIsIm5ldCIsInRscyIsInBhcnNlIiwicHJvY2VzcyIsInNlbXZlckd0ZSIsImh0dHAyIiwidmVyc2lvbiIsIkVycm9yIiwiY29uc3RhbnRzIiwiSFRUUDJfSEVBREVSX1BBVEgiLCJIVFRQMl9IRUFERVJfU1RBVFVTIiwiSFRUUDJfSEVBREVSX01FVEhPRCIsIkhUVFAyX0hFQURFUl9BVVRIT1JJVFkiLCJIVFRQMl9IRUFERVJfSE9TVCIsIkhUVFAyX0hFQURFUl9TRVRfQ09PS0lFIiwiTkdIVFRQMl9DQU5DRUwiLCJzZXRQcm90b2NvbCIsInByb3RvY29sIiwicmVxdWVzdCIsIm9wdGlvbnMiLCJSZXF1ZXN0IiwiY2FsbCIsImRlZmF1bHRQb3J0IiwiZGVmYXVsdEhvc3QiLCJwb3J0IiwiaG9zdCIsIm1ldGhvZCIsInBhdGgiLCJzZXNzaW9uT3B0aW9ucyIsInNvY2tldFBhdGgiLCJjcmVhdGVDb25uZWN0aW9uIiwiY3JlYXRlVW5peENvbm5lY3Rpb24iLCJiaW5kIiwiX2hlYWRlcnMiLCJzZXNzaW9uIiwiY29ubmVjdCIsInNldEhlYWRlciIsIm9uIiwiZXJyb3IiLCJlbWl0IiwiaW5oZXJpdHMiLCJwcm90b3R5cGUiLCJhdXRob3JpdHkiLCJBTFBOUHJvdG9jb2xzIiwic2VydmVybmFtZSIsImFsbG93SGFsZk9wZW4iLCJzZXROb0RlbGF5IiwiYm9vbCIsImdldEZyYW1lIiwiZnJhbWUiLCJoZWFkZXJzIiwibWFwVG9IdHRwMkhlYWRlciIsIk9iamVjdCIsImFzc2lnbiIsIm9uY2UiLCJmbGFncyIsIm1hcFRvSHR0cEhlYWRlciIsInN0YXR1c0NvZGUiLCJzdGF0dXMiLCJfaGVhZGVyU2VudCIsImNsb3NlIiwia2V5cyIsImh0dHAySGVhZGVycyIsImtleSIsInZhbHVlIiwidG9Mb3dlckNhc2UiLCJBcnJheSIsImlzQXJyYXkiLCJ0ZXN0IiwibmFtZSIsImdldEhlYWRlciIsIndyaXRlIiwiZGF0YSIsImVuY29kaW5nIiwicGlwZSIsInN0cmVhbSIsImVuZCIsImFib3J0IiwiZGVzdHJveSIsImV4cG9ydHMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7O0FBQUEsSUFBTUEsTUFBTSxHQUFHQyxPQUFPLENBQUMsUUFBRCxDQUF0Qjs7QUFDQSxJQUFNQyxJQUFJLEdBQUdELE9BQU8sQ0FBQyxNQUFELENBQXBCOztBQUNBLElBQU1FLEdBQUcsR0FBR0YsT0FBTyxDQUFDLEtBQUQsQ0FBbkI7O0FBQ0EsSUFBTUcsR0FBRyxHQUFHSCxPQUFPLENBQUMsS0FBRCxDQUFuQixDLENBQ0E7OztBQUNBLGVBQWtCQSxPQUFPLENBQUMsS0FBRCxDQUF6QjtBQUFBLElBQVFJLEtBQVIsWUFBUUEsS0FBUjs7QUFDQSxJQUFNQyxPQUFPLEdBQUdMLE9BQU8sQ0FBQyxTQUFELENBQXZCOztBQUNBLElBQU1NLFNBQVMsR0FBR04sT0FBTyxDQUFDLHNCQUFELENBQXpCOztBQUVBLElBQUlPLEtBQUo7QUFFQSxJQUFJRCxTQUFTLENBQUNELE9BQU8sQ0FBQ0csT0FBVCxFQUFrQixVQUFsQixDQUFiLEVBQTRDRCxLQUFLLEdBQUdQLE9BQU8sQ0FBQyxPQUFELENBQWYsQ0FBNUMsS0FFRSxNQUFNLElBQUlTLEtBQUosQ0FBVSw0REFBVixDQUFOO0FBRUYsdUJBUUlGLEtBQUssQ0FBQ0csU0FSVjtBQUFBLElBQ0VDLGlCQURGLG9CQUNFQSxpQkFERjtBQUFBLElBRUVDLG1CQUZGLG9CQUVFQSxtQkFGRjtBQUFBLElBR0VDLG1CQUhGLG9CQUdFQSxtQkFIRjtBQUFBLElBSUVDLHNCQUpGLG9CQUlFQSxzQkFKRjtBQUFBLElBS0VDLGlCQUxGLG9CQUtFQSxpQkFMRjtBQUFBLElBTUVDLHVCQU5GLG9CQU1FQSx1QkFORjtBQUFBLElBT0VDLGNBUEYsb0JBT0VBLGNBUEY7O0FBVUEsU0FBU0MsV0FBVCxDQUFxQkMsUUFBckIsRUFBK0I7QUFDN0IsU0FBTztBQUNMQyxJQUFBQSxPQURLLG1CQUNHQyxPQURILEVBQ1k7QUFDZixhQUFPLElBQUlDLE9BQUosQ0FBWUgsUUFBWixFQUFzQkUsT0FBdEIsQ0FBUDtBQUNEO0FBSEksR0FBUDtBQUtEOztBQUVELFNBQVNDLE9BQVQsQ0FBaUJILFFBQWpCLEVBQTJCRSxPQUEzQixFQUFvQztBQUFBOztBQUNsQ3RCLEVBQUFBLE1BQU0sQ0FBQ3dCLElBQVAsQ0FBWSxJQUFaO0FBQ0EsTUFBTUMsV0FBVyxHQUFHTCxRQUFRLEtBQUssUUFBYixHQUF3QixHQUF4QixHQUE4QixFQUFsRDtBQUNBLE1BQU1NLFdBQVcsR0FBRyxXQUFwQjtBQUNBLE1BQU1DLElBQUksR0FBR0wsT0FBTyxDQUFDSyxJQUFSLElBQWdCRixXQUE3QjtBQUNBLE1BQU1HLElBQUksR0FBR04sT0FBTyxDQUFDTSxJQUFSLElBQWdCRixXQUE3QjtBQUVBLFNBQU9KLE9BQU8sQ0FBQ0ssSUFBZjtBQUNBLFNBQU9MLE9BQU8sQ0FBQ00sSUFBZjtBQUVBLE9BQUtDLE1BQUwsR0FBY1AsT0FBTyxDQUFDTyxNQUF0QjtBQUNBLE9BQUtDLElBQUwsR0FBWVIsT0FBTyxDQUFDUSxJQUFwQjtBQUNBLE9BQUtWLFFBQUwsR0FBZ0JBLFFBQWhCO0FBQ0EsT0FBS1EsSUFBTCxHQUFZQSxJQUFaO0FBRUEsU0FBT04sT0FBTyxDQUFDTyxNQUFmO0FBQ0EsU0FBT1AsT0FBTyxDQUFDUSxJQUFmOztBQUVBLE1BQU1DLGNBQWMscUJBQVFULE9BQVIsQ0FBcEI7O0FBQ0EsTUFBSUEsT0FBTyxDQUFDVSxVQUFaLEVBQXdCO0FBQ3RCRCxJQUFBQSxjQUFjLENBQUNDLFVBQWYsR0FBNEJWLE9BQU8sQ0FBQ1UsVUFBcEM7QUFDQUQsSUFBQUEsY0FBYyxDQUFDRSxnQkFBZixHQUFrQyxLQUFLQyxvQkFBTCxDQUEwQkMsSUFBMUIsQ0FBK0IsSUFBL0IsQ0FBbEM7QUFDRDs7QUFFRCxPQUFLQyxRQUFMLEdBQWdCLEVBQWhCO0FBRUEsTUFBTUMsT0FBTyxHQUFHN0IsS0FBSyxDQUFDOEIsT0FBTixXQUFpQmxCLFFBQWpCLGVBQThCUSxJQUE5QixjQUFzQ0QsSUFBdEMsR0FBOENJLGNBQTlDLENBQWhCO0FBQ0EsT0FBS1EsU0FBTCxDQUFlLE1BQWYsWUFBMEJYLElBQTFCLGNBQWtDRCxJQUFsQztBQUVBVSxFQUFBQSxPQUFPLENBQUNHLEVBQVIsQ0FBVyxPQUFYLEVBQW9CLFVBQUNDLEtBQUQ7QUFBQSxXQUFXLEtBQUksQ0FBQ0MsSUFBTCxDQUFVLE9BQVYsRUFBbUJELEtBQW5CLENBQVg7QUFBQSxHQUFwQjtBQUVBLE9BQUtKLE9BQUwsR0FBZUEsT0FBZjtBQUNEO0FBRUQ7QUFDQTtBQUNBOzs7QUFDQW5DLElBQUksQ0FBQ3lDLFFBQUwsQ0FBY3BCLE9BQWQsRUFBdUJ2QixNQUF2Qjs7QUFFQXVCLE9BQU8sQ0FBQ3FCLFNBQVIsQ0FBa0JWLG9CQUFsQixHQUF5QyxVQUFVVyxTQUFWLEVBQXFCdkIsT0FBckIsRUFBOEI7QUFDckUsVUFBUSxLQUFLRixRQUFiO0FBQ0UsU0FBSyxPQUFMO0FBQ0UsYUFBT2pCLEdBQUcsQ0FBQ21DLE9BQUosQ0FBWWhCLE9BQU8sQ0FBQ1UsVUFBcEIsQ0FBUDs7QUFDRixTQUFLLFFBQUw7QUFDRVYsTUFBQUEsT0FBTyxDQUFDd0IsYUFBUixHQUF3QixDQUFDLElBQUQsQ0FBeEI7QUFDQXhCLE1BQUFBLE9BQU8sQ0FBQ3lCLFVBQVIsR0FBcUIsS0FBS25CLElBQTFCO0FBQ0FOLE1BQUFBLE9BQU8sQ0FBQzBCLGFBQVIsR0FBd0IsSUFBeEI7QUFDQSxhQUFPNUMsR0FBRyxDQUFDa0MsT0FBSixDQUFZaEIsT0FBTyxDQUFDVSxVQUFwQixFQUFnQ1YsT0FBaEMsQ0FBUDs7QUFDRjtBQUNFLFlBQU0sSUFBSVosS0FBSixDQUFVLHNCQUFWLEVBQWtDLEtBQUtVLFFBQXZDLENBQU47QUFUSjtBQVdELENBWkQsQyxDQWNBOzs7QUFDQUcsT0FBTyxDQUFDcUIsU0FBUixDQUFrQkssVUFBbEIsR0FBK0IsVUFBVUMsSUFBVixFQUFnQixDQUM3QztBQUNBO0FBQ0E7QUFDRCxDQUpEOztBQU1BM0IsT0FBTyxDQUFDcUIsU0FBUixDQUFrQk8sUUFBbEIsR0FBNkIsWUFBWTtBQUFBO0FBQUE7O0FBQ3ZDLE1BQUksS0FBS0MsS0FBVCxFQUFnQjtBQUNkLFdBQU8sS0FBS0EsS0FBWjtBQUNEOztBQUVELE1BQU12QixNQUFNLDJDQUNUakIsaUJBRFMsRUFDVyxLQUFLa0IsSUFEaEIsNEJBRVRoQixtQkFGUyxFQUVhLEtBQUtlLE1BRmxCLFdBQVo7QUFLQSxNQUFJd0IsT0FBTyxHQUFHLEtBQUtDLGdCQUFMLENBQXNCLEtBQUtsQixRQUEzQixDQUFkO0FBRUFpQixFQUFBQSxPQUFPLEdBQUdFLE1BQU0sQ0FBQ0MsTUFBUCxDQUFjSCxPQUFkLEVBQXVCeEIsTUFBdkIsQ0FBVjtBQUVBLE1BQU11QixLQUFLLEdBQUcsS0FBS2YsT0FBTCxDQUFhaEIsT0FBYixDQUFxQmdDLE9BQXJCLENBQWQsQ0FkdUMsQ0FldkM7O0FBQ0FELEVBQUFBLEtBQUssQ0FBQ0ssSUFBTixDQUFXLFVBQVgsRUFBdUIsVUFBQ0osT0FBRCxFQUFVSyxLQUFWLEVBQW9CO0FBQ3pDTCxJQUFBQSxPQUFPLEdBQUcsTUFBSSxDQUFDTSxlQUFMLENBQXFCTixPQUFyQixDQUFWO0FBQ0FELElBQUFBLEtBQUssQ0FBQ0MsT0FBTixHQUFnQkEsT0FBaEI7QUFDQUQsSUFBQUEsS0FBSyxDQUFDUSxVQUFOLEdBQW1CUCxPQUFPLENBQUN4QyxtQkFBRCxDQUExQjtBQUNBdUMsSUFBQUEsS0FBSyxDQUFDUyxNQUFOLEdBQWVULEtBQUssQ0FBQ1EsVUFBckI7O0FBQ0EsSUFBQSxNQUFJLENBQUNsQixJQUFMLENBQVUsVUFBVixFQUFzQlUsS0FBdEI7QUFDRCxHQU5EO0FBUUEsT0FBS1UsV0FBTCxHQUFtQixJQUFuQjtBQUVBVixFQUFBQSxLQUFLLENBQUNLLElBQU4sQ0FBVyxPQUFYLEVBQW9CO0FBQUEsV0FBTSxNQUFJLENBQUNmLElBQUwsQ0FBVSxPQUFWLENBQU47QUFBQSxHQUFwQjtBQUNBVSxFQUFBQSxLQUFLLENBQUNaLEVBQU4sQ0FBUyxPQUFULEVBQWtCLFVBQUNDLEtBQUQ7QUFBQSxXQUFXLE1BQUksQ0FBQ0MsSUFBTCxDQUFVLE9BQVYsRUFBbUJELEtBQW5CLENBQVg7QUFBQSxHQUFsQjtBQUNBVyxFQUFBQSxLQUFLLENBQUNaLEVBQU4sQ0FBUyxPQUFULEVBQWtCO0FBQUEsV0FBTSxNQUFJLENBQUNILE9BQUwsQ0FBYTBCLEtBQWIsRUFBTjtBQUFBLEdBQWxCO0FBRUEsT0FBS1gsS0FBTCxHQUFhQSxLQUFiO0FBQ0EsU0FBT0EsS0FBUDtBQUNELENBaENEOztBQWtDQTdCLE9BQU8sQ0FBQ3FCLFNBQVIsQ0FBa0JlLGVBQWxCLEdBQW9DLFVBQVVOLE9BQVYsRUFBbUI7QUFDckQsTUFBTVcsSUFBSSxHQUFHVCxNQUFNLENBQUNTLElBQVAsQ0FBWVgsT0FBWixDQUFiO0FBQ0EsTUFBTVksWUFBWSxHQUFHLEVBQXJCOztBQUNBLDJCQUFnQkQsSUFBaEIsMkJBQXNCO0FBQWpCLFFBQUlFLEdBQUcsWUFBUDtBQUNILFFBQUlDLEtBQUssR0FBR2QsT0FBTyxDQUFDYSxHQUFELENBQW5CO0FBQ0FBLElBQUFBLEdBQUcsR0FBR0EsR0FBRyxDQUFDRSxXQUFKLEVBQU47O0FBQ0EsWUFBUUYsR0FBUjtBQUNFLFdBQUtqRCx1QkFBTDtBQUNFa0QsUUFBQUEsS0FBSyxHQUFHRSxLQUFLLENBQUNDLE9BQU4sQ0FBY0gsS0FBZCxJQUF1QkEsS0FBdkIsR0FBK0IsQ0FBQ0EsS0FBRCxDQUF2QztBQUNBOztBQUNGO0FBQ0U7QUFMSjs7QUFRQUYsSUFBQUEsWUFBWSxDQUFDQyxHQUFELENBQVosR0FBb0JDLEtBQXBCO0FBQ0Q7O0FBRUQsU0FBT0YsWUFBUDtBQUNELENBbEJEOztBQW9CQTFDLE9BQU8sQ0FBQ3FCLFNBQVIsQ0FBa0JVLGdCQUFsQixHQUFxQyxVQUFVRCxPQUFWLEVBQW1CO0FBQ3RELE1BQU1XLElBQUksR0FBR1QsTUFBTSxDQUFDUyxJQUFQLENBQVlYLE9BQVosQ0FBYjtBQUNBLE1BQU1ZLFlBQVksR0FBRyxFQUFyQjs7QUFDQSw2QkFBZ0JELElBQWhCLDhCQUFzQjtBQUFqQixRQUFJRSxHQUFHLGNBQVA7QUFDSCxRQUFJQyxLQUFLLEdBQUdkLE9BQU8sQ0FBQ2EsR0FBRCxDQUFuQjtBQUNBQSxJQUFBQSxHQUFHLEdBQUdBLEdBQUcsQ0FBQ0UsV0FBSixFQUFOOztBQUNBLFlBQVFGLEdBQVI7QUFDRSxXQUFLbEQsaUJBQUw7QUFDRWtELFFBQUFBLEdBQUcsR0FBR25ELHNCQUFOO0FBQ0FvRCxRQUFBQSxLQUFLLEdBQUcseUJBQXlCSSxJQUF6QixDQUE4QkosS0FBOUIsSUFDSjlELEtBQUssQ0FBQzhELEtBQUQsQ0FBTCxDQUFhdkMsSUFEVCxHQUVKdUMsS0FGSjtBQUdBOztBQUNGO0FBQ0U7QUFSSjs7QUFXQUYsSUFBQUEsWUFBWSxDQUFDQyxHQUFELENBQVosR0FBb0JDLEtBQXBCO0FBQ0Q7O0FBRUQsU0FBT0YsWUFBUDtBQUNELENBckJEOztBQXVCQTFDLE9BQU8sQ0FBQ3FCLFNBQVIsQ0FBa0JMLFNBQWxCLEdBQThCLFVBQVVpQyxJQUFWLEVBQWdCTCxLQUFoQixFQUF1QjtBQUNuRCxPQUFLL0IsUUFBTCxDQUFjb0MsSUFBSSxDQUFDSixXQUFMLEVBQWQsSUFBb0NELEtBQXBDO0FBQ0QsQ0FGRDs7QUFJQTVDLE9BQU8sQ0FBQ3FCLFNBQVIsQ0FBa0I2QixTQUFsQixHQUE4QixVQUFVRCxJQUFWLEVBQWdCO0FBQzVDLFNBQU8sS0FBS3BDLFFBQUwsQ0FBY29DLElBQUksQ0FBQ0osV0FBTCxFQUFkLENBQVA7QUFDRCxDQUZEOztBQUlBN0MsT0FBTyxDQUFDcUIsU0FBUixDQUFrQjhCLEtBQWxCLEdBQTBCLFVBQVVDLElBQVYsRUFBZ0JDLFFBQWhCLEVBQTBCO0FBQ2xELE1BQU14QixLQUFLLEdBQUcsS0FBS0QsUUFBTCxFQUFkO0FBQ0EsU0FBT0MsS0FBSyxDQUFDc0IsS0FBTixDQUFZQyxJQUFaLEVBQWtCQyxRQUFsQixDQUFQO0FBQ0QsQ0FIRDs7QUFLQXJELE9BQU8sQ0FBQ3FCLFNBQVIsQ0FBa0JpQyxJQUFsQixHQUF5QixVQUFVQyxNQUFWLEVBQWtCeEQsT0FBbEIsRUFBMkI7QUFDbEQsTUFBTThCLEtBQUssR0FBRyxLQUFLRCxRQUFMLEVBQWQ7QUFDQSxTQUFPQyxLQUFLLENBQUN5QixJQUFOLENBQVdDLE1BQVgsRUFBbUJ4RCxPQUFuQixDQUFQO0FBQ0QsQ0FIRDs7QUFLQUMsT0FBTyxDQUFDcUIsU0FBUixDQUFrQm1DLEdBQWxCLEdBQXdCLFVBQVVKLElBQVYsRUFBZ0I7QUFDdEMsTUFBTXZCLEtBQUssR0FBRyxLQUFLRCxRQUFMLEVBQWQ7QUFDQUMsRUFBQUEsS0FBSyxDQUFDMkIsR0FBTixDQUFVSixJQUFWO0FBQ0QsQ0FIRCxDLENBS0E7OztBQUNBcEQsT0FBTyxDQUFDcUIsU0FBUixDQUFrQm9DLEtBQWxCLEdBQTBCLFVBQVVMLElBQVYsRUFBZ0I7QUFDeEMsTUFBTXZCLEtBQUssR0FBRyxLQUFLRCxRQUFMLEVBQWQ7QUFDQUMsRUFBQUEsS0FBSyxDQUFDVyxLQUFOLENBQVk3QyxjQUFaO0FBQ0EsT0FBS21CLE9BQUwsQ0FBYTRDLE9BQWI7QUFDRCxDQUpEOztBQU1BQyxPQUFPLENBQUMvRCxXQUFSLEdBQXNCQSxXQUF0QiIsInNvdXJjZXNDb250ZW50IjpbImNvbnN0IFN0cmVhbSA9IHJlcXVpcmUoJ3N0cmVhbScpO1xuY29uc3QgdXRpbCA9IHJlcXVpcmUoJ3V0aWwnKTtcbmNvbnN0IG5ldCA9IHJlcXVpcmUoJ25ldCcpO1xuY29uc3QgdGxzID0gcmVxdWlyZSgndGxzJyk7XG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm9kZS9uby1kZXByZWNhdGVkLWFwaVxuY29uc3QgeyBwYXJzZSB9ID0gcmVxdWlyZSgndXJsJyk7XG5jb25zdCBwcm9jZXNzID0gcmVxdWlyZSgncHJvY2VzcycpO1xuY29uc3Qgc2VtdmVyR3RlID0gcmVxdWlyZSgnc2VtdmVyL2Z1bmN0aW9ucy9ndGUnKTtcblxubGV0IGh0dHAyO1xuXG5pZiAoc2VtdmVyR3RlKHByb2Nlc3MudmVyc2lvbiwgJ3YxMC4xMC4wJykpIGh0dHAyID0gcmVxdWlyZSgnaHR0cDInKTtcbmVsc2VcbiAgdGhyb3cgbmV3IEVycm9yKCdzdXBlcmFnZW50OiB0aGlzIHZlcnNpb24gb2YgTm9kZS5qcyBkb2VzIG5vdCBzdXBwb3J0IGh0dHAyJyk7XG5cbmNvbnN0IHtcbiAgSFRUUDJfSEVBREVSX1BBVEgsXG4gIEhUVFAyX0hFQURFUl9TVEFUVVMsXG4gIEhUVFAyX0hFQURFUl9NRVRIT0QsXG4gIEhUVFAyX0hFQURFUl9BVVRIT1JJVFksXG4gIEhUVFAyX0hFQURFUl9IT1NULFxuICBIVFRQMl9IRUFERVJfU0VUX0NPT0tJRSxcbiAgTkdIVFRQMl9DQU5DRUxcbn0gPSBodHRwMi5jb25zdGFudHM7XG5cbmZ1bmN0aW9uIHNldFByb3RvY29sKHByb3RvY29sKSB7XG4gIHJldHVybiB7XG4gICAgcmVxdWVzdChvcHRpb25zKSB7XG4gICAgICByZXR1cm4gbmV3IFJlcXVlc3QocHJvdG9jb2wsIG9wdGlvbnMpO1xuICAgIH1cbiAgfTtcbn1cblxuZnVuY3Rpb24gUmVxdWVzdChwcm90b2NvbCwgb3B0aW9ucykge1xuICBTdHJlYW0uY2FsbCh0aGlzKTtcbiAgY29uc3QgZGVmYXVsdFBvcnQgPSBwcm90b2NvbCA9PT0gJ2h0dHBzOicgPyA0NDMgOiA4MDtcbiAgY29uc3QgZGVmYXVsdEhvc3QgPSAnbG9jYWxob3N0JztcbiAgY29uc3QgcG9ydCA9IG9wdGlvbnMucG9ydCB8fCBkZWZhdWx0UG9ydDtcbiAgY29uc3QgaG9zdCA9IG9wdGlvbnMuaG9zdCB8fCBkZWZhdWx0SG9zdDtcblxuICBkZWxldGUgb3B0aW9ucy5wb3J0O1xuICBkZWxldGUgb3B0aW9ucy5ob3N0O1xuXG4gIHRoaXMubWV0aG9kID0gb3B0aW9ucy5tZXRob2Q7XG4gIHRoaXMucGF0aCA9IG9wdGlvbnMucGF0aDtcbiAgdGhpcy5wcm90b2NvbCA9IHByb3RvY29sO1xuICB0aGlzLmhvc3QgPSBob3N0O1xuXG4gIGRlbGV0ZSBvcHRpb25zLm1ldGhvZDtcbiAgZGVsZXRlIG9wdGlvbnMucGF0aDtcblxuICBjb25zdCBzZXNzaW9uT3B0aW9ucyA9IHsgLi4ub3B0aW9ucyB9O1xuICBpZiAob3B0aW9ucy5zb2NrZXRQYXRoKSB7XG4gICAgc2Vzc2lvbk9wdGlvbnMuc29ja2V0UGF0aCA9IG9wdGlvbnMuc29ja2V0UGF0aDtcbiAgICBzZXNzaW9uT3B0aW9ucy5jcmVhdGVDb25uZWN0aW9uID0gdGhpcy5jcmVhdGVVbml4Q29ubmVjdGlvbi5iaW5kKHRoaXMpO1xuICB9XG5cbiAgdGhpcy5faGVhZGVycyA9IHt9O1xuXG4gIGNvbnN0IHNlc3Npb24gPSBodHRwMi5jb25uZWN0KGAke3Byb3RvY29sfS8vJHtob3N0fToke3BvcnR9YCwgc2Vzc2lvbk9wdGlvbnMpO1xuICB0aGlzLnNldEhlYWRlcignaG9zdCcsIGAke2hvc3R9OiR7cG9ydH1gKTtcblxuICBzZXNzaW9uLm9uKCdlcnJvcicsIChlcnJvcikgPT4gdGhpcy5lbWl0KCdlcnJvcicsIGVycm9yKSk7XG5cbiAgdGhpcy5zZXNzaW9uID0gc2Vzc2lvbjtcbn1cblxuLyoqXG4gKiBJbmhlcml0IGZyb20gYFN0cmVhbWAgKHdoaWNoIGluaGVyaXRzIGZyb20gYEV2ZW50RW1pdHRlcmApLlxuICovXG51dGlsLmluaGVyaXRzKFJlcXVlc3QsIFN0cmVhbSk7XG5cblJlcXVlc3QucHJvdG90eXBlLmNyZWF0ZVVuaXhDb25uZWN0aW9uID0gZnVuY3Rpb24gKGF1dGhvcml0eSwgb3B0aW9ucykge1xuICBzd2l0Y2ggKHRoaXMucHJvdG9jb2wpIHtcbiAgICBjYXNlICdodHRwOic6XG4gICAgICByZXR1cm4gbmV0LmNvbm5lY3Qob3B0aW9ucy5zb2NrZXRQYXRoKTtcbiAgICBjYXNlICdodHRwczonOlxuICAgICAgb3B0aW9ucy5BTFBOUHJvdG9jb2xzID0gWydoMiddO1xuICAgICAgb3B0aW9ucy5zZXJ2ZXJuYW1lID0gdGhpcy5ob3N0O1xuICAgICAgb3B0aW9ucy5hbGxvd0hhbGZPcGVuID0gdHJ1ZTtcbiAgICAgIHJldHVybiB0bHMuY29ubmVjdChvcHRpb25zLnNvY2tldFBhdGgsIG9wdGlvbnMpO1xuICAgIGRlZmF1bHQ6XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1Vuc3VwcG9ydGVkIHByb3RvY29sJywgdGhpcy5wcm90b2NvbCk7XG4gIH1cbn07XG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby11bnVzZWQtdmFyc1xuUmVxdWVzdC5wcm90b3R5cGUuc2V0Tm9EZWxheSA9IGZ1bmN0aW9uIChib29sKSB7XG4gIC8vIFdlIGNhbiBub3QgdXNlIHNldE5vRGVsYXkgd2l0aCBIVFRQLzIuXG4gIC8vIE5vZGUgMTAgbGltaXRzIGh0dHAyc2Vzc2lvbi5zb2NrZXQgbWV0aG9kcyB0byBvbmVzIHNhZmUgdG8gdXNlIHdpdGggSFRUUC8yLlxuICAvLyBTZWUgYWxzbyBodHRwczovL25vZGVqcy5vcmcvYXBpL2h0dHAyLmh0bWwjaHR0cDJfaHR0cDJzZXNzaW9uX3NvY2tldFxufTtcblxuUmVxdWVzdC5wcm90b3R5cGUuZ2V0RnJhbWUgPSBmdW5jdGlvbiAoKSB7XG4gIGlmICh0aGlzLmZyYW1lKSB7XG4gICAgcmV0dXJuIHRoaXMuZnJhbWU7XG4gIH1cblxuICBjb25zdCBtZXRob2QgPSB7XG4gICAgW0hUVFAyX0hFQURFUl9QQVRIXTogdGhpcy5wYXRoLFxuICAgIFtIVFRQMl9IRUFERVJfTUVUSE9EXTogdGhpcy5tZXRob2RcbiAgfTtcblxuICBsZXQgaGVhZGVycyA9IHRoaXMubWFwVG9IdHRwMkhlYWRlcih0aGlzLl9oZWFkZXJzKTtcblxuICBoZWFkZXJzID0gT2JqZWN0LmFzc2lnbihoZWFkZXJzLCBtZXRob2QpO1xuXG4gIGNvbnN0IGZyYW1lID0gdGhpcy5zZXNzaW9uLnJlcXVlc3QoaGVhZGVycyk7XG4gIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby11bnVzZWQtdmFyc1xuICBmcmFtZS5vbmNlKCdyZXNwb25zZScsIChoZWFkZXJzLCBmbGFncykgPT4ge1xuICAgIGhlYWRlcnMgPSB0aGlzLm1hcFRvSHR0cEhlYWRlcihoZWFkZXJzKTtcbiAgICBmcmFtZS5oZWFkZXJzID0gaGVhZGVycztcbiAgICBmcmFtZS5zdGF0dXNDb2RlID0gaGVhZGVyc1tIVFRQMl9IRUFERVJfU1RBVFVTXTtcbiAgICBmcmFtZS5zdGF0dXMgPSBmcmFtZS5zdGF0dXNDb2RlO1xuICAgIHRoaXMuZW1pdCgncmVzcG9uc2UnLCBmcmFtZSk7XG4gIH0pO1xuXG4gIHRoaXMuX2hlYWRlclNlbnQgPSB0cnVlO1xuXG4gIGZyYW1lLm9uY2UoJ2RyYWluJywgKCkgPT4gdGhpcy5lbWl0KCdkcmFpbicpKTtcbiAgZnJhbWUub24oJ2Vycm9yJywgKGVycm9yKSA9PiB0aGlzLmVtaXQoJ2Vycm9yJywgZXJyb3IpKTtcbiAgZnJhbWUub24oJ2Nsb3NlJywgKCkgPT4gdGhpcy5zZXNzaW9uLmNsb3NlKCkpO1xuXG4gIHRoaXMuZnJhbWUgPSBmcmFtZTtcbiAgcmV0dXJuIGZyYW1lO1xufTtcblxuUmVxdWVzdC5wcm90b3R5cGUubWFwVG9IdHRwSGVhZGVyID0gZnVuY3Rpb24gKGhlYWRlcnMpIHtcbiAgY29uc3Qga2V5cyA9IE9iamVjdC5rZXlzKGhlYWRlcnMpO1xuICBjb25zdCBodHRwMkhlYWRlcnMgPSB7fTtcbiAgZm9yIChsZXQga2V5IG9mIGtleXMpIHtcbiAgICBsZXQgdmFsdWUgPSBoZWFkZXJzW2tleV07XG4gICAga2V5ID0ga2V5LnRvTG93ZXJDYXNlKCk7XG4gICAgc3dpdGNoIChrZXkpIHtcbiAgICAgIGNhc2UgSFRUUDJfSEVBREVSX1NFVF9DT09LSUU6XG4gICAgICAgIHZhbHVlID0gQXJyYXkuaXNBcnJheSh2YWx1ZSkgPyB2YWx1ZSA6IFt2YWx1ZV07XG4gICAgICAgIGJyZWFrO1xuICAgICAgZGVmYXVsdDpcbiAgICAgICAgYnJlYWs7XG4gICAgfVxuXG4gICAgaHR0cDJIZWFkZXJzW2tleV0gPSB2YWx1ZTtcbiAgfVxuXG4gIHJldHVybiBodHRwMkhlYWRlcnM7XG59O1xuXG5SZXF1ZXN0LnByb3RvdHlwZS5tYXBUb0h0dHAySGVhZGVyID0gZnVuY3Rpb24gKGhlYWRlcnMpIHtcbiAgY29uc3Qga2V5cyA9IE9iamVjdC5rZXlzKGhlYWRlcnMpO1xuICBjb25zdCBodHRwMkhlYWRlcnMgPSB7fTtcbiAgZm9yIChsZXQga2V5IG9mIGtleXMpIHtcbiAgICBsZXQgdmFsdWUgPSBoZWFkZXJzW2tleV07XG4gICAga2V5ID0ga2V5LnRvTG93ZXJDYXNlKCk7XG4gICAgc3dpdGNoIChrZXkpIHtcbiAgICAgIGNhc2UgSFRUUDJfSEVBREVSX0hPU1Q6XG4gICAgICAgIGtleSA9IEhUVFAyX0hFQURFUl9BVVRIT1JJVFk7XG4gICAgICAgIHZhbHVlID0gL15odHRwOlxcL1xcL3xeaHR0cHM6XFwvXFwvLy50ZXN0KHZhbHVlKVxuICAgICAgICAgID8gcGFyc2UodmFsdWUpLmhvc3RcbiAgICAgICAgICA6IHZhbHVlO1xuICAgICAgICBicmVhaztcbiAgICAgIGRlZmF1bHQ6XG4gICAgICAgIGJyZWFrO1xuICAgIH1cblxuICAgIGh0dHAySGVhZGVyc1trZXldID0gdmFsdWU7XG4gIH1cblxuICByZXR1cm4gaHR0cDJIZWFkZXJzO1xufTtcblxuUmVxdWVzdC5wcm90b3R5cGUuc2V0SGVhZGVyID0gZnVuY3Rpb24gKG5hbWUsIHZhbHVlKSB7XG4gIHRoaXMuX2hlYWRlcnNbbmFtZS50b0xvd2VyQ2FzZSgpXSA9IHZhbHVlO1xufTtcblxuUmVxdWVzdC5wcm90b3R5cGUuZ2V0SGVhZGVyID0gZnVuY3Rpb24gKG5hbWUpIHtcbiAgcmV0dXJuIHRoaXMuX2hlYWRlcnNbbmFtZS50b0xvd2VyQ2FzZSgpXTtcbn07XG5cblJlcXVlc3QucHJvdG90eXBlLndyaXRlID0gZnVuY3Rpb24gKGRhdGEsIGVuY29kaW5nKSB7XG4gIGNvbnN0IGZyYW1lID0gdGhpcy5nZXRGcmFtZSgpO1xuICByZXR1cm4gZnJhbWUud3JpdGUoZGF0YSwgZW5jb2RpbmcpO1xufTtcblxuUmVxdWVzdC5wcm90b3R5cGUucGlwZSA9IGZ1bmN0aW9uIChzdHJlYW0sIG9wdGlvbnMpIHtcbiAgY29uc3QgZnJhbWUgPSB0aGlzLmdldEZyYW1lKCk7XG4gIHJldHVybiBmcmFtZS5waXBlKHN0cmVhbSwgb3B0aW9ucyk7XG59O1xuXG5SZXF1ZXN0LnByb3RvdHlwZS5lbmQgPSBmdW5jdGlvbiAoZGF0YSkge1xuICBjb25zdCBmcmFtZSA9IHRoaXMuZ2V0RnJhbWUoKTtcbiAgZnJhbWUuZW5kKGRhdGEpO1xufTtcblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLXVudXNlZC12YXJzXG5SZXF1ZXN0LnByb3RvdHlwZS5hYm9ydCA9IGZ1bmN0aW9uIChkYXRhKSB7XG4gIGNvbnN0IGZyYW1lID0gdGhpcy5nZXRGcmFtZSgpO1xuICBmcmFtZS5jbG9zZShOR0hUVFAyX0NBTkNFTCk7XG4gIHRoaXMuc2Vzc2lvbi5kZXN0cm95KCk7XG59O1xuXG5leHBvcnRzLnNldFByb3RvY29sID0gc2V0UHJvdG9jb2w7XG4iXX0=