"use strict";

module.exports = function (res, fn) {
  res.text = '';
  res.setEncoding('utf8');
  res.on('data', function (chunk) {
    res.text += chunk;
  });
  res.on('end', function () {
    var body;
    var error;

    try {
      body = res.text && JSON.parse(res.text);
    } catch (error_) {
      error = error_; // issue #675: return the raw response if the response parsing fails

      error.rawResponse = res.text || null; // issue #876: return the http status code if the response parsing fails

      error.statusCode = res.statusCode;
    } finally {
      fn(error, body);
    }
  });
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9ub2RlL3BhcnNlcnMvanNvbi5qcyJdLCJuYW1lcyI6WyJtb2R1bGUiLCJleHBvcnRzIiwicmVzIiwiZm4iLCJ0ZXh0Iiwic2V0RW5jb2RpbmciLCJvbiIsImNodW5rIiwiYm9keSIsImVycm9yIiwiSlNPTiIsInBhcnNlIiwiZXJyb3JfIiwicmF3UmVzcG9uc2UiLCJzdGF0dXNDb2RlIl0sIm1hcHBpbmdzIjoiOztBQUFBQSxNQUFNLENBQUNDLE9BQVAsR0FBaUIsVUFBVUMsR0FBVixFQUFlQyxFQUFmLEVBQW1CO0FBQ2xDRCxFQUFBQSxHQUFHLENBQUNFLElBQUosR0FBVyxFQUFYO0FBQ0FGLEVBQUFBLEdBQUcsQ0FBQ0csV0FBSixDQUFnQixNQUFoQjtBQUNBSCxFQUFBQSxHQUFHLENBQUNJLEVBQUosQ0FBTyxNQUFQLEVBQWUsVUFBQ0MsS0FBRCxFQUFXO0FBQ3hCTCxJQUFBQSxHQUFHLENBQUNFLElBQUosSUFBWUcsS0FBWjtBQUNELEdBRkQ7QUFHQUwsRUFBQUEsR0FBRyxDQUFDSSxFQUFKLENBQU8sS0FBUCxFQUFjLFlBQU07QUFDbEIsUUFBSUUsSUFBSjtBQUNBLFFBQUlDLEtBQUo7O0FBQ0EsUUFBSTtBQUNGRCxNQUFBQSxJQUFJLEdBQUdOLEdBQUcsQ0FBQ0UsSUFBSixJQUFZTSxJQUFJLENBQUNDLEtBQUwsQ0FBV1QsR0FBRyxDQUFDRSxJQUFmLENBQW5CO0FBQ0QsS0FGRCxDQUVFLE9BQU9RLE1BQVAsRUFBZTtBQUNmSCxNQUFBQSxLQUFLLEdBQUdHLE1BQVIsQ0FEZSxDQUVmOztBQUNBSCxNQUFBQSxLQUFLLENBQUNJLFdBQU4sR0FBb0JYLEdBQUcsQ0FBQ0UsSUFBSixJQUFZLElBQWhDLENBSGUsQ0FJZjs7QUFDQUssTUFBQUEsS0FBSyxDQUFDSyxVQUFOLEdBQW1CWixHQUFHLENBQUNZLFVBQXZCO0FBQ0QsS0FSRCxTQVFVO0FBQ1JYLE1BQUFBLEVBQUUsQ0FBQ00sS0FBRCxFQUFRRCxJQUFSLENBQUY7QUFDRDtBQUNGLEdBZEQ7QUFlRCxDQXJCRCIsInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gZnVuY3Rpb24gKHJlcywgZm4pIHtcbiAgcmVzLnRleHQgPSAnJztcbiAgcmVzLnNldEVuY29kaW5nKCd1dGY4Jyk7XG4gIHJlcy5vbignZGF0YScsIChjaHVuaykgPT4ge1xuICAgIHJlcy50ZXh0ICs9IGNodW5rO1xuICB9KTtcbiAgcmVzLm9uKCdlbmQnLCAoKSA9PiB7XG4gICAgbGV0IGJvZHk7XG4gICAgbGV0IGVycm9yO1xuICAgIHRyeSB7XG4gICAgICBib2R5ID0gcmVzLnRleHQgJiYgSlNPTi5wYXJzZShyZXMudGV4dCk7XG4gICAgfSBjYXRjaCAoZXJyb3JfKSB7XG4gICAgICBlcnJvciA9IGVycm9yXztcbiAgICAgIC8vIGlzc3VlICM2NzU6IHJldHVybiB0aGUgcmF3IHJlc3BvbnNlIGlmIHRoZSByZXNwb25zZSBwYXJzaW5nIGZhaWxzXG4gICAgICBlcnJvci5yYXdSZXNwb25zZSA9IHJlcy50ZXh0IHx8IG51bGw7XG4gICAgICAvLyBpc3N1ZSAjODc2OiByZXR1cm4gdGhlIGh0dHAgc3RhdHVzIGNvZGUgaWYgdGhlIHJlc3BvbnNlIHBhcnNpbmcgZmFpbHNcbiAgICAgIGVycm9yLnN0YXR1c0NvZGUgPSByZXMuc3RhdHVzQ29kZTtcbiAgICB9IGZpbmFsbHkge1xuICAgICAgZm4oZXJyb3IsIGJvZHkpO1xuICAgIH1cbiAgfSk7XG59O1xuIl19