// Licensed Materials - Property of IBM
// (c) Copyright IBM Corporation 2018. All Rights Reserved.
// Note to U.S. Government Users Restricted Rights:
// Use, duplication or disclosure restricted by GSA ADP Schedule
// Contract with IBM Corp.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta1 "github.com/open-cluster-management/multicloud-operators-foundation/pkg/apis/mcm/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeClusterStatuses implements ClusterStatusInterface
type FakeClusterStatuses struct {
	Fake *FakeMcmV1beta1
	ns   string
}

var clusterstatusesResource = schema.GroupVersionResource{Group: "mcm.ibm.com", Version: "v1beta1", Resource: "clusterstatuses"}

var clusterstatusesKind = schema.GroupVersionKind{Group: "mcm.ibm.com", Version: "v1beta1", Kind: "ClusterStatus"}

// Get takes name of the clusterStatus, and returns the corresponding clusterStatus object, and an error if there is any.
func (c *FakeClusterStatuses) Get(name string, options v1.GetOptions) (result *v1beta1.ClusterStatus, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(clusterstatusesResource, c.ns, name), &v1beta1.ClusterStatus{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ClusterStatus), err
}

// List takes label and field selectors, and returns the list of ClusterStatuses that match those selectors.
func (c *FakeClusterStatuses) List(opts v1.ListOptions) (result *v1beta1.ClusterStatusList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(clusterstatusesResource, clusterstatusesKind, c.ns, opts), &v1beta1.ClusterStatusList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.ClusterStatusList{ListMeta: obj.(*v1beta1.ClusterStatusList).ListMeta}
	for _, item := range obj.(*v1beta1.ClusterStatusList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested clusterStatuses.
func (c *FakeClusterStatuses) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(clusterstatusesResource, c.ns, opts))

}

// Create takes the representation of a clusterStatus and creates it.  Returns the server's representation of the clusterStatus, and an error, if there is any.
func (c *FakeClusterStatuses) Create(clusterStatus *v1beta1.ClusterStatus) (result *v1beta1.ClusterStatus, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(clusterstatusesResource, c.ns, clusterStatus), &v1beta1.ClusterStatus{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ClusterStatus), err
}

// Update takes the representation of a clusterStatus and updates it. Returns the server's representation of the clusterStatus, and an error, if there is any.
func (c *FakeClusterStatuses) Update(clusterStatus *v1beta1.ClusterStatus) (result *v1beta1.ClusterStatus, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(clusterstatusesResource, c.ns, clusterStatus), &v1beta1.ClusterStatus{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ClusterStatus), err
}

// Delete takes name of the clusterStatus and deletes it. Returns an error if one occurs.
func (c *FakeClusterStatuses) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(clusterstatusesResource, c.ns, name), &v1beta1.ClusterStatus{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeClusterStatuses) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(clusterstatusesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1beta1.ClusterStatusList{})
	return err
}

// Patch applies the patch and returns the patched clusterStatus.
func (c *FakeClusterStatuses) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta1.ClusterStatus, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(clusterstatusesResource, c.ns, name, pt, data, subresources...), &v1beta1.ClusterStatus{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ClusterStatus), err
}
