---
title: Config Options for perl
sidebar_label: perl
---

| Option | Description | Values | Default |
| ------ | ----------- | ------ | ------- |
|ensureUniqueParams|Whether to ensure parameter names are unique in an operation (rename parameters that are not).| |true|
|hideGenerationTimestamp|Hides the generation timestamp when files are generated.| |true|
|moduleName|Perl module name (convention: CamelCase or Long::Module).| |OpenAPIClient|
|moduleVersion|Perl module version.| |1.0.0|
|prependFormOrBodyParameters|Add form or body parameters to the beginning of the parameter list.| |false|
|sortParamsByRequiredFlag|Sort method arguments to place required parameters before optional parameters.| |true|

## IMPORT MAPPING

| Type/Alias | Imports |
| ---------- | ------- |


## INSTANTIATION TYPES

| Type/Alias | Instantiated By |
| ---------- | --------------- |


## LANGUAGE PRIMITIVES

<ul data-columns="2" style="list-style-type: disc;-webkit-columns:2;-moz-columns:2;columns:2;-moz-column-fill:auto;column-fill:auto"><li>ARRAY</li>
<li>DateTime</li>
<li>HASH</li>
<li>boolean</li>
<li>double</li>
<li>int</li>
<li>object</li>
<li>string</li>
</ul>

## RESERVED WORDS

<ul data-columns="2" style="list-style-type: disc;-webkit-columns:2;-moz-columns:2;columns:2;-moz-column-fill:auto;column-fill:auto"><li>__end__</li>
<li>__file__</li>
<li>__line__</li>
<li>__package__</li>
<li>and</li>
<li>cmp</li>
<li>continue</li>
<li>core</li>
<li>do</li>
<li>else</li>
<li>elsif</li>
<li>eq</li>
<li>exp</li>
<li>for</li>
<li>foreach</li>
<li>ge</li>
<li>gt</li>
<li>if</li>
<li>le</li>
<li>lock</li>
<li>lt</li>
<li>m</li>
<li>ne</li>
<li>no</li>
<li>or</li>
<li>package</li>
<li>q</li>
<li>qq</li>
<li>qr</li>
<li>qw</li>
<li>qx</li>
<li>return</li>
<li>s</li>
<li>sub</li>
<li>tr</li>
<li>unless</li>
<li>until</li>
<li>while</li>
<li>xor</li>
<li>y</li>
</ul>
