---
title: Config Options for powershell
sidebar_label: powershell
---

| Option | Description | Values | Default |
| ------ | ----------- | ------ | ------- |
|csharpClientPath|Path to the C# API client generated by OpenAPI Generator, e.g. $ScriptDir\..\csharp\OpenAPIClient where $ScriptDir is the current directory. NOTE: you will need to generate the C# API client separately.| |$ScriptDir\csharp\OpenAPIClient|
|packageGuid|GUID for PowerShell module (e.g. a27b908d-2a20-467f-bc32-af6f3a654ac5). A random GUID will be generated by default.| |null|
|packageName|Client package name (e.g. org.openapitools.client).| |Org.OpenAPITools|

## IMPORT MAPPING

| Type/Alias | Imports |
| ---------- | ------- |
|Array|java.util.List|
|ArrayList|java.util.ArrayList|
|BigDecimal|java.math.BigDecimal|
|Date|java.util.Date|
|DateTime|org.joda.time.*|
|File|java.io.File|
|HashMap|java.util.HashMap|
|List|java.util.*|
|LocalDate|org.joda.time.*|
|LocalDateTime|org.joda.time.*|
|LocalTime|org.joda.time.*|
|Map|java.util.Map|
|Set|java.util.*|
|Timestamp|java.sql.Timestamp|
|URI|java.net.URI|
|UUID|java.util.UUID|


## INSTANTIATION TYPES

| Type/Alias | Instantiated By |
| ---------- | --------------- |


## LANGUAGE PRIMITIVES

<ul data-columns="2" style="list-style-type: disc;-webkit-columns:2;-moz-columns:2;columns:2;-moz-column-fill:auto;column-fill:auto"><li>Boolean</li>
<li>Byte</li>
<li>Byte[]</li>
<li>Char</li>
<li>Decimal</li>
<li>Double</li>
<li>Guid</li>
<li>Int16</li>
<li>Int32</li>
<li>Int64</li>
<li>ProgressRecord</li>
<li>SByte</li>
<li>SecureString</li>
<li>Single</li>
<li>String</li>
<li>System.DateTime</li>
<li>TimeSpan</li>
<li>UInt16</li>
<li>UInt32</li>
<li>UInt64</li>
<li>Uri</li>
<li>Version</li>
<li>XmlDocument</li>
</ul>

## RESERVED WORDS

<ul data-columns="2" style="list-style-type: disc;-webkit-columns:2;-moz-columns:2;columns:2;-moz-column-fill:auto;column-fill:auto"><li>Begin</li>
<li>Break</li>
<li>Catch</li>
<li>Continue</li>
<li>Data</li>
<li>Do</li>
<li>Dynamicparam</li>
<li>Else</li>
<li>Elseif</li>
<li>End</li>
<li>Exit</li>
<li>Filter</li>
<li>Finally</li>
<li>For</li>
<li>Foreach</li>
<li>From</li>
<li>Function</li>
<li>If</li>
<li>In</li>
<li>Local</li>
<li>Param</li>
<li>Private</li>
<li>Process</li>
<li>Return</li>
<li>Switch</li>
<li>Throw</li>
<li>Trap</li>
<li>Try</li>
<li>Until</li>
<li>Where</li>
<li>While</li>
</ul>
