---
title: Config Options for scala-finch
sidebar_label: scala-finch
---

| Option | Description | Values | Default |
| ------ | ----------- | ------ | ------- |
|apiPackage|package for generated api classes| |null|
|modelPackage|package for generated models| |null|
|packageName|Finch package name (e.g. org.openapitools).| |org.openapitools|

## IMPORT MAPPING

| Type/Alias | Imports |
| ---------- | ------- |
|ArrayBuffer|scala.collection.mutable.ArrayBuffer|
|BigDecimal|java.math.BigDecimal|
|Date|java.util.Date|
|DateTime|java.time.LocalDateTime|
|File|java.io.File|
|HashMap|scala.collection.immutable.HashMap|
|LocalDate|java.time.LocalDate|
|LocalDateTime|java.time.LocalDateTime|
|LocalTime|java.time.LocalTime|
|Map|scala.collection.immutable.Map|
|Seq|scala.collection.immutable.Seq|
|Timestamp|java.sql.Timestamp|
|URI|java.net.URI|
|UUID|java.util.UUID|
|ZonedDateTime|java.time.ZonedDateTime|


## INSTANTIATION TYPES

| Type/Alias | Instantiated By |
| ---------- | --------------- |
|array|ArrayList|
|map|HashMap|


## LANGUAGE PRIMITIVES

<ul data-columns="2" style="list-style-type: disc;-webkit-columns:2;-moz-columns:2;columns:2;-moz-column-fill:auto;column-fill:auto"><li>Any</li>
<li>AnyRef</li>
<li>AnyVal</li>
<li>Boolean</li>
<li>Double</li>
<li>Float</li>
<li>Int</li>
<li>Integer</li>
<li>Long</li>
<li>Object</li>
<li>String</li>
</ul>

## RESERVED WORDS

<ul data-columns="2" style="list-style-type: disc;-webkit-columns:2;-moz-columns:2;columns:2;-moz-column-fill:auto;column-fill:auto"><li>abstract</li>
<li>assert</li>
<li>break</li>
<li>byte</li>
<li>case</li>
<li>catch</li>
<li>char</li>
<li>class</li>
<li>const</li>
<li>continue</li>
<li>def</li>
<li>default</li>
<li>do</li>
<li>double</li>
<li>else</li>
<li>enum</li>
<li>extends</li>
<li>false</li>
<li>final</li>
<li>finally</li>
<li>float</li>
<li>for</li>
<li>forsome</li>
<li>goto</li>
<li>if</li>
<li>implements</li>
<li>implicit</li>
<li>import</li>
<li>instanceof</li>
<li>int</li>
<li>interface</li>
<li>lazy</li>
<li>long</li>
<li>match</li>
<li>native</li>
<li>new</li>
<li>null</li>
<li>object</li>
<li>override</li>
<li>package</li>
<li>private</li>
<li>protected</li>
<li>public</li>
<li>return</li>
<li>sealed</li>
<li>short</li>
<li>static</li>
<li>strictfp</li>
<li>super</li>
<li>switch</li>
<li>synchronized</li>
<li>this</li>
<li>throw</li>
<li>throws</li>
<li>trait</li>
<li>transient</li>
<li>true</li>
<li>try</li>
<li>type</li>
<li>val</li>
<li>var</li>
<li>void</li>
<li>volatile</li>
<li>while</li>
<li>with</li>
<li>yield</li>
</ul>
