# OpenAPI Petstore
#
# This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#
# The version of the OpenAPI document: 1.0.0
# 
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Pet
#' @description Pet Class
#' @format An \code{R6Class} generator object
#' @field id  integer [optional]
#'
#' @field category  \link{Category} [optional]
#'
#' @field name  character 
#'
#' @field photoUrls  list( character ) 
#'
#' @field tags  list( \link{Tag} ) [optional]
#'
#' @field status  character [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
Pet <- R6::R6Class(
  'Pet',
  public = list(
    `id` = NULL,
    `category` = NULL,
    `name` = NULL,
    `photoUrls` = NULL,
    `tags` = NULL,
    `status` = NULL,
    initialize = function(`name`, `photoUrls`, `id`=NULL, `category`=NULL, `tags`=NULL, `status`=NULL, ...){
      local.optional.var <- list(...)
      if (!missing(`name`)) {
        stopifnot(is.character(`name`), length(`name`) == 1)
        self$`name` <- `name`
      }
      if (!missing(`photoUrls`)) {
        stopifnot(is.vector(`photoUrls`), length(`photoUrls`) != 0)
        sapply(`photoUrls`, function(x) stopifnot(is.character(x)))
        self$`photoUrls` <- `photoUrls`
      }
      if (!is.null(`id`)) {
        stopifnot(is.numeric(`id`), length(`id`) == 1)
        self$`id` <- `id`
      }
      if (!is.null(`category`)) {
        stopifnot(R6::is.R6(`category`))
        self$`category` <- `category`
      }
      if (!is.null(`tags`)) {
        stopifnot(is.vector(`tags`), length(`tags`) != 0)
        sapply(`tags`, function(x) stopifnot(R6::is.R6(x)))
        self$`tags` <- `tags`
      }
      if (!is.null(`status`)) {
        stopifnot(is.character(`status`), length(`status`) == 1)
        self$`status` <- `status`
      }
    },
    toJSON = function() {
      PetObject <- list()
      if (!is.null(self$`id`)) {
        PetObject[['id']] <-
          self$`id`
      }
      if (!is.null(self$`category`)) {
        PetObject[['category']] <-
          self$`category`$toJSON()
      }
      if (!is.null(self$`name`)) {
        PetObject[['name']] <-
          self$`name`
      }
      if (!is.null(self$`photoUrls`)) {
        PetObject[['photoUrls']] <-
          self$`photoUrls`
      }
      if (!is.null(self$`tags`)) {
        PetObject[['tags']] <-
          lapply(self$`tags`, function(x) x$toJSON())
      }
      if (!is.null(self$`status`)) {
        PetObject[['status']] <-
          self$`status`
      }

      PetObject
    },
    fromJSON = function(PetJson) {
      PetObject <- jsonlite::fromJSON(PetJson)
      if (!is.null(PetObject$`id`)) {
        self$`id` <- PetObject$`id`
      }
      if (!is.null(PetObject$`category`)) {
        categoryObject <- Category$new()
        categoryObject$fromJSON(jsonlite::toJSON(PetObject$category, auto_unbox = TRUE, digits = NA))
        self$`category` <- categoryObject
      }
      if (!is.null(PetObject$`name`)) {
        self$`name` <- PetObject$`name`
      }
      if (!is.null(PetObject$`photoUrls`)) {
        self$`photoUrls` <- ApiClient$new()$deserializeObj(PetObject$`photoUrls`, "array[character]", loadNamespace("petstore"))
      }
      if (!is.null(PetObject$`tags`)) {
        self$`tags` <- ApiClient$new()$deserializeObj(PetObject$`tags`, "array[Tag]", loadNamespace("petstore"))
      }
      if (!is.null(PetObject$`status`)) {
        self$`status` <- PetObject$`status`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`id`)) {
        sprintf(
        '"id":
          %d
                ',
        self$`id`
        )},
        if (!is.null(self$`category`)) {
        sprintf(
        '"category":
        %s
        ',
        jsonlite::toJSON(self$`category`$toJSON(), auto_unbox=TRUE, digits = NA)
        )},
        if (!is.null(self$`name`)) {
        sprintf(
        '"name":
          "%s"
                ',
        self$`name`
        )},
        if (!is.null(self$`photoUrls`)) {
        sprintf(
        '"photoUrls":
           [%s]
        ',
        paste(unlist(lapply(self$`photoUrls`, function(x) paste0('"', x, '"'))), collapse=",")
        )},
        if (!is.null(self$`tags`)) {
        sprintf(
        '"tags":
        [%s]
',
        paste(sapply(self$`tags`, function(x) jsonlite::toJSON(x$toJSON(), auto_unbox=TRUE, digits = NA)), collapse=",")
        )},
        if (!is.null(self$`status`)) {
        sprintf(
        '"status":
          "%s"
                ',
        self$`status`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(PetJson) {
      PetObject <- jsonlite::fromJSON(PetJson)
      self$`id` <- PetObject$`id`
      self$`category` <- Category$new()$fromJSON(jsonlite::toJSON(PetObject$category, auto_unbox = TRUE, digits = NA))
      self$`name` <- PetObject$`name`
      self$`photoUrls` <- ApiClient$new()$deserializeObj(PetObject$`photoUrls`, "array[character]", loadNamespace("petstore"))
      self$`tags` <- ApiClient$new()$deserializeObj(PetObject$`tags`, "array[Tag]", loadNamespace("petstore"))
      self$`status` <- PetObject$`status`
      self
    }
  )
)
