# OpenAPI Petstore
#
# This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#
# The version of the OpenAPI document: 1.0.0
# 
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Pet operations
#' @description petstore.Pet
#' @format An \code{R6Class} generator object
#' @field apiClient Handles the client-server communication.
#'
#' @section Methods:
#' \describe{
#' \strong{ AddPet } \emph{ Add a new pet to the store }
#' 
#'
#' \itemize{
#' \item \emph{ @param } body \link{Pet}
#'
#'
#' \item status code : 405 | Invalid input
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ DeletePet } \emph{ Deletes a pet }
#' 
#'
#' \itemize{
#' \item \emph{ @param } pet.id integer
#' \item \emph{ @param } api.key character
#'
#'
#' \item status code : 400 | Invalid pet value
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ FindPetsByStatus } \emph{ Finds Pets by status }
#' Multiple status values can be provided with comma separated strings
#'
#' \itemize{
#' \item \emph{ @param } status Enum < [available, pending, sold] > 
#' \item \emph{ @returnType } list( \link{Pet} ) \cr
#'
#'
#' \item status code : 200 | successful operation
#'
#' \item return type : array[Pet] 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 400 | Invalid status value
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ FindPetsByTags } \emph{ Finds Pets by tags }
#' Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
#'
#' \itemize{
#' \item \emph{ @param } tags list( character )
#' \item \emph{ @returnType } list( \link{Pet} ) \cr
#'
#'
#' \item status code : 200 | successful operation
#'
#' \item return type : array[Pet] 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 400 | Invalid tag value
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ GetPetById } \emph{ Find pet by ID }
#' Returns a single pet
#'
#' \itemize{
#' \item \emph{ @param } pet.id integer
#' \item \emph{ @returnType } \link{Pet} \cr
#'
#'
#' \item status code : 200 | successful operation
#'
#' \item return type : Pet 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 400 | Invalid ID supplied
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 404 | Pet not found
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ UpdatePet } \emph{ Update an existing pet }
#' 
#'
#' \itemize{
#' \item \emph{ @param } body \link{Pet}
#'
#'
#' \item status code : 400 | Invalid ID supplied
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 404 | Pet not found
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 405 | Validation exception
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ UpdatePetWithForm } \emph{ Updates a pet in the store with form data }
#' 
#'
#' \itemize{
#' \item \emph{ @param } pet.id integer
#' \item \emph{ @param } name character
#' \item \emph{ @param } status character
#'
#'
#' \item status code : 405 | Invalid input
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ UploadFile } \emph{ uploads an image }
#' 
#'
#' \itemize{
#' \item \emph{ @param } pet.id integer
#' \item \emph{ @param } additional.metadata character
#' \item \emph{ @param } file data.frame
#' \item \emph{ @returnType } \link{ModelApiResponse} \cr
#'
#'
#' \item status code : 200 | successful operation
#'
#' \item return type : ModelApiResponse 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' }
#'
#'
#' @examples
#' \donttest{
#' ####################  AddPet  ####################
#'
#' library(petstore)
#' var.body <- Pet$new() # Pet | Pet object that needs to be added to the store
#'
#' #Add a new pet to the store
#' api.instance <- PetApi$new()
#'
#' # Configure OAuth2 access token for authorization: petstore_auth
#' api.instance$apiClient$accessToken <- 'TODO_YOUR_ACCESS_TOKEN';
#'
#' result <- api.instance$AddPet(var.body)
#'
#'
#' ####################  DeletePet  ####################
#'
#' library(petstore)
#' var.pet.id <- 56 # integer | Pet id to delete
#' var.api.key <- 'api.key_example' # character | 
#'
#' #Deletes a pet
#' api.instance <- PetApi$new()
#'
#' # Configure OAuth2 access token for authorization: petstore_auth
#' api.instance$apiClient$accessToken <- 'TODO_YOUR_ACCESS_TOKEN';
#'
#' result <- api.instance$DeletePet(var.pet.id, api.key=var.api.key)
#'
#'
#' ####################  FindPetsByStatus  ####################
#'
#' library(petstore)
#' var.status <- ['status_example'] # array[character] | Status values that need to be considered for filter
#'
#' #Finds Pets by status
#' api.instance <- PetApi$new()
#'
#' # Configure OAuth2 access token for authorization: petstore_auth
#' api.instance$apiClient$accessToken <- 'TODO_YOUR_ACCESS_TOKEN';
#'
#' result <- api.instance$FindPetsByStatus(var.status)
#'
#'
#' ####################  FindPetsByTags  ####################
#'
#' library(petstore)
#' var.tags <- ['tags_example'] # array[character] | Tags to filter by
#'
#' #Finds Pets by tags
#' api.instance <- PetApi$new()
#'
#' # Configure OAuth2 access token for authorization: petstore_auth
#' api.instance$apiClient$accessToken <- 'TODO_YOUR_ACCESS_TOKEN';
#'
#' result <- api.instance$FindPetsByTags(var.tags)
#'
#'
#' ####################  GetPetById  ####################
#'
#' library(petstore)
#' var.pet.id <- 56 # integer | ID of pet to return
#'
#' #Find pet by ID
#' api.instance <- PetApi$new()
#'
#' #Configure API key authorization: api_key
#' api.instance$apiClient$apiKeys['api_key'] <- 'TODO_YOUR_API_KEY';
#'
#' result <- api.instance$GetPetById(var.pet.id)
#'
#'
#' ####################  UpdatePet  ####################
#'
#' library(petstore)
#' var.body <- Pet$new() # Pet | Pet object that needs to be added to the store
#'
#' #Update an existing pet
#' api.instance <- PetApi$new()
#'
#' # Configure OAuth2 access token for authorization: petstore_auth
#' api.instance$apiClient$accessToken <- 'TODO_YOUR_ACCESS_TOKEN';
#'
#' result <- api.instance$UpdatePet(var.body)
#'
#'
#' ####################  UpdatePetWithForm  ####################
#'
#' library(petstore)
#' var.pet.id <- 56 # integer | ID of pet that needs to be updated
#' var.name <- 'name_example' # character | Updated name of the pet
#' var.status <- 'status_example' # character | Updated status of the pet
#'
#' #Updates a pet in the store with form data
#' api.instance <- PetApi$new()
#'
#' # Configure OAuth2 access token for authorization: petstore_auth
#' api.instance$apiClient$accessToken <- 'TODO_YOUR_ACCESS_TOKEN';
#'
#' result <- api.instance$UpdatePetWithForm(var.pet.id, name=var.name, status=var.status)
#'
#'
#' ####################  UploadFile  ####################
#'
#' library(petstore)
#' var.pet.id <- 56 # integer | ID of pet to update
#' var.additional.metadata <- 'additional.metadata_example' # character | Additional data to pass to server
#' var.file <- File.new('/path/to/file') # data.frame | file to upload
#'
#' #uploads an image
#' api.instance <- PetApi$new()
#'
#' # Configure OAuth2 access token for authorization: petstore_auth
#' api.instance$apiClient$accessToken <- 'TODO_YOUR_ACCESS_TOKEN';
#'
#' result <- api.instance$UploadFile(var.pet.id, additional.metadata=var.additional.metadata, file=var.file)
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom caTools base64encode
#' @export
PetApi <- R6::R6Class(
  'PetApi',
  public = list(
    apiClient = NULL,
    initialize = function(apiClient){
      if (!missing(apiClient)) {
        self$apiClient <- apiClient
      }
      else {
        self$apiClient <- ApiClient$new()
      }
    },
    AddPet = function(body, ...){
      apiResponse <- self$AddPetWithHttpInfo(body, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    AddPetWithHttpInfo = function(body, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`body`)) {
        stop("Missing required parameter `body`.")
      }

      if (!missing(`body`)) {
        body <- `body`$toJSONString()
      } else {
        body <- NULL
      }

      urlPath <- "/pet"
      # OAuth token
      headerParams['Authorization'] <- paste("Bearer", self$apiClient$accessToken, sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "POST",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    DeletePet = function(pet.id, api.key=NULL, ...){
      apiResponse <- self$DeletePetWithHttpInfo(pet.id, api.key, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    DeletePetWithHttpInfo = function(pet.id, api.key=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`pet.id`)) {
        stop("Missing required parameter `pet.id`.")
      }

      headerParams['api_key'] <- `api.key`

      urlPath <- "/pet/{petId}"
      if (!missing(`pet.id`)) {
        urlPath <- gsub(paste0("\\{", "petId", "\\}"), URLencode(as.character(`pet.id`), reserved = TRUE), urlPath)
      }

      # OAuth token
      headerParams['Authorization'] <- paste("Bearer", self$apiClient$accessToken, sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "DELETE",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    FindPetsByStatus = function(status, ...){
      apiResponse <- self$FindPetsByStatusWithHttpInfo(status, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    FindPetsByStatusWithHttpInfo = function(status, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`status`)) {
        stop("Missing required parameter `status`.")
      }

      queryParams['status'] <- status

      urlPath <- "/pet/findByStatus"
      # OAuth token
      headerParams['Authorization'] <- paste("Bearer", self$apiClient$accessToken, sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "array[Pet]", loadNamespace("petstore")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    FindPetsByTags = function(tags, ...){
      apiResponse <- self$FindPetsByTagsWithHttpInfo(tags, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    FindPetsByTagsWithHttpInfo = function(tags, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`tags`)) {
        stop("Missing required parameter `tags`.")
      }

      queryParams['tags'] <- tags

      urlPath <- "/pet/findByTags"
      # OAuth token
      headerParams['Authorization'] <- paste("Bearer", self$apiClient$accessToken, sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "array[Pet]", loadNamespace("petstore")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    GetPetById = function(pet.id, ...){
      apiResponse <- self$GetPetByIdWithHttpInfo(pet.id, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetPetByIdWithHttpInfo = function(pet.id, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`pet.id`)) {
        stop("Missing required parameter `pet.id`.")
      }

      urlPath <- "/pet/{petId}"
      if (!missing(`pet.id`)) {
        urlPath <- gsub(paste0("\\{", "petId", "\\}"), URLencode(as.character(`pet.id`), reserved = TRUE), urlPath)
      }

      # API key authentication
      if ("api_key" %in% names(self$apiClient$apiKeys) && nchar(self$apiClient$apiKeys["api_key"]) > 0) {
        headerParams['api_key'] <- paste(unlist(self$apiClient$apiKeys["api_key"]), collapse='')
      }

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "Pet", loadNamespace("petstore")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    UpdatePet = function(body, ...){
      apiResponse <- self$UpdatePetWithHttpInfo(body, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    UpdatePetWithHttpInfo = function(body, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`body`)) {
        stop("Missing required parameter `body`.")
      }

      if (!missing(`body`)) {
        body <- `body`$toJSONString()
      } else {
        body <- NULL
      }

      urlPath <- "/pet"
      # OAuth token
      headerParams['Authorization'] <- paste("Bearer", self$apiClient$accessToken, sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "PUT",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    UpdatePetWithForm = function(pet.id, name=NULL, status=NULL, ...){
      apiResponse <- self$UpdatePetWithFormWithHttpInfo(pet.id, name, status, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    UpdatePetWithFormWithHttpInfo = function(pet.id, name=NULL, status=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`pet.id`)) {
        stop("Missing required parameter `pet.id`.")
      }

      body <- list(
        "name" = name,
        "status" = status
      )

      urlPath <- "/pet/{petId}"
      if (!missing(`pet.id`)) {
        urlPath <- gsub(paste0("\\{", "petId", "\\}"), URLencode(as.character(`pet.id`), reserved = TRUE), urlPath)
      }

      # OAuth token
      headerParams['Authorization'] <- paste("Bearer", self$apiClient$accessToken, sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "POST",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    UploadFile = function(pet.id, additional.metadata=NULL, file=NULL, ...){
      apiResponse <- self$UploadFileWithHttpInfo(pet.id, additional.metadata, file, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    UploadFileWithHttpInfo = function(pet.id, additional.metadata=NULL, file=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`pet.id`)) {
        stop("Missing required parameter `pet.id`.")
      }

      body <- list(
        "additionalMetadata" = additional.metadata,
        "file" = httr::upload_file(file)
      )

      urlPath <- "/pet/{petId}/uploadImage"
      if (!missing(`pet.id`)) {
        urlPath <- gsub(paste0("\\{", "petId", "\\}"), URLencode(as.character(`pet.id`), reserved = TRUE), urlPath)
      }

      # OAuth token
      headerParams['Authorization'] <- paste("Bearer", self$apiClient$accessToken, sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "POST",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "ModelApiResponse", loadNamespace("petstore")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    }
  )
)
