# OpenAPI Petstore
#
# This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#
# The version of the OpenAPI document: 1.0.0
# 
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title User operations
#' @description petstore.User
#' @format An \code{R6Class} generator object
#' @field apiClient Handles the client-server communication.
#'
#' @section Methods:
#' \describe{
#' \strong{ CreateUser } \emph{ Create user }
#' This can only be done by the logged in user.
#'
#' \itemize{
#' \item \emph{ @param } body \link{User}
#'
#'
#' \item status code : 0 | successful operation
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ CreateUsersWithArrayInput } \emph{ Creates list of users with given input array }
#' 
#'
#' \itemize{
#' \item \emph{ @param } body list( \link{User} )
#'
#'
#' \item status code : 0 | successful operation
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ CreateUsersWithListInput } \emph{ Creates list of users with given input array }
#' 
#'
#' \itemize{
#' \item \emph{ @param } body list( \link{User} )
#'
#'
#' \item status code : 0 | successful operation
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ DeleteUser } \emph{ Delete user }
#' This can only be done by the logged in user.
#'
#' \itemize{
#' \item \emph{ @param } username character
#'
#'
#' \item status code : 400 | Invalid username supplied
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 404 | User not found
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ GetUserByName } \emph{ Get user by user name }
#' 
#'
#' \itemize{
#' \item \emph{ @param } username character
#' \item \emph{ @returnType } \link{User} \cr
#'
#'
#' \item status code : 200 | successful operation
#'
#' \item return type : User 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 400 | Invalid username supplied
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 404 | User not found
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ LoginUser } \emph{ Logs user into the system }
#' 
#'
#' \itemize{
#' \item \emph{ @param } username character
#' \item \emph{ @param } password character
#'
#'
#' \item status code : 200 | successful operation
#'
#' \item return type : character 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-Rate-Limit \tab calls per hour allowed by the user \cr
#' X-Expires-After \tab date in UTC when toekn expires \cr
#' }
#' \item status code : 400 | Invalid username/password supplied
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ LogoutUser } \emph{ Logs out current logged in user session }
#' 
#'
#' \itemize{
#'
#'
#' \item status code : 0 | successful operation
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' \strong{ UpdateUser } \emph{ Updated user }
#' This can only be done by the logged in user.
#'
#' \itemize{
#' \item \emph{ @param } username character
#' \item \emph{ @param } body \link{User}
#'
#'
#' \item status code : 400 | Invalid user supplied
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 404 | User not found
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' }
#'
#'
#' @examples
#' \donttest{
#' ####################  CreateUser  ####################
#'
#' library(petstore)
#' var.body <- User$new() # User | Created user object
#'
#' #Create user
#' api.instance <- UserApi$new()
#'
#' result <- api.instance$CreateUser(var.body)
#'
#'
#' ####################  CreateUsersWithArrayInput  ####################
#'
#' library(petstore)
#' var.body <- [User$new()] # array[User] | List of user object
#'
#' #Creates list of users with given input array
#' api.instance <- UserApi$new()
#'
#' result <- api.instance$CreateUsersWithArrayInput(var.body)
#'
#'
#' ####################  CreateUsersWithListInput  ####################
#'
#' library(petstore)
#' var.body <- [User$new()] # array[User] | List of user object
#'
#' #Creates list of users with given input array
#' api.instance <- UserApi$new()
#'
#' result <- api.instance$CreateUsersWithListInput(var.body)
#'
#'
#' ####################  DeleteUser  ####################
#'
#' library(petstore)
#' var.username <- 'username_example' # character | The name that needs to be deleted
#'
#' #Delete user
#' api.instance <- UserApi$new()
#'
#' result <- api.instance$DeleteUser(var.username)
#'
#'
#' ####################  GetUserByName  ####################
#'
#' library(petstore)
#' var.username <- 'username_example' # character | The name that needs to be fetched. Use user1 for testing.
#'
#' #Get user by user name
#' api.instance <- UserApi$new()
#'
#' result <- api.instance$GetUserByName(var.username)
#'
#'
#' ####################  LoginUser  ####################
#'
#' library(petstore)
#' var.username <- 'username_example' # character | The user name for login
#' var.password <- 'password_example' # character | The password for login in clear text
#'
#' #Logs user into the system
#' api.instance <- UserApi$new()
#'
#' result <- api.instance$LoginUser(var.username, var.password)
#'
#'
#' ####################  LogoutUser  ####################
#'
#' library(petstore)
#'
#' #Logs out current logged in user session
#' api.instance <- UserApi$new()
#'
#' result <- api.instance$LogoutUser()
#'
#'
#' ####################  UpdateUser  ####################
#'
#' library(petstore)
#' var.username <- 'username_example' # character | name that need to be deleted
#' var.body <- User$new() # User | Updated user object
#'
#' #Updated user
#' api.instance <- UserApi$new()
#'
#' result <- api.instance$UpdateUser(var.username, var.body)
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom caTools base64encode
#' @export
UserApi <- R6::R6Class(
  'UserApi',
  public = list(
    apiClient = NULL,
    initialize = function(apiClient){
      if (!missing(apiClient)) {
        self$apiClient <- apiClient
      }
      else {
        self$apiClient <- ApiClient$new()
      }
    },
    CreateUser = function(body, ...){
      apiResponse <- self$CreateUserWithHttpInfo(body, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    CreateUserWithHttpInfo = function(body, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`body`)) {
        stop("Missing required parameter `body`.")
      }

      if (!missing(`body`)) {
        body <- `body`$toJSONString()
      } else {
        body <- NULL
      }

      urlPath <- "/user"

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "POST",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    CreateUsersWithArrayInput = function(body, ...){
      apiResponse <- self$CreateUsersWithArrayInputWithHttpInfo(body, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    CreateUsersWithArrayInputWithHttpInfo = function(body, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`body`)) {
        stop("Missing required parameter `body`.")
      }

      if (!missing(`body`)) {
        body.items = paste(unlist(lapply(body, function(param){param$toJSONString()})), collapse = ",")
        body <- paste0('[', body.items, ']')
      } else {
        body <- NULL
      }

      urlPath <- "/user/createWithArray"

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "POST",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    CreateUsersWithListInput = function(body, ...){
      apiResponse <- self$CreateUsersWithListInputWithHttpInfo(body, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    CreateUsersWithListInputWithHttpInfo = function(body, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`body`)) {
        stop("Missing required parameter `body`.")
      }

      if (!missing(`body`)) {
        body.items = paste(unlist(lapply(body, function(param){param$toJSONString()})), collapse = ",")
        body <- paste0('[', body.items, ']')
      } else {
        body <- NULL
      }

      urlPath <- "/user/createWithList"

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "POST",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    DeleteUser = function(username, ...){
      apiResponse <- self$DeleteUserWithHttpInfo(username, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    DeleteUserWithHttpInfo = function(username, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`username`)) {
        stop("Missing required parameter `username`.")
      }

      urlPath <- "/user/{username}"
      if (!missing(`username`)) {
        urlPath <- gsub(paste0("\\{", "username", "\\}"), URLencode(as.character(`username`), reserved = TRUE), urlPath)
      }


      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "DELETE",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    GetUserByName = function(username, ...){
      apiResponse <- self$GetUserByNameWithHttpInfo(username, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetUserByNameWithHttpInfo = function(username, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`username`)) {
        stop("Missing required parameter `username`.")
      }

      urlPath <- "/user/{username}"
      if (!missing(`username`)) {
        urlPath <- gsub(paste0("\\{", "username", "\\}"), URLencode(as.character(`username`), reserved = TRUE), urlPath)
      }


      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "User", loadNamespace("petstore")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    LoginUser = function(username, password, ...){
      apiResponse <- self$LoginUserWithHttpInfo(username, password, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    LoginUserWithHttpInfo = function(username, password, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`username`)) {
        stop("Missing required parameter `username`.")
      }

      if (missing(`password`)) {
        stop("Missing required parameter `password`.")
      }

      queryParams['username'] <- username

      queryParams['password'] <- password

      urlPath <- "/user/login"

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "character", loadNamespace("petstore")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    LogoutUser = function(...){
      apiResponse <- self$LogoutUserWithHttpInfo(...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    LogoutUserWithHttpInfo = function(...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      urlPath <- "/user/logout"

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    },
    UpdateUser = function(username, body, ...){
      apiResponse <- self$UpdateUserWithHttpInfo(username, body, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    UpdateUserWithHttpInfo = function(username, body, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`username`)) {
        stop("Missing required parameter `username`.")
      }

      if (missing(`body`)) {
        stop("Missing required parameter `body`.")
      }

      if (!missing(`body`)) {
        body <- `body`$toJSONString()
      } else {
        body <- NULL
      }

      urlPath <- "/user/{username}"
      if (!missing(`username`)) {
        urlPath <- gsub(paste0("\\{", "username", "\\}"), URLencode(as.character(`username`), reserved = TRUE), urlPath)
      }


      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "PUT",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    }
  )
)
