/*
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the OAS code generator program.
 * https://github.com/OpenAPITools/openapi-generator
 * Do not edit the class manually.
 */

/**
 * An order for a pets from the pet store
 */
public class OASOrder {
    /**
     * Get id
     * @return id
     */
    public Long id { get; set; }

    /**
     * Get petId
     * @return petId
     */
    public Long petId { get; set; }

    /**
     * Get quantity
     * @return quantity
     */
    public Integer quantity { get; set; }

    /**
     * Get shipDate
     * @return shipDate
     */
    public Datetime shipDate { get; set; }

    /**
     * Order Status
     */
    public enum StatusEnum {
        PLACED,
        APPROVED,
        DELIVERED
    }

    /**
     * Order Status
     * @return status
     */
    public StatusEnum status { get; set; }

    /**
     * Get complete
     * @return complete
     */
    public Boolean complete { get; set; }

    public OASOrder() {
        complete = false;
    }

    public static OASOrder getExample() {
        OASOrder order = new OASOrder();
          order.id = 123456789L;
          order.petId = 123456789L;
          order.quantity = 0;
          order.shipDate = Datetime.newInstanceGmt(2000, 1, 23, 4, 56, 7);
          order.status = StatusEnum.PLACED;
          order.complete = true;
        return order;
    }

    public Boolean equals(Object obj) {
        if (obj instanceof OASOrder) {           
            OASOrder order = (OASOrder) obj;
            return this.id == order.id
                && this.petId == order.petId
                && this.quantity == order.quantity
                && this.shipDate == order.shipDate
                && this.status == order.status
                && this.complete == order.complete;
        }
        return false;
    }

    public Integer hashCode() {
        Integer hashCode = 43;
        hashCode = (17 * hashCode) + (id == null ? 0 : System.hashCode(id));
        hashCode = (17 * hashCode) + (petId == null ? 0 : System.hashCode(petId));
        hashCode = (17 * hashCode) + (quantity == null ? 0 : System.hashCode(quantity));
        hashCode = (17 * hashCode) + (shipDate == null ? 0 : System.hashCode(shipDate));
        hashCode = (17 * hashCode) + (status == null ? 0 : System.hashCode(status));
        hashCode = (17 * hashCode) + (complete == null ? 0 : System.hashCode(complete));
        return hashCode;
    }
}

