# openapi
This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

This Dart package is automatically generated by the [Open API Codegen](https://github.com/OpenAPITools/openapi-generator) project:

- API version: 1.0.0
- Build package: org.openapitools.codegen.languages.DartJaguarClientCodegen

## Requirements

Dart 2 or later OR Flutter 0.7.0 or later.

Once your code is generated, you need to run the build_runner command to let Jaguar implement your API:

```sh
flutter packages pub run build_runner build
or
pub run build_runner build
```

## Installation & Usage

### Github
If this Dart package is published to Github, please include the following in pubspec.yaml
```
name: openapi
version: 1.0.0
description: OpenAPI API client
dependencies:
  openapi:
    git: https://github.com/GIT_USER_ID/GIT_REPO_ID.git
      version: 'any'
```

### Local
To use the package in your local drive, please include the following in pubspec.yaml
```
dependencies:
  openapi:
    path: /path/to/openapi
```

## Tests

TODO

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```dart
import 'package:openapi/api.dart';

// TODO Configure OAuth2 access token for authorization: petstore_auth
//openapi.api.Configuration.accessToken = 'YOUR_ACCESS_TOKEN';

final jaguarApiGen = Openapi();
var api_instance = jaguarApiGen.getPetApi();
var body = new Pet(); // Pet | Pet object that needs to be added to the store

try {
    api_instance.addPet(body);
} catch (e) {
    print("Exception when calling PetApi->addPet: $e\n");
}

```

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PetApi* | [**addPet**](doc//PetApi.md#addpet) | **Post** /pet | Add a new pet to the store
*PetApi* | [**deletePet**](doc//PetApi.md#deletepet) | **Delete** /pet/:petId | Deletes a pet
*PetApi* | [**findPetsByStatus**](doc//PetApi.md#findpetsbystatus) | **Get** /pet/findByStatus | Finds Pets by status
*PetApi* | [**findPetsByTags**](doc//PetApi.md#findpetsbytags) | **Get** /pet/findByTags | Finds Pets by tags
*PetApi* | [**getPetById**](doc//PetApi.md#getpetbyid) | **Get** /pet/:petId | Find pet by ID
*PetApi* | [**updatePet**](doc//PetApi.md#updatepet) | **Put** /pet | Update an existing pet
*PetApi* | [**updatePetWithForm**](doc//PetApi.md#updatepetwithform) | **Post** /pet/:petId | Updates a pet in the store with form data
*PetApi* | [**uploadFile**](doc//PetApi.md#uploadfile) | **Post** /pet/:petId/uploadImage | uploads an image
*StoreApi* | [**deleteOrder**](doc//StoreApi.md#deleteorder) | **Delete** /store/order/:orderId | Delete purchase order by ID
*StoreApi* | [**getInventory**](doc//StoreApi.md#getinventory) | **Get** /store/inventory | Returns pet inventories by status
*StoreApi* | [**getOrderById**](doc//StoreApi.md#getorderbyid) | **Get** /store/order/:orderId | Find purchase order by ID
*StoreApi* | [**placeOrder**](doc//StoreApi.md#placeorder) | **Post** /store/order | Place an order for a pet
*UserApi* | [**createUser**](doc//UserApi.md#createuser) | **Post** /user | Create user
*UserApi* | [**createUsersWithArrayInput**](doc//UserApi.md#createuserswitharrayinput) | **Post** /user/createWithArray | Creates list of users with given input array
*UserApi* | [**createUsersWithListInput**](doc//UserApi.md#createuserswithlistinput) | **Post** /user/createWithList | Creates list of users with given input array
*UserApi* | [**deleteUser**](doc//UserApi.md#deleteuser) | **Delete** /user/:username | Delete user
*UserApi* | [**getUserByName**](doc//UserApi.md#getuserbyname) | **Get** /user/:username | Get user by user name
*UserApi* | [**loginUser**](doc//UserApi.md#loginuser) | **Get** /user/login | Logs user into the system
*UserApi* | [**logoutUser**](doc//UserApi.md#logoutuser) | **Get** /user/logout | Logs out current logged in user session
*UserApi* | [**updateUser**](doc//UserApi.md#updateuser) | **Put** /user/:username | Updated user


## Documentation For Models

 - [ApiResponse](doc//ApiResponse.md)
 - [Category](doc//Category.md)
 - [Order](doc//Order.md)
 - [Pet](doc//Pet.md)
 - [Tag](doc//Tag.md)
 - [User](doc//User.md)


## Documentation For Authorization


## api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header

## petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
 - **write:pets**: modify pets in your account
 - **read:pets**: read your pets


## Author




