# open_api_petstore

OpenApiPetstore - JavaScript client for open_api_petstore
This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
This SDK is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.JavascriptClientCodegen

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/), please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install open_api_petstore --save
```

Finally, you need to build the module:

```shell
npm run build
```

##### Local development

To use the library locally without publishing to a remote npm registry, first install the dependencies by changing into the directory containing `package.json` (and this README). Let's call this `JAVASCRIPT_CLIENT_DIR`. Then run:

```shell
npm install
```

Next, [link](https://docs.npmjs.com/cli/link) it globally in npm with the following, also from `JAVASCRIPT_CLIENT_DIR`:

```shell
npm link
```

To use the link you just defined in your project, switch to the directory you want to use your open_api_petstore from, and run:

```shell
npm link /path/to/<JAVASCRIPT_CLIENT_DIR>
```

Finally, you need to build the module:

```shell
npm run build
```

#### git

If the library is hosted at a git repository, e.g.https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var OpenApiPetstore = require('open_api_petstore');


var api = new OpenApiPetstore.AnotherFakeApi()
var body = new OpenApiPetstore.Client(); // {Client} client model
var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
api.call123testSpecialTags(body, callback);

```

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io:80/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OpenApiPetstore.AnotherFakeApi* | [**call123testSpecialTags**](docs/AnotherFakeApi.md#call123testSpecialTags) | **PATCH** /another-fake/dummy | To test special tags
*OpenApiPetstore.FakeApi* | [**createXmlItem**](docs/FakeApi.md#createXmlItem) | **POST** /fake/create_xml_item | creates an XmlItem
*OpenApiPetstore.FakeApi* | [**fakeOuterBooleanSerialize**](docs/FakeApi.md#fakeOuterBooleanSerialize) | **POST** /fake/outer/boolean | 
*OpenApiPetstore.FakeApi* | [**fakeOuterCompositeSerialize**](docs/FakeApi.md#fakeOuterCompositeSerialize) | **POST** /fake/outer/composite | 
*OpenApiPetstore.FakeApi* | [**fakeOuterNumberSerialize**](docs/FakeApi.md#fakeOuterNumberSerialize) | **POST** /fake/outer/number | 
*OpenApiPetstore.FakeApi* | [**fakeOuterStringSerialize**](docs/FakeApi.md#fakeOuterStringSerialize) | **POST** /fake/outer/string | 
*OpenApiPetstore.FakeApi* | [**testBodyWithFileSchema**](docs/FakeApi.md#testBodyWithFileSchema) | **PUT** /fake/body-with-file-schema | 
*OpenApiPetstore.FakeApi* | [**testBodyWithQueryParams**](docs/FakeApi.md#testBodyWithQueryParams) | **PUT** /fake/body-with-query-params | 
*OpenApiPetstore.FakeApi* | [**testClientModel**](docs/FakeApi.md#testClientModel) | **PATCH** /fake | To test \&quot;client\&quot; model
*OpenApiPetstore.FakeApi* | [**testEndpointParameters**](docs/FakeApi.md#testEndpointParameters) | **POST** /fake | Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
*OpenApiPetstore.FakeApi* | [**testEnumParameters**](docs/FakeApi.md#testEnumParameters) | **GET** /fake | To test enum parameters
*OpenApiPetstore.FakeApi* | [**testGroupParameters**](docs/FakeApi.md#testGroupParameters) | **DELETE** /fake | Fake endpoint to test group parameters (optional)
*OpenApiPetstore.FakeApi* | [**testInlineAdditionalProperties**](docs/FakeApi.md#testInlineAdditionalProperties) | **POST** /fake/inline-additionalProperties | test inline additionalProperties
*OpenApiPetstore.FakeApi* | [**testJsonFormData**](docs/FakeApi.md#testJsonFormData) | **GET** /fake/jsonFormData | test json serialization of form data
*OpenApiPetstore.FakeApi* | [**testQueryParameterCollectionFormat**](docs/FakeApi.md#testQueryParameterCollectionFormat) | **PUT** /fake/test-query-paramters | 
*OpenApiPetstore.FakeClassnameTags123Api* | [**testClassname**](docs/FakeClassnameTags123Api.md#testClassname) | **PATCH** /fake_classname_test | To test class name in snake case
*OpenApiPetstore.PetApi* | [**addPet**](docs/PetApi.md#addPet) | **POST** /pet | Add a new pet to the store
*OpenApiPetstore.PetApi* | [**deletePet**](docs/PetApi.md#deletePet) | **DELETE** /pet/{petId} | Deletes a pet
*OpenApiPetstore.PetApi* | [**findPetsByStatus**](docs/PetApi.md#findPetsByStatus) | **GET** /pet/findByStatus | Finds Pets by status
*OpenApiPetstore.PetApi* | [**findPetsByTags**](docs/PetApi.md#findPetsByTags) | **GET** /pet/findByTags | Finds Pets by tags
*OpenApiPetstore.PetApi* | [**getPetById**](docs/PetApi.md#getPetById) | **GET** /pet/{petId} | Find pet by ID
*OpenApiPetstore.PetApi* | [**updatePet**](docs/PetApi.md#updatePet) | **PUT** /pet | Update an existing pet
*OpenApiPetstore.PetApi* | [**updatePetWithForm**](docs/PetApi.md#updatePetWithForm) | **POST** /pet/{petId} | Updates a pet in the store with form data
*OpenApiPetstore.PetApi* | [**uploadFile**](docs/PetApi.md#uploadFile) | **POST** /pet/{petId}/uploadImage | uploads an image
*OpenApiPetstore.PetApi* | [**uploadFileWithRequiredFile**](docs/PetApi.md#uploadFileWithRequiredFile) | **POST** /fake/{petId}/uploadImageWithRequiredFile | uploads an image (required)
*OpenApiPetstore.StoreApi* | [**deleteOrder**](docs/StoreApi.md#deleteOrder) | **DELETE** /store/order/{order_id} | Delete purchase order by ID
*OpenApiPetstore.StoreApi* | [**getInventory**](docs/StoreApi.md#getInventory) | **GET** /store/inventory | Returns pet inventories by status
*OpenApiPetstore.StoreApi* | [**getOrderById**](docs/StoreApi.md#getOrderById) | **GET** /store/order/{order_id} | Find purchase order by ID
*OpenApiPetstore.StoreApi* | [**placeOrder**](docs/StoreApi.md#placeOrder) | **POST** /store/order | Place an order for a pet
*OpenApiPetstore.UserApi* | [**createUser**](docs/UserApi.md#createUser) | **POST** /user | Create user
*OpenApiPetstore.UserApi* | [**createUsersWithArrayInput**](docs/UserApi.md#createUsersWithArrayInput) | **POST** /user/createWithArray | Creates list of users with given input array
*OpenApiPetstore.UserApi* | [**createUsersWithListInput**](docs/UserApi.md#createUsersWithListInput) | **POST** /user/createWithList | Creates list of users with given input array
*OpenApiPetstore.UserApi* | [**deleteUser**](docs/UserApi.md#deleteUser) | **DELETE** /user/{username} | Delete user
*OpenApiPetstore.UserApi* | [**getUserByName**](docs/UserApi.md#getUserByName) | **GET** /user/{username} | Get user by user name
*OpenApiPetstore.UserApi* | [**loginUser**](docs/UserApi.md#loginUser) | **GET** /user/login | Logs user into the system
*OpenApiPetstore.UserApi* | [**logoutUser**](docs/UserApi.md#logoutUser) | **GET** /user/logout | Logs out current logged in user session
*OpenApiPetstore.UserApi* | [**updateUser**](docs/UserApi.md#updateUser) | **PUT** /user/{username} | Updated user


## Documentation for Models

 - [OpenApiPetstore.AdditionalPropertiesAnyType](docs/AdditionalPropertiesAnyType.md)
 - [OpenApiPetstore.AdditionalPropertiesArray](docs/AdditionalPropertiesArray.md)
 - [OpenApiPetstore.AdditionalPropertiesBoolean](docs/AdditionalPropertiesBoolean.md)
 - [OpenApiPetstore.AdditionalPropertiesClass](docs/AdditionalPropertiesClass.md)
 - [OpenApiPetstore.AdditionalPropertiesInteger](docs/AdditionalPropertiesInteger.md)
 - [OpenApiPetstore.AdditionalPropertiesNumber](docs/AdditionalPropertiesNumber.md)
 - [OpenApiPetstore.AdditionalPropertiesObject](docs/AdditionalPropertiesObject.md)
 - [OpenApiPetstore.AdditionalPropertiesString](docs/AdditionalPropertiesString.md)
 - [OpenApiPetstore.Animal](docs/Animal.md)
 - [OpenApiPetstore.ApiResponse](docs/ApiResponse.md)
 - [OpenApiPetstore.ArrayOfArrayOfNumberOnly](docs/ArrayOfArrayOfNumberOnly.md)
 - [OpenApiPetstore.ArrayOfNumberOnly](docs/ArrayOfNumberOnly.md)
 - [OpenApiPetstore.ArrayTest](docs/ArrayTest.md)
 - [OpenApiPetstore.BigCat](docs/BigCat.md)
 - [OpenApiPetstore.BigCatAllOf](docs/BigCatAllOf.md)
 - [OpenApiPetstore.Capitalization](docs/Capitalization.md)
 - [OpenApiPetstore.Cat](docs/Cat.md)
 - [OpenApiPetstore.CatAllOf](docs/CatAllOf.md)
 - [OpenApiPetstore.Category](docs/Category.md)
 - [OpenApiPetstore.ClassModel](docs/ClassModel.md)
 - [OpenApiPetstore.Client](docs/Client.md)
 - [OpenApiPetstore.Dog](docs/Dog.md)
 - [OpenApiPetstore.DogAllOf](docs/DogAllOf.md)
 - [OpenApiPetstore.EnumArrays](docs/EnumArrays.md)
 - [OpenApiPetstore.EnumClass](docs/EnumClass.md)
 - [OpenApiPetstore.EnumTest](docs/EnumTest.md)
 - [OpenApiPetstore.File](docs/File.md)
 - [OpenApiPetstore.FileSchemaTestClass](docs/FileSchemaTestClass.md)
 - [OpenApiPetstore.FormatTest](docs/FormatTest.md)
 - [OpenApiPetstore.HasOnlyReadOnly](docs/HasOnlyReadOnly.md)
 - [OpenApiPetstore.List](docs/List.md)
 - [OpenApiPetstore.MapTest](docs/MapTest.md)
 - [OpenApiPetstore.MixedPropertiesAndAdditionalPropertiesClass](docs/MixedPropertiesAndAdditionalPropertiesClass.md)
 - [OpenApiPetstore.Model200Response](docs/Model200Response.md)
 - [OpenApiPetstore.ModelReturn](docs/ModelReturn.md)
 - [OpenApiPetstore.Name](docs/Name.md)
 - [OpenApiPetstore.NumberOnly](docs/NumberOnly.md)
 - [OpenApiPetstore.Order](docs/Order.md)
 - [OpenApiPetstore.OuterComposite](docs/OuterComposite.md)
 - [OpenApiPetstore.OuterEnum](docs/OuterEnum.md)
 - [OpenApiPetstore.Pet](docs/Pet.md)
 - [OpenApiPetstore.ReadOnlyFirst](docs/ReadOnlyFirst.md)
 - [OpenApiPetstore.SpecialModelName](docs/SpecialModelName.md)
 - [OpenApiPetstore.Tag](docs/Tag.md)
 - [OpenApiPetstore.TypeHolderDefault](docs/TypeHolderDefault.md)
 - [OpenApiPetstore.TypeHolderExample](docs/TypeHolderExample.md)
 - [OpenApiPetstore.User](docs/User.md)
 - [OpenApiPetstore.XmlItem](docs/XmlItem.md)


## Documentation for Authorization



### api_key


- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header



### api_key_query


- **Type**: API key
- **API key parameter name**: api_key_query
- **Location**: URL query string



### http_basic_test

- **Type**: HTTP basic authentication



### petstore_auth


- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
  - write:pets: modify pets in your account
  - read:pets: read your pets

