import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import _wrapNativeSuper from "@babel/runtime/helpers/esm/wrapNativeSuper";

/* eslint-disable no-use-before-define */

/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 *
 * NOTE: This class is auto generated by OpenAPI-Generator
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as url from "url";
import * as portableFetch from "portable-fetch";
import { Configuration } from "./configuration";
var BASE_PATH = "http://petstore.swagger.io/v2".replace(/\/+$/, "");
/**
 *
 * @export
 */

export var COLLECTION_FORMATS = {
  csv: ",",
  ssv: " ",
  tsv: "\t",
  pipes: "|"
};
/**
 *
 * @export
 */

/**
 * * @export
 * @class RequiredError
 * @extends {Error}
 */
export var RequiredError =
/*#__PURE__*/
function (_Error) {
  _inherits(RequiredError, _Error);

  function RequiredError(field, msg) {
    var _this;

    _classCallCheck(this, RequiredError);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(RequiredError).call(this, msg));
    _this.name = "RequiredError";
    return _this;
  }

  return RequiredError;
}(_wrapNativeSuper(Error));
/**
 * Describes the result of uploading an image resource
 * @export
 */

/**
 * PetApi - fetch parameter creator
 * @export
 */
export var PetApiFetchParamCreator = function PetApiFetchParamCreator(configuration) {
  return {
    /**
     * 
     * @summary Add a new pet to the store
     * @throws {RequiredError}
     */
    addPet: function addPet(body, options) {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling addPet.');
      }

      var localVarPath = "/pet";
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {}; // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        var localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      var needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Deletes a pet
     * @throws {RequiredError}
     */
    deletePet: function deletePet(petId, apiKey, options) {
      // verify required parameter 'petId' is not null or undefined
      if (petId === null || petId === undefined) {
        throw new RequiredError('petId', 'Required parameter petId was null or undefined when calling deletePet.');
      }

      var localVarPath = "/pet/{petId}".replace("{".concat("petId", "}"), encodeURIComponent(String(petId)));
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'DELETE'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {}; // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        var localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      if (apiKey !== undefined && apiKey !== null) {
        localVarHeaderParameter['api_key'] = apiKey;
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * Multiple status values can be provided with comma separated strings
     * @summary Finds Pets by status
     * @throws {RequiredError}
     */
    findPetsByStatus: function findPetsByStatus(status, options) {
      // verify required parameter 'status' is not null or undefined
      if (status === null || status === undefined) {
        throw new RequiredError('status', 'Required parameter status was null or undefined when calling findPetsByStatus.');
      }

      var localVarPath = "/pet/findByStatus";
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {}; // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        var localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      if (status) {
        localVarQueryParameter['status'] = status.join(COLLECTION_FORMATS["csv"]);
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     * @summary Finds Pets by tags
     * @throws {RequiredError}
     */
    findPetsByTags: function findPetsByTags(tags, options) {
      // verify required parameter 'tags' is not null or undefined
      if (tags === null || tags === undefined) {
        throw new RequiredError('tags', 'Required parameter tags was null or undefined when calling findPetsByTags.');
      }

      var localVarPath = "/pet/findByTags";
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {}; // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        var localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      if (tags) {
        localVarQueryParameter['tags'] = tags.join(COLLECTION_FORMATS["csv"]);
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * Returns a single pet
     * @summary Find pet by ID
     * @throws {RequiredError}
     */
    getPetById: function getPetById(petId, options) {
      // verify required parameter 'petId' is not null or undefined
      if (petId === null || petId === undefined) {
        throw new RequiredError('petId', 'Required parameter petId was null or undefined when calling getPetById.');
      }

      var localVarPath = "/pet/{petId}".replace("{".concat("petId", "}"), encodeURIComponent(String(petId)));
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {}; // authentication api_key required

      if (configuration && configuration.apiKey) {
        var localVarApiKeyValue = typeof configuration.apiKey === 'function' ? configuration.apiKey("api_key") : configuration.apiKey;
        localVarHeaderParameter["api_key"] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Update an existing pet
     * @throws {RequiredError}
     */
    updatePet: function updatePet(body, options) {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling updatePet.');
      }

      var localVarPath = "/pet";
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'PUT'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {}; // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        var localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      var needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Updates a pet in the store with form data
     * @throws {RequiredError}
     */
    updatePetWithForm: function updatePetWithForm(petId, name, status, options) {
      // verify required parameter 'petId' is not null or undefined
      if (petId === null || petId === undefined) {
        throw new RequiredError('petId', 'Required parameter petId was null or undefined when calling updatePetWithForm.');
      }

      var localVarPath = "/pet/{petId}".replace("{".concat("petId", "}"), encodeURIComponent(String(petId)));
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};
      var localVarFormParams = new FormData(); // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        var localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      if (name !== undefined) {
        localVarFormParams.set('name', name);
      }

      if (status !== undefined) {
        localVarFormParams.set('status', status);
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      localVarRequestOptions.body = localVarFormParams;
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary uploads an image
     * @throws {RequiredError}
     */
    uploadFile: function uploadFile(petId, additionalMetadata, file, options) {
      // verify required parameter 'petId' is not null or undefined
      if (petId === null || petId === undefined) {
        throw new RequiredError('petId', 'Required parameter petId was null or undefined when calling uploadFile.');
      }

      var localVarPath = "/pet/{petId}/uploadImage".replace("{".concat("petId", "}"), encodeURIComponent(String(petId)));
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};
      var localVarFormParams = new FormData(); // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        var localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      if (additionalMetadata !== undefined) {
        localVarFormParams.set('additionalMetadata', additionalMetadata);
      }

      if (file !== undefined) {
        localVarFormParams.set('file', file);
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      localVarRequestOptions.body = localVarFormParams;
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    }
  };
};

/**
 * PetApi - factory function to inject configuration 
 * @export
 */
export var PetApi = function PetApi(configuration) {
  var fetch = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : portableFetch;
  var basePath = configuration && configuration.basePath || BASE_PATH;
  return {
    /**
     * 
     * @summary Add a new pet to the store
     * @throws {RequiredError}
     */
    addPet: function addPet(body) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = PetApiFetchParamCreator(configuration).addPet(body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Deletes a pet
     * @throws {RequiredError}
     */
    deletePet: function deletePet(petId, apiKey) {
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var localVarFetchArgs = PetApiFetchParamCreator(configuration).deletePet(petId, apiKey, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * Multiple status values can be provided with comma separated strings
     * @summary Finds Pets by status
     * @throws {RequiredError}
     */
    findPetsByStatus: function findPetsByStatus(status) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = PetApiFetchParamCreator(configuration).findPetsByStatus(status, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     * @summary Finds Pets by tags
     * @throws {RequiredError}
     */
    findPetsByTags: function findPetsByTags(tags) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = PetApiFetchParamCreator(configuration).findPetsByTags(tags, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * Returns a single pet
     * @summary Find pet by ID
     * @throws {RequiredError}
     */
    getPetById: function getPetById(petId) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = PetApiFetchParamCreator(configuration).getPetById(petId, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Update an existing pet
     * @throws {RequiredError}
     */
    updatePet: function updatePet(body) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = PetApiFetchParamCreator(configuration).updatePet(body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Updates a pet in the store with form data
     * @throws {RequiredError}
     */
    updatePetWithForm: function updatePetWithForm(petId, name, status) {
      var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      var localVarFetchArgs = PetApiFetchParamCreator(configuration).updatePetWithForm(petId, name, status, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary uploads an image
     * @throws {RequiredError}
     */
    uploadFile: function uploadFile(petId, additionalMetadata, file) {
      var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      var localVarFetchArgs = PetApiFetchParamCreator(configuration).uploadFile(petId, additionalMetadata, file, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    }
  };
};
/**
 * StoreApi - fetch parameter creator
 * @export
 */

export var StoreApiFetchParamCreator = function StoreApiFetchParamCreator(configuration) {
  return {
    /**
     * For valid response try integer IDs with value < 1000. Anything above 1000 or nonintegers will generate API errors
     * @summary Delete purchase order by ID
     * @throws {RequiredError}
     */
    deleteOrder: function deleteOrder(orderId, options) {
      // verify required parameter 'orderId' is not null or undefined
      if (orderId === null || orderId === undefined) {
        throw new RequiredError('orderId', 'Required parameter orderId was null or undefined when calling deleteOrder.');
      }

      var localVarPath = "/store/order/{orderId}".replace("{".concat("orderId", "}"), encodeURIComponent(String(orderId)));
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'DELETE'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * Returns a map of status codes to quantities
     * @summary Returns pet inventories by status
     * @throws {RequiredError}
     */
    getInventory: function getInventory(options) {
      var localVarPath = "/store/inventory";
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {}; // authentication api_key required

      if (configuration && configuration.apiKey) {
        var localVarApiKeyValue = typeof configuration.apiKey === 'function' ? configuration.apiKey("api_key") : configuration.apiKey;
        localVarHeaderParameter["api_key"] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * For valid response try integer IDs with value <= 5 or > 10. Other values will generated exceptions
     * @summary Find purchase order by ID
     * @throws {RequiredError}
     */
    getOrderById: function getOrderById(orderId, options) {
      // verify required parameter 'orderId' is not null or undefined
      if (orderId === null || orderId === undefined) {
        throw new RequiredError('orderId', 'Required parameter orderId was null or undefined when calling getOrderById.');
      }

      var localVarPath = "/store/order/{orderId}".replace("{".concat("orderId", "}"), encodeURIComponent(String(orderId)));
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Place an order for a pet
     * @throws {RequiredError}
     */
    placeOrder: function placeOrder(body, options) {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling placeOrder.');
      }

      var localVarPath = "/store/order";
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};
      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      var needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    }
  };
};

/**
 * StoreApi - factory function to inject configuration 
 * @export
 */
export var StoreApi = function StoreApi(configuration) {
  var fetch = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : portableFetch;
  var basePath = configuration && configuration.basePath || BASE_PATH;
  return {
    /**
     * For valid response try integer IDs with value < 1000. Anything above 1000 or nonintegers will generate API errors
     * @summary Delete purchase order by ID
     * @throws {RequiredError}
     */
    deleteOrder: function deleteOrder(orderId) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = StoreApiFetchParamCreator(configuration).deleteOrder(orderId, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * Returns a map of status codes to quantities
     * @summary Returns pet inventories by status
     * @throws {RequiredError}
     */
    getInventory: function getInventory() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var localVarFetchArgs = StoreApiFetchParamCreator(configuration).getInventory(options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * For valid response try integer IDs with value <= 5 or > 10. Other values will generated exceptions
     * @summary Find purchase order by ID
     * @throws {RequiredError}
     */
    getOrderById: function getOrderById(orderId) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = StoreApiFetchParamCreator(configuration).getOrderById(orderId, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Place an order for a pet
     * @throws {RequiredError}
     */
    placeOrder: function placeOrder(body) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = StoreApiFetchParamCreator(configuration).placeOrder(body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    }
  };
};
/**
 * UserApi - fetch parameter creator
 * @export
 */

export var UserApiFetchParamCreator = function UserApiFetchParamCreator(configuration) {
  return {
    /**
     * This can only be done by the logged in user.
     * @summary Create user
     * @throws {RequiredError}
     */
    createUser: function createUser(body, options) {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling createUser.');
      }

      var localVarPath = "/user";
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};
      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      var needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Creates list of users with given input array
     * @throws {RequiredError}
     */
    createUsersWithArrayInput: function createUsersWithArrayInput(body, options) {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling createUsersWithArrayInput.');
      }

      var localVarPath = "/user/createWithArray";
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};
      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      var needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Creates list of users with given input array
     * @throws {RequiredError}
     */
    createUsersWithListInput: function createUsersWithListInput(body, options) {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling createUsersWithListInput.');
      }

      var localVarPath = "/user/createWithList";
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};
      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      var needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * This can only be done by the logged in user.
     * @summary Delete user
     * @throws {RequiredError}
     */
    deleteUser: function deleteUser(username, options) {
      // verify required parameter 'username' is not null or undefined
      if (username === null || username === undefined) {
        throw new RequiredError('username', 'Required parameter username was null or undefined when calling deleteUser.');
      }

      var localVarPath = "/user/{username}".replace("{".concat("username", "}"), encodeURIComponent(String(username)));
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'DELETE'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Get user by user name
     * @throws {RequiredError}
     */
    getUserByName: function getUserByName(username, options) {
      // verify required parameter 'username' is not null or undefined
      if (username === null || username === undefined) {
        throw new RequiredError('username', 'Required parameter username was null or undefined when calling getUserByName.');
      }

      var localVarPath = "/user/{username}".replace("{".concat("username", "}"), encodeURIComponent(String(username)));
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Logs user into the system
     * @throws {RequiredError}
     */
    loginUser: function loginUser(username, password, options) {
      // verify required parameter 'username' is not null or undefined
      if (username === null || username === undefined) {
        throw new RequiredError('username', 'Required parameter username was null or undefined when calling loginUser.');
      } // verify required parameter 'password' is not null or undefined


      if (password === null || password === undefined) {
        throw new RequiredError('password', 'Required parameter password was null or undefined when calling loginUser.');
      }

      var localVarPath = "/user/login";
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};

      if (username !== undefined) {
        localVarQueryParameter['username'] = username;
      }

      if (password !== undefined) {
        localVarQueryParameter['password'] = password;
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Logs out current logged in user session
     * @throws {RequiredError}
     */
    logoutUser: function logoutUser(options) {
      var localVarPath = "/user/logout";
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * This can only be done by the logged in user.
     * @summary Updated user
     * @throws {RequiredError}
     */
    updateUser: function updateUser(username, body, options) {
      // verify required parameter 'username' is not null or undefined
      if (username === null || username === undefined) {
        throw new RequiredError('username', 'Required parameter username was null or undefined when calling updateUser.');
      } // verify required parameter 'body' is not null or undefined


      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling updateUser.');
      }

      var localVarPath = "/user/{username}".replace("{".concat("username", "}"), encodeURIComponent(String(username)));
      var localVarUrlObj = url.parse(localVarPath, true);
      var localVarRequestOptions = Object.assign({}, {
        method: 'PUT'
      }, options);
      var localVarHeaderParameter = {};
      var localVarQueryParameter = {};
      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      var needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    }
  };
};

/**
 * UserApi - factory function to inject configuration 
 * @export
 */
export var UserApi = function UserApi(configuration) {
  var fetch = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : portableFetch;
  var basePath = configuration && configuration.basePath || BASE_PATH;
  return {
    /**
     * This can only be done by the logged in user.
     * @summary Create user
     * @throws {RequiredError}
     */
    createUser: function createUser(body) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = UserApiFetchParamCreator(configuration).createUser(body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Creates list of users with given input array
     * @throws {RequiredError}
     */
    createUsersWithArrayInput: function createUsersWithArrayInput(body) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = UserApiFetchParamCreator(configuration).createUsersWithArrayInput(body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Creates list of users with given input array
     * @throws {RequiredError}
     */
    createUsersWithListInput: function createUsersWithListInput(body) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = UserApiFetchParamCreator(configuration).createUsersWithListInput(body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * This can only be done by the logged in user.
     * @summary Delete user
     * @throws {RequiredError}
     */
    deleteUser: function deleteUser(username) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = UserApiFetchParamCreator(configuration).deleteUser(username, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Get user by user name
     * @throws {RequiredError}
     */
    getUserByName: function getUserByName(username) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var localVarFetchArgs = UserApiFetchParamCreator(configuration).getUserByName(username, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Logs user into the system
     * @throws {RequiredError}
     */
    loginUser: function loginUser(username, password) {
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var localVarFetchArgs = UserApiFetchParamCreator(configuration).loginUser(username, password, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Logs out current logged in user session
     * @throws {RequiredError}
     */
    logoutUser: function logoutUser() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var localVarFetchArgs = UserApiFetchParamCreator(configuration).logoutUser(options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * This can only be done by the logged in user.
     * @summary Updated user
     * @throws {RequiredError}
     */
    updateUser: function updateUser(username, body) {
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var localVarFetchArgs = UserApiFetchParamCreator(configuration).updateUser(username, body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(function (response) {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    }
  };
};