# Nim API client for OpenAPI Petstore (Package: petstore)

This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.NimClientCodegen

## Installation

Put the package under your project folder and add the following to the nimble file of your project:

```
import petstore
```

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Module | Proc | HTTP request | Description
------------ | ------------- | ------------- | -------------
api_pet | addPet | **POST** /pet | Add a new pet to the store
api_pet | deletePet | **DELETE** /pet/{petId} | Deletes a pet
api_pet | findPetsByStatus | **GET** /pet/findByStatus | Finds Pets by status
api_pet | findPetsByTags | **GET** /pet/findByTags | Finds Pets by tags
api_pet | getPetById | **GET** /pet/{petId} | Find pet by ID
api_pet | updatePet | **PUT** /pet | Update an existing pet
api_pet | updatePetWithForm | **POST** /pet/{petId} | Updates a pet in the store with form data
api_pet | uploadFile | **POST** /pet/{petId}/uploadImage | uploads an image
api_store | deleteOrder | **DELETE** /store/order/{orderId} | Delete purchase order by ID
api_store | getInventory | **GET** /store/inventory | Returns pet inventories by status
api_store | getOrderById | **GET** /store/order/{orderId} | Find purchase order by ID
api_store | placeOrder | **POST** /store/order | Place an order for a pet
api_user | createUser | **POST** /user | Create user
api_user | createUsersWithArrayInput | **POST** /user/createWithArray | Creates list of users with given input array
api_user | createUsersWithListInput | **POST** /user/createWithList | Creates list of users with given input array
api_user | deleteUser | **DELETE** /user/{username} | Delete user
api_user | getUserByName | **GET** /user/{username} | Get user by user name
api_user | loginUser | **GET** /user/login | Logs user into the system
api_user | logoutUser | **GET** /user/logout | Logs out current logged in user session
api_user | updateUser | **PUT** /user/{username} | Updated user


To generate documentation with Nim DocGen, use:

```
nim doc --project --index:on petstore.nim
```

