# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401
import sys  # noqa: F401

# python 2 and python 3 compatibility library
import six

from petstore_api.api_client import ApiClient
from petstore_api.exceptions import (
    ApiTypeError,
    ApiValueError
)
from petstore_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    int,
    none_type,
    str,
    validate_and_convert_types
)
from petstore_api.models import xml_item
from petstore_api.models import outer_composite
from petstore_api.models import outer_enum
from petstore_api.models import outer_number
from petstore_api.models import file_schema_test_class
from petstore_api.models import user
from petstore_api.models import client


class FakeApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_xml_item(
            self,
            xml_item,
            **kwargs
        ):
            """creates an XmlItem  # noqa: E501

            this route creates an XmlItem  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.create_xml_item(xml_item, async_req=True)
            >>> result = thread.get()

            Args:
                xml_item (xml_item.XmlItem): XmlItem Body

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            kwargs['xml_item'] = \
                xml_item
            return self.call_with_http_info(**kwargs)

        self.create_xml_item = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/fake/create_xml_item',
                'operation_id': 'create_xml_item',
                'http_method': 'POST',
                'servers': [],
            },
            params_map={
                'all': [
                    'xml_item',
                ],
                'required': [
                    'xml_item',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'xml_item':
                        (xml_item.XmlItem,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'xml_item': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/xml',
                    'application/xml; charset=utf-8',
                    'application/xml; charset=utf-16',
                    'text/xml',
                    'text/xml; charset=utf-8',
                    'text/xml; charset=utf-16'
                ]
            },
            api_client=api_client,
            callable=__create_xml_item
        )

        def __fake_outer_boolean_serialize(
            self,
            **kwargs
        ):
            """fake_outer_boolean_serialize  # noqa: E501

            Test serialization of outer boolean types  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.fake_outer_boolean_serialize(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                body (bool): Input boolean as post body. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                bool
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            return self.call_with_http_info(**kwargs)

        self.fake_outer_boolean_serialize = Endpoint(
            settings={
                'response_type': (bool,),
                'auth': [],
                'endpoint_path': '/fake/outer/boolean',
                'operation_id': 'fake_outer_boolean_serialize',
                'http_method': 'POST',
                'servers': [],
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (bool,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__fake_outer_boolean_serialize
        )

        def __fake_outer_composite_serialize(
            self,
            **kwargs
        ):
            """fake_outer_composite_serialize  # noqa: E501

            Test serialization of object with outer number type  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.fake_outer_composite_serialize(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                body (outer_composite.OuterComposite): Input composite as post body. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                outer_composite.OuterComposite
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            return self.call_with_http_info(**kwargs)

        self.fake_outer_composite_serialize = Endpoint(
            settings={
                'response_type': (outer_composite.OuterComposite,),
                'auth': [],
                'endpoint_path': '/fake/outer/composite',
                'operation_id': 'fake_outer_composite_serialize',
                'http_method': 'POST',
                'servers': [],
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (outer_composite.OuterComposite,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__fake_outer_composite_serialize
        )

        def __fake_outer_enum_serialize(
            self,
            **kwargs
        ):
            """fake_outer_enum_serialize  # noqa: E501

            Test serialization of outer enum  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.fake_outer_enum_serialize(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                body (outer_enum.OuterEnum): Input enum as post body. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                outer_enum.OuterEnum
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            return self.call_with_http_info(**kwargs)

        self.fake_outer_enum_serialize = Endpoint(
            settings={
                'response_type': (outer_enum.OuterEnum,),
                'auth': [],
                'endpoint_path': '/fake/outer/enum',
                'operation_id': 'fake_outer_enum_serialize',
                'http_method': 'POST',
                'servers': [],
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (outer_enum.OuterEnum,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__fake_outer_enum_serialize
        )

        def __fake_outer_number_serialize(
            self,
            **kwargs
        ):
            """fake_outer_number_serialize  # noqa: E501

            Test serialization of outer number types  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.fake_outer_number_serialize(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                body (outer_number.OuterNumber): Input number as post body. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                outer_number.OuterNumber
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            return self.call_with_http_info(**kwargs)

        self.fake_outer_number_serialize = Endpoint(
            settings={
                'response_type': (outer_number.OuterNumber,),
                'auth': [],
                'endpoint_path': '/fake/outer/number',
                'operation_id': 'fake_outer_number_serialize',
                'http_method': 'POST',
                'servers': [],
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (outer_number.OuterNumber,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__fake_outer_number_serialize
        )

        def __fake_outer_string_serialize(
            self,
            **kwargs
        ):
            """fake_outer_string_serialize  # noqa: E501

            Test serialization of outer string types  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.fake_outer_string_serialize(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                body (str): Input string as post body. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                str
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            return self.call_with_http_info(**kwargs)

        self.fake_outer_string_serialize = Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/fake/outer/string',
                'operation_id': 'fake_outer_string_serialize',
                'http_method': 'POST',
                'servers': [],
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (str,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__fake_outer_string_serialize
        )

        def __test_body_with_file_schema(
            self,
            body,
            **kwargs
        ):
            """test_body_with_file_schema  # noqa: E501

            For this test, the body for this request much reference a schema named `File`.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.test_body_with_file_schema(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (file_schema_test_class.FileSchemaTestClass):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.test_body_with_file_schema = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/fake/body-with-file-schema',
                'operation_id': 'test_body_with_file_schema',
                'http_method': 'PUT',
                'servers': [],
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (file_schema_test_class.FileSchemaTestClass,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__test_body_with_file_schema
        )

        def __test_body_with_query_params(
            self,
            query,
            body,
            **kwargs
        ):
            """test_body_with_query_params  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.test_body_with_query_params(query, body, async_req=True)
            >>> result = thread.get()

            Args:
                query (str):
                body (user.User):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            kwargs['query'] = \
                query
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.test_body_with_query_params = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/fake/body-with-query-params',
                'operation_id': 'test_body_with_query_params',
                'http_method': 'PUT',
                'servers': [],
            },
            params_map={
                'all': [
                    'query',
                    'body',
                ],
                'required': [
                    'query',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query':
                        (str,),
                    'body':
                        (user.User,),
                },
                'attribute_map': {
                    'query': 'query',
                },
                'location_map': {
                    'query': 'query',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__test_body_with_query_params
        )

        def __test_client_model(
            self,
            body,
            **kwargs
        ):
            """To test \"client\" model  # noqa: E501

            To test \"client\" model  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.test_client_model(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (client.Client): client model

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                client.Client
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.test_client_model = Endpoint(
            settings={
                'response_type': (client.Client,),
                'auth': [],
                'endpoint_path': '/fake',
                'operation_id': 'test_client_model',
                'http_method': 'PATCH',
                'servers': [],
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (client.Client,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__test_client_model
        )

        def __test_endpoint_enums_length_one(
            self,
            query_integer=3,
            query_string='brillig',
            path_string='hello',
            path_integer=34,
            header_number=1.234,
            **kwargs
        ):
            """test_endpoint_enums_length_one  # noqa: E501

            This route has required values with enums of 1  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.test_endpoint_enums_length_one(query_integer=3, query_string='brillig', path_string='hello', path_integer=34, header_number=1.234, async_req=True)
            >>> result = thread.get()

            Args:
                query_integer (int): defaults to 3, must be one of [3]
                query_string (str): defaults to 'brillig', must be one of ['brillig']
                path_string (str): defaults to 'hello', must be one of ['hello']
                path_integer (int): defaults to 34, must be one of [34]
                header_number (float): defaults to 1.234, must be one of [1.234]

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            kwargs['query_integer'] = \
                query_integer
            kwargs['query_string'] = \
                query_string
            kwargs['path_string'] = \
                path_string
            kwargs['path_integer'] = \
                path_integer
            kwargs['header_number'] = \
                header_number
            return self.call_with_http_info(**kwargs)

        self.test_endpoint_enums_length_one = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/fake/enums-of-length-one/{path_string}/{path_integer}',
                'operation_id': 'test_endpoint_enums_length_one',
                'http_method': 'PUT',
                'servers': [],
            },
            params_map={
                'all': [
                    'query_integer',
                    'query_string',
                    'path_string',
                    'path_integer',
                    'header_number',
                ],
                'required': [
                    'query_integer',
                    'query_string',
                    'path_string',
                    'path_integer',
                    'header_number',
                ],
                'nullable': [
                ],
                'enum': [
                    'query_integer',
                    'query_string',
                    'path_string',
                    'path_integer',
                    'header_number',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('query_integer',): {

                        "3": 3
                    },
                    ('query_string',): {

                        "BRILLIG": "brillig"
                    },
                    ('path_string',): {

                        "HELLO": "hello"
                    },
                    ('path_integer',): {

                        "34": 34
                    },
                    ('header_number',): {

                        "1.234": 1.234
                    },
                },
                'openapi_types': {
                    'query_integer':
                        (int,),
                    'query_string':
                        (str,),
                    'path_string':
                        (str,),
                    'path_integer':
                        (int,),
                    'header_number':
                        (float,),
                },
                'attribute_map': {
                    'query_integer': 'query_integer',
                    'query_string': 'query_string',
                    'path_string': 'path_string',
                    'path_integer': 'path_integer',
                    'header_number': 'header_number',
                },
                'location_map': {
                    'query_integer': 'query',
                    'query_string': 'query',
                    'path_string': 'path',
                    'path_integer': 'path',
                    'header_number': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__test_endpoint_enums_length_one
        )

        def __test_endpoint_parameters(
            self,
            number,
            double,
            pattern_without_delimiter,
            byte,
            **kwargs
        ):
            """Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트  # noqa: E501

            Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.test_endpoint_parameters(number, double, pattern_without_delimiter, byte, async_req=True)
            >>> result = thread.get()

            Args:
                number (float): None
                double (float): None
                pattern_without_delimiter (str): None
                byte (str): None

            Keyword Args:
                integer (int): None. [optional]
                int32 (int): None. [optional]
                int64 (int): None. [optional]
                float (float): None. [optional]
                string (str): None. [optional]
                binary (file_type): None. [optional]
                date (date): None. [optional]
                date_time (datetime): None. [optional]
                password (str): None. [optional]
                param_callback (str): None. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            kwargs['number'] = \
                number
            kwargs['double'] = \
                double
            kwargs['pattern_without_delimiter'] = \
                pattern_without_delimiter
            kwargs['byte'] = \
                byte
            return self.call_with_http_info(**kwargs)

        self.test_endpoint_parameters = Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'http_basic_test'
                ],
                'endpoint_path': '/fake',
                'operation_id': 'test_endpoint_parameters',
                'http_method': 'POST',
                'servers': [],
            },
            params_map={
                'all': [
                    'number',
                    'double',
                    'pattern_without_delimiter',
                    'byte',
                    'integer',
                    'int32',
                    'int64',
                    'float',
                    'string',
                    'binary',
                    'date',
                    'date_time',
                    'password',
                    'param_callback',
                ],
                'required': [
                    'number',
                    'double',
                    'pattern_without_delimiter',
                    'byte',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'number',
                    'double',
                    'pattern_without_delimiter',
                    'integer',
                    'int32',
                    'float',
                    'string',
                    'password',
                ]
            },
            root_map={
                'validations': {
                    ('number',): {

                        'inclusive_maximum': 543.2,
                        'inclusive_minimum': 32.1,
                    },
                    ('double',): {

                        'inclusive_maximum': 123.4,
                        'inclusive_minimum': 67.8,
                    },
                    ('pattern_without_delimiter',): {

                        'regex': {
                            'pattern': r'^[A-Z].*',  # noqa: E501
                        },
                    },
                    ('integer',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 10,
                    },
                    ('int32',): {

                        'inclusive_maximum': 200,
                        'inclusive_minimum': 20,
                    },
                    ('float',): {

                        'inclusive_maximum': 987.6,
                    },
                    ('string',): {

                        'regex': {
                            'pattern': r'[a-z]',  # noqa: E501
                            'flags': (re.IGNORECASE)
                        },
                    },
                    ('password',): {
                        'max_length': 64,
                        'min_length': 10,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'number':
                        (float,),
                    'double':
                        (float,),
                    'pattern_without_delimiter':
                        (str,),
                    'byte':
                        (str,),
                    'integer':
                        (int,),
                    'int32':
                        (int,),
                    'int64':
                        (int,),
                    'float':
                        (float,),
                    'string':
                        (str,),
                    'binary':
                        (file_type,),
                    'date':
                        (date,),
                    'date_time':
                        (datetime,),
                    'password':
                        (str,),
                    'param_callback':
                        (str,),
                },
                'attribute_map': {
                    'number': 'number',
                    'double': 'double',
                    'pattern_without_delimiter': 'pattern_without_delimiter',
                    'byte': 'byte',
                    'integer': 'integer',
                    'int32': 'int32',
                    'int64': 'int64',
                    'float': 'float',
                    'string': 'string',
                    'binary': 'binary',
                    'date': 'date',
                    'date_time': 'dateTime',
                    'password': 'password',
                    'param_callback': 'callback',
                },
                'location_map': {
                    'number': 'form',
                    'double': 'form',
                    'pattern_without_delimiter': 'form',
                    'byte': 'form',
                    'integer': 'form',
                    'int32': 'form',
                    'int64': 'form',
                    'float': 'form',
                    'string': 'form',
                    'binary': 'form',
                    'date': 'form',
                    'date_time': 'form',
                    'password': 'form',
                    'param_callback': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/x-www-form-urlencoded'
                ]
            },
            api_client=api_client,
            callable=__test_endpoint_parameters
        )

        def __test_enum_parameters(
            self,
            **kwargs
        ):
            """To test enum parameters  # noqa: E501

            To test enum parameters  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.test_enum_parameters(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                enum_header_string_array ([str]): Header parameter enum test (string array). [optional]
                enum_header_string (str): Header parameter enum test (string). [optional] if omitted the server will use the default value of '-efg'
                enum_query_string_array ([str]): Query parameter enum test (string array). [optional]
                enum_query_string (str): Query parameter enum test (string). [optional] if omitted the server will use the default value of '-efg'
                enum_query_integer (int): Query parameter enum test (double). [optional]
                enum_query_double (float): Query parameter enum test (double). [optional]
                enum_form_string_array ([str]): Form parameter enum test (string array). [optional] if omitted the server will use the default value of '$'
                enum_form_string (str): Form parameter enum test (string). [optional] if omitted the server will use the default value of '-efg'
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            return self.call_with_http_info(**kwargs)

        self.test_enum_parameters = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/fake',
                'operation_id': 'test_enum_parameters',
                'http_method': 'GET',
                'servers': [],
            },
            params_map={
                'all': [
                    'enum_header_string_array',
                    'enum_header_string',
                    'enum_query_string_array',
                    'enum_query_string',
                    'enum_query_integer',
                    'enum_query_double',
                    'enum_form_string_array',
                    'enum_form_string',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'enum_header_string_array',
                    'enum_header_string',
                    'enum_query_string_array',
                    'enum_query_string',
                    'enum_query_integer',
                    'enum_query_double',
                    'enum_form_string_array',
                    'enum_form_string',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('enum_header_string_array',): {

                        "&gt;": ">",
                        "$": "$"
                    },
                    ('enum_header_string',): {

                        "_ABC": "_abc",
                        "-EFG": "-efg",
                        "(XYZ)": "(xyz)"
                    },
                    ('enum_query_string_array',): {

                        "&gt;": ">",
                        "$": "$"
                    },
                    ('enum_query_string',): {

                        "_ABC": "_abc",
                        "-EFG": "-efg",
                        "(XYZ)": "(xyz)"
                    },
                    ('enum_query_integer',): {

                        "1": 1,
                        "-2": -2
                    },
                    ('enum_query_double',): {

                        "1.1": 1.1,
                        "-1.2": -1.2
                    },
                    ('enum_form_string_array',): {

                        "&gt;": ">",
                        "$": "$"
                    },
                    ('enum_form_string',): {

                        "_ABC": "_abc",
                        "-EFG": "-efg",
                        "(XYZ)": "(xyz)"
                    },
                },
                'openapi_types': {
                    'enum_header_string_array':
                        ([str],),
                    'enum_header_string':
                        (str,),
                    'enum_query_string_array':
                        ([str],),
                    'enum_query_string':
                        (str,),
                    'enum_query_integer':
                        (int,),
                    'enum_query_double':
                        (float,),
                    'enum_form_string_array':
                        ([str],),
                    'enum_form_string':
                        (str,),
                },
                'attribute_map': {
                    'enum_header_string_array': 'enum_header_string_array',
                    'enum_header_string': 'enum_header_string',
                    'enum_query_string_array': 'enum_query_string_array',
                    'enum_query_string': 'enum_query_string',
                    'enum_query_integer': 'enum_query_integer',
                    'enum_query_double': 'enum_query_double',
                    'enum_form_string_array': 'enum_form_string_array',
                    'enum_form_string': 'enum_form_string',
                },
                'location_map': {
                    'enum_header_string_array': 'header',
                    'enum_header_string': 'header',
                    'enum_query_string_array': 'query',
                    'enum_query_string': 'query',
                    'enum_query_integer': 'query',
                    'enum_query_double': 'query',
                    'enum_form_string_array': 'form',
                    'enum_form_string': 'form',
                },
                'collection_format_map': {
                    'enum_header_string_array': 'csv',
                    'enum_query_string_array': 'csv',
                    'enum_form_string_array': 'csv',
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/x-www-form-urlencoded'
                ]
            },
            api_client=api_client,
            callable=__test_enum_parameters
        )

        def __test_group_parameters(
            self,
            required_string_group,
            required_boolean_group,
            required_int64_group,
            **kwargs
        ):
            """Fake endpoint to test group parameters (optional)  # noqa: E501

            Fake endpoint to test group parameters (optional)  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.test_group_parameters(required_string_group, required_boolean_group, required_int64_group, async_req=True)
            >>> result = thread.get()

            Args:
                required_string_group (int): Required String in group parameters
                required_boolean_group (bool): Required Boolean in group parameters
                required_int64_group (int): Required Integer in group parameters

            Keyword Args:
                string_group (int): String in group parameters. [optional]
                boolean_group (bool): Boolean in group parameters. [optional]
                int64_group (int): Integer in group parameters. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            kwargs['required_string_group'] = \
                required_string_group
            kwargs['required_boolean_group'] = \
                required_boolean_group
            kwargs['required_int64_group'] = \
                required_int64_group
            return self.call_with_http_info(**kwargs)

        self.test_group_parameters = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/fake',
                'operation_id': 'test_group_parameters',
                'http_method': 'DELETE',
                'servers': [],
            },
            params_map={
                'all': [
                    'required_string_group',
                    'required_boolean_group',
                    'required_int64_group',
                    'string_group',
                    'boolean_group',
                    'int64_group',
                ],
                'required': [
                    'required_string_group',
                    'required_boolean_group',
                    'required_int64_group',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'required_string_group':
                        (int,),
                    'required_boolean_group':
                        (bool,),
                    'required_int64_group':
                        (int,),
                    'string_group':
                        (int,),
                    'boolean_group':
                        (bool,),
                    'int64_group':
                        (int,),
                },
                'attribute_map': {
                    'required_string_group': 'required_string_group',
                    'required_boolean_group': 'required_boolean_group',
                    'required_int64_group': 'required_int64_group',
                    'string_group': 'string_group',
                    'boolean_group': 'boolean_group',
                    'int64_group': 'int64_group',
                },
                'location_map': {
                    'required_string_group': 'query',
                    'required_boolean_group': 'header',
                    'required_int64_group': 'query',
                    'string_group': 'query',
                    'boolean_group': 'header',
                    'int64_group': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__test_group_parameters
        )

        def __test_inline_additional_properties(
            self,
            param,
            **kwargs
        ):
            """test inline additionalProperties  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.test_inline_additional_properties(param, async_req=True)
            >>> result = thread.get()

            Args:
                param ({str: (str,)}): request body

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            kwargs['param'] = \
                param
            return self.call_with_http_info(**kwargs)

        self.test_inline_additional_properties = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/fake/inline-additionalProperties',
                'operation_id': 'test_inline_additional_properties',
                'http_method': 'POST',
                'servers': [],
            },
            params_map={
                'all': [
                    'param',
                ],
                'required': [
                    'param',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'param':
                        ({str: (str,)},),
                },
                'attribute_map': {
                },
                'location_map': {
                    'param': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__test_inline_additional_properties
        )

        def __test_json_form_data(
            self,
            param,
            param2,
            **kwargs
        ):
            """test json serialization of form data  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True
            >>> thread = api.test_json_form_data(param, param2, async_req=True)
            >>> result = thread.get()

            Args:
                param (str): field1
                param2 (str): field2

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int): specifies the index of the server
                    that we want to use.
                    Default is 0.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index', 0)
            kwargs['param'] = \
                param
            kwargs['param2'] = \
                param2
            return self.call_with_http_info(**kwargs)

        self.test_json_form_data = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/fake/jsonFormData',
                'operation_id': 'test_json_form_data',
                'http_method': 'GET',
                'servers': [],
            },
            params_map={
                'all': [
                    'param',
                    'param2',
                ],
                'required': [
                    'param',
                    'param2',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'param':
                        (str,),
                    'param2':
                        (str,),
                },
                'attribute_map': {
                    'param': 'param',
                    'param2': 'param2',
                },
                'location_map': {
                    'param': 'form',
                    'param2': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/x-www-form-urlencoded'
                ]
            },
            api_client=api_client,
            callable=__test_json_form_data
        )


class Endpoint(object):
    def __init__(self, settings=None, params_map=None, root_map=None,
                 headers_map=None, api_client=None, callable=None):
        """Creates an endpoint

        Args:
            settings (dict): see below key value pairs
                'response_type' (tuple/None): response type
                'auth' (list): a list of auth type keys
                'endpoint_path' (str): the endpoint path
                'operation_id' (str): endpoint string identifier
                'http_method' (str): POST/PUT/PATCH/GET etc
                'servers' (list): list of str servers that this endpoint is at
            params_map (dict): see below key value pairs
                'all' (list): list of str endpoint parameter names
                'required' (list): list of required parameter names
                'nullable' (list): list of nullable parameter names
                'enum' (list): list of parameters with enum values
                'validation' (list): list of parameters with validations
            root_map
                'validations' (dict): the dict mapping endpoint parameter tuple
                    paths to their validation dictionaries
                'allowed_values' (dict): the dict mapping endpoint parameter
                    tuple paths to their allowed_values (enum) dictionaries
                'openapi_types' (dict): param_name to openapi type
                'attribute_map' (dict): param_name to camelCase name
                'location_map' (dict): param_name to  'body', 'file', 'form',
                    'header', 'path', 'query'
                collection_format_map (dict): param_name to `csv` etc.
            headers_map (dict): see below key value pairs
                'accept' (list): list of Accept header strings
                'content_type' (list): list of Content-Type header strings
            api_client (ApiClient) api client instance
            callable (function): the function which is invoked when the
                Endpoint is called
        """
        self.settings = settings
        self.params_map = params_map
        self.params_map['all'].extend([
            'async_req',
            '_host_index',
            '_preload_content',
            '_request_timeout',
            '_return_http_data_only',
            '_check_input_type',
            '_check_return_type'
        ])
        self.params_map['nullable'].extend(['_request_timeout'])
        self.validations = root_map['validations']
        self.allowed_values = root_map['allowed_values']
        self.openapi_types = root_map['openapi_types']
        extra_types = {
            'async_req': (bool,),
            '_host_index': (int,),
            '_preload_content': (bool,),
            '_request_timeout': (none_type, int, (int,), [int]),
            '_return_http_data_only': (bool,),
            '_check_input_type': (bool,),
            '_check_return_type': (bool,)
        }
        self.openapi_types.update(extra_types)
        self.attribute_map = root_map['attribute_map']
        self.location_map = root_map['location_map']
        self.collection_format_map = root_map['collection_format_map']
        self.headers_map = headers_map
        self.api_client = api_client
        self.callable = callable

    def __validate_inputs(self, kwargs):
        for param in self.params_map['enum']:
            if param in kwargs:
                check_allowed_values(
                    self.allowed_values,
                    (param,),
                    kwargs[param]
                )

        for param in self.params_map['validation']:
            if param in kwargs:
                check_validations(
                    self.validations,
                    (param,),
                    kwargs[param]
                )

        if kwargs['_check_input_type'] is False:
            return

        for key, value in six.iteritems(kwargs):
            fixed_val = validate_and_convert_types(
                value,
                self.openapi_types[key],
                [key],
                False,
                kwargs['_check_input_type'],
                configuration=self.api_client.configuration
            )
            kwargs[key] = fixed_val

    def __gather_params(self, kwargs):
        params = {
            'body': None,
            'collection_format': {},
            'file': {},
            'form': [],
            'header': {},
            'path': {},
            'query': []
        }

        for param_name, param_value in six.iteritems(kwargs):
            param_location = self.location_map.get(param_name)
            if param_location is None:
                continue
            if param_location:
                if param_location == 'body':
                    params['body'] = param_value
                    continue
                base_name = self.attribute_map[param_name]
                if (param_location == 'form' and
                        self.openapi_types[param_name] == (file_type,)):
                    params['file'][param_name] = [param_value]
                elif (param_location == 'form' and
                        self.openapi_types[param_name] == ([file_type],)):
                    # param_value is already a list
                    params['file'][param_name] = param_value
                elif param_location in {'form', 'query'}:
                    param_value_full = (base_name, param_value)
                    params[param_location].append(param_value_full)
                if param_location not in {'form', 'query'}:
                    params[param_location][base_name] = param_value
                collection_format = self.collection_format_map.get(param_name)
                if collection_format:
                    params['collection_format'][base_name] = collection_format

        return params

    def __call__(self, *args, **kwargs):
        """ This method is invoked when endpoints are called
        Example:
        pet_api = PetApi()
        pet_api.add_pet  # this is an instance of the class Endpoint
        pet_api.add_pet()  # this invokes pet_api.add_pet.__call__()
        which then invokes the callable functions stored in that endpoint at
        pet_api.add_pet.callable or self.callable in this class
        """
        return self.callable(self, *args, **kwargs)

    def call_with_http_info(self, **kwargs):

        try:
            _host = self.settings['servers'][kwargs['_host_index']]
        except IndexError:
            if self.settings['servers']:
                raise ApiValueError(
                    "Invalid host index. Must be 0 <= index < %s" %
                    len(self.settings['servers'])
                )
            _host = None

        for key, value in six.iteritems(kwargs):
            if key not in self.params_map['all']:
                raise ApiTypeError(
                    "Got an unexpected parameter '%s'"
                    " to method `%s`" %
                    (key, self.settings['operation_id'])
                )
            # only throw this nullable ApiValueError if _check_input_type
            # is False, if _check_input_type==True we catch this case
            # in self.__validate_inputs
            if (key not in self.params_map['nullable'] and value is None
                    and kwargs['_check_input_type'] is False):
                raise ApiValueError(
                    "Value may not be None for non-nullable parameter `%s`"
                    " when calling `%s`" %
                    (key, self.settings['operation_id'])
                )

        for key in self.params_map['required']:
            if key not in kwargs.keys():
                raise ApiValueError(
                    "Missing the required parameter `%s` when calling "
                    "`%s`" % (key, self.settings['operation_id'])
                )

        self.__validate_inputs(kwargs)

        params = self.__gather_params(kwargs)

        accept_headers_list = self.headers_map['accept']
        if accept_headers_list:
            params['header']['Accept'] = self.api_client.select_header_accept(
                accept_headers_list)

        content_type_headers_list = self.headers_map['content_type']
        if content_type_headers_list:
            header_list = self.api_client.select_header_content_type(
                content_type_headers_list)
            params['header']['Content-Type'] = header_list

        return self.api_client.call_api(
            self.settings['endpoint_path'], self.settings['http_method'],
            params['path'],
            params['query'],
            params['header'],
            body=params['body'],
            post_params=params['form'],
            files=params['file'],
            response_type=self.settings['response_type'],
            auth_settings=self.settings['auth'],
            async_req=kwargs['async_req'],
            _check_type=kwargs['_check_return_type'],
            _return_http_data_only=kwargs['_return_http_data_only'],
            _preload_content=kwargs['_preload_content'],
            _request_timeout=kwargs['_request_timeout'],
            _host=_host,
            collection_formats=params['collection_format'])
