/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { autoinject } from 'aurelia-framework';
import { HttpClient } from 'aurelia-http-client';
import { Api } from './Api';
import { AuthStorage } from './AuthStorage';
import {
  User,
} from './models';

/**
 * createUser - parameters interface
 */
export interface ICreateUserParams {
  body: User;
}

/**
 * createUsersWithArrayInput - parameters interface
 */
export interface ICreateUsersWithArrayInputParams {
  body: Array<User>;
}

/**
 * createUsersWithListInput - parameters interface
 */
export interface ICreateUsersWithListInputParams {
  body: Array<User>;
}

/**
 * deleteUser - parameters interface
 */
export interface IDeleteUserParams {
  username: string;
}

/**
 * getUserByName - parameters interface
 */
export interface IGetUserByNameParams {
  username: string;
}

/**
 * loginUser - parameters interface
 */
export interface ILoginUserParams {
  username: string;
  password: string;
}

/**
 * logoutUser - parameters interface
 */
export interface ILogoutUserParams {
}

/**
 * updateUser - parameters interface
 */
export interface IUpdateUserParams {
  username: string;
  body: User;
}

/**
 * UserApi - API class
 */
@autoinject()
export class UserApi extends Api {

  /**
   * Creates a new UserApi class.
   *
   * @param httpClient The Aurelia HTTP client to be injected.
   * @param authStorage A storage for authentication data.
   */
  constructor(httpClient: HttpClient, authStorage: AuthStorage) {
    super(httpClient, authStorage);
  }

  /**
   * Create user
   * This can only be done by the logged in user.
   * @param params.body Created user object
   */
  async createUser(params: ICreateUserParams): Promise<any> {
    // Verify required parameters are set
    this.ensureParamIsSet('createUser', params, 'body');

    // Create URL to call
    const url = `${this.basePath}/user`;

    const response = await this.httpClient.createRequest(url)
      // Set HTTP method
      .asPost()
      // Encode body parameter
      .withHeader('content-type', 'application/json')
      .withContent(JSON.stringify(params['body'] || {}))

      // Send the request
      .send();

    if (response.statusCode < 200 || response.statusCode >= 300) {
      throw new Error(response.content);
    }

    // Extract the content
    return response.content;
  }

  /**
   * Creates list of users with given input array
   * @param params.body List of user object
   */
  async createUsersWithArrayInput(params: ICreateUsersWithArrayInputParams): Promise<any> {
    // Verify required parameters are set
    this.ensureParamIsSet('createUsersWithArrayInput', params, 'body');

    // Create URL to call
    const url = `${this.basePath}/user/createWithArray`;

    const response = await this.httpClient.createRequest(url)
      // Set HTTP method
      .asPost()
      // Encode body parameter
      .withHeader('content-type', 'application/json')
      .withContent(JSON.stringify(params['body'] || {}))

      // Send the request
      .send();

    if (response.statusCode < 200 || response.statusCode >= 300) {
      throw new Error(response.content);
    }

    // Extract the content
    return response.content;
  }

  /**
   * Creates list of users with given input array
   * @param params.body List of user object
   */
  async createUsersWithListInput(params: ICreateUsersWithListInputParams): Promise<any> {
    // Verify required parameters are set
    this.ensureParamIsSet('createUsersWithListInput', params, 'body');

    // Create URL to call
    const url = `${this.basePath}/user/createWithList`;

    const response = await this.httpClient.createRequest(url)
      // Set HTTP method
      .asPost()
      // Encode body parameter
      .withHeader('content-type', 'application/json')
      .withContent(JSON.stringify(params['body'] || {}))

      // Send the request
      .send();

    if (response.statusCode < 200 || response.statusCode >= 300) {
      throw new Error(response.content);
    }

    // Extract the content
    return response.content;
  }

  /**
   * Delete user
   * This can only be done by the logged in user.
   * @param params.username The name that needs to be deleted
   */
  async deleteUser(params: IDeleteUserParams): Promise<any> {
    // Verify required parameters are set
    this.ensureParamIsSet('deleteUser', params, 'username');

    // Create URL to call
    const url = `${this.basePath}/user/{username}`
      .replace(`{${'username'}}`, encodeURIComponent(`${params['username']}`));

    const response = await this.httpClient.createRequest(url)
      // Set HTTP method
      .asDelete()

      // Send the request
      .send();

    if (response.statusCode < 200 || response.statusCode >= 300) {
      throw new Error(response.content);
    }

    // Extract the content
    return response.content;
  }

  /**
   * Get user by user name
   * @param params.username The name that needs to be fetched. Use user1 for testing.
   */
  async getUserByName(params: IGetUserByNameParams): Promise<User> {
    // Verify required parameters are set
    this.ensureParamIsSet('getUserByName', params, 'username');

    // Create URL to call
    const url = `${this.basePath}/user/{username}`
      .replace(`{${'username'}}`, encodeURIComponent(`${params['username']}`));

    const response = await this.httpClient.createRequest(url)
      // Set HTTP method
      .asGet()

      // Send the request
      .send();

    if (response.statusCode < 200 || response.statusCode >= 300) {
      throw new Error(response.content);
    }

    // Extract the content
    return response.content;
  }

  /**
   * Logs user into the system
   * @param params.username The user name for login
   * @param params.password The password for login in clear text
   */
  async loginUser(params: ILoginUserParams): Promise<string> {
    // Verify required parameters are set
    this.ensureParamIsSet('loginUser', params, 'username');
    this.ensureParamIsSet('loginUser', params, 'password');

    // Create URL to call
    const url = `${this.basePath}/user/login`;

    const response = await this.httpClient.createRequest(url)
      // Set HTTP method
      .asGet()
      // Set query parameters
      .withParams({ 
        'username': params['username'],
        'password': params['password'],
      })

      // Send the request
      .send();

    if (response.statusCode < 200 || response.statusCode >= 300) {
      throw new Error(response.content);
    }

    // Extract the content
    return response.content;
  }

  /**
   * Logs out current logged in user session
   */
  async logoutUser(): Promise<any> {
    // Verify required parameters are set

    // Create URL to call
    const url = `${this.basePath}/user/logout`;

    const response = await this.httpClient.createRequest(url)
      // Set HTTP method
      .asGet()

      // Send the request
      .send();

    if (response.statusCode < 200 || response.statusCode >= 300) {
      throw new Error(response.content);
    }

    // Extract the content
    return response.content;
  }

  /**
   * Updated user
   * This can only be done by the logged in user.
   * @param params.username name that need to be deleted
   * @param params.body Updated user object
   */
  async updateUser(params: IUpdateUserParams): Promise<any> {
    // Verify required parameters are set
    this.ensureParamIsSet('updateUser', params, 'username');
    this.ensureParamIsSet('updateUser', params, 'body');

    // Create URL to call
    const url = `${this.basePath}/user/{username}`
      .replace(`{${'username'}}`, encodeURIComponent(`${params['username']}`));

    const response = await this.httpClient.createRequest(url)
      // Set HTTP method
      .asPut()
      // Encode body parameter
      .withHeader('content-type', 'application/json')
      .withContent(JSON.stringify(params['body'] || {}))

      // Send the request
      .send();

    if (response.statusCode < 200 || response.statusCode >= 300) {
      throw new Error(response.content);
    }

    // Extract the content
    return response.content;
  }

}

