# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\  # noqa: E501

    OpenAPI spec version: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest

import petstore_api
from petstore_api import Configuration # noqa: E501
from petstore_api.rest import ApiException


class TestConfiguration(unittest.TestCase):
    """Confgiruation unit test stubs"""

    def setUp(self):
        self.config= Configuration()

    def tearDown(self):
        pass

    def test_configuration(self):
        """Test configuration

        Test host settings # noqa: E501
        """
        host_settings = self.config.get_host_settings()

        self.assertEqual('http://{server}.swagger.io:{port}/v2', host_settings[0]['url'])
        self.assertEqual('petstore', host_settings[0]['variables']['server']['default_value'])

        self.assertEqual('https://localhost:8080/{version}', host_settings[1]['url'])
        self.assertEqual('v2', host_settings[1]['variables']['version']['default_value'])

    def test_get_host_from_settings(self):
        """ Test get_host_from_settings

        Test get URL from host settings
        """
        self.assertEqual("http://petstore.swagger.io:80/v2", self.config.get_host_from_settings(0))
        self.assertEqual("http://petstore.swagger.io:8080/v2", self.config.get_host_from_settings(0, {'port': '8080'}))
        self.assertEqual("http://dev-petstore.swagger.io:8080/v2", self.config.get_host_from_settings(0, {'server': 'dev-petstore', 'port': '8080'}))

if __name__ == '__main__':
    unittest.main()
