/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
/*
 * StoreApi.h
 *
 * 
 */

#ifndef StoreApi_H_
#define StoreApi_H_


#include <pistache/http.h>
#include <pistache/router.h>
#include <pistache/http_headers.h>
#include <pistache/optional.h>


#include "Order.h"
#include <map>
#include <string>

namespace org {
namespace openapitools {
namespace server {
namespace api {

using namespace org::openapitools::server::model;

class  StoreApi {
public:
    StoreApi(std::shared_ptr<Pistache::Rest::Router>);
    virtual ~StoreApi() {}
    void init();

    const std::string base = "/v2";

private:
    void setupRoutes();

    void delete_order_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    void get_inventory_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    void get_order_by_id_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    void place_order_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    void store_api_default_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);

    std::shared_ptr<Pistache::Rest::Router> router;

    /// <summary>
    /// Delete purchase order by ID
    /// </summary>
    /// <remarks>
    /// For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
    /// </remarks>
    /// <param name="orderId">ID of the order that needs to be deleted</param>
    virtual void delete_order(const std::string &orderId, Pistache::Http::ResponseWriter &response) = 0;

    /// <summary>
    /// Returns pet inventories by status
    /// </summary>
    /// <remarks>
    /// Returns a map of status codes to quantities
    /// </remarks>
    virtual void get_inventory(Pistache::Http::ResponseWriter &response) = 0;

    /// <summary>
    /// Find purchase order by ID
    /// </summary>
    /// <remarks>
    /// For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generated exceptions
    /// </remarks>
    /// <param name="orderId">ID of pet that needs to be fetched</param>
    virtual void get_order_by_id(const int64_t &orderId, Pistache::Http::ResponseWriter &response) = 0;

    /// <summary>
    /// Place an order for a pet
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="body">order placed for purchasing the pet</param>
    virtual void place_order(const Order &body, Pistache::Http::ResponseWriter &response) = 0;

};

}
}
}
}

#endif /* StoreApi_H_ */

