/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI-Generator unset.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */



#include "Pet.h"

#include <string>
#include <sstream>
#include <algorithm>
#include <boost/property_tree/ptree.hpp>
#include <boost/property_tree/json_parser.hpp>

using boost::property_tree::ptree;
using boost::property_tree::read_json;
using boost::property_tree::write_json;

namespace org {
namespace openapitools {
namespace server {
namespace model {

Pet::Pet()
{
	m_Id = 0L;
	m_Name = "";
	m_Status = "";
	m_StatusEnum = { "available", "pending", "sold" };
}

Pet::~Pet()
{
}

std::string Pet::toJsonString(bool prettyJson)
{
	std::stringstream ss;
	write_json(ss, this->toPropertyTree(), prettyJson);
	return ss.str();
}

void Pet::fromJsonString(std::string const& jsonString)
{
	std::stringstream ss(jsonString);
	ptree pt;
	read_json(ss,pt);
	this->fromPropertyTree(pt);
}

ptree Pet::toPropertyTree()
{
	ptree pt;
	ptree tmp_node;
	pt.put("id", m_Id);
	if (m_Category != nullptr) {
		pt.add_child("category", m_Category->toPropertyTree());
	}
	pt.put("name", m_Name);
	// generate tree for PhotoUrls
	if (!m_PhotoUrls.empty()) {
		for (const auto &childEntry : m_PhotoUrls) {
			ptree PhotoUrls_node;
			PhotoUrls_node.put("", childEntry);
			tmp_node.push_back(std::make_pair("", PhotoUrls_node));
		}
		pt.add_child("photoUrls", tmp_node);
		tmp_node.clear();
	}
	// generate tree for vector of pointers of Tags
	if (!m_Tags.empty()) {
		for (const auto &childEntry : m_Tags) {
			tmp_node.push_back(std::make_pair("", childEntry->toPropertyTree()));
		}
		pt.add_child("tags", tmp_node);
		tmp_node.clear();
	}
	pt.put("status", m_Status);
	return pt;
}

void Pet::fromPropertyTree(ptree const &pt)
{
	ptree tmp_node;
	m_Id = pt.get("id", 0L);
	if (pt.get_child_optional("category")) {
		m_Category = std::make_shared<Category>();
		m_Category->fromPropertyTree(pt.get_child("category"));
	}
	m_Name = pt.get("name", "");
	// push all items of PhotoUrls into member vector
	if (pt.get_child_optional("photoUrls")) {
		for (const auto &childTree : pt.get_child("photoUrls")) {
			m_PhotoUrls.emplace_back(childTree.second.data());
		}
	}
	// generate new Tag Object for each item and assign it to the current
	if (pt.get_child_optional("tags")) {
		for (const auto &childTree : pt.get_child("tags")) {
			m_Tags.emplace_back(std::make_shared<Tag>());
			m_Tags.back()->fromPropertyTree(childTree.second);
		}
	}
	setStatus(pt.get("status", ""));
}

int64_t Pet::getId() const
{
    return m_Id;
}
void Pet::setId(int64_t value)
{
	m_Id = value;
}
std::shared_ptr<Category> Pet::getCategory() const
{
    return m_Category;
}
void Pet::setCategory(std::shared_ptr<Category> value)
{
	m_Category = value;
}
std::string Pet::getName() const
{
    return m_Name;
}
void Pet::setName(std::string value)
{
	m_Name = value;
}
std::vector<std::string> Pet::getPhotoUrls() const
{
    return m_PhotoUrls;
}
void Pet::setPhotoUrls(std::vector<std::string> value)
{
	m_PhotoUrls = value;
}
std::vector<std::shared_ptr<Tag>> Pet::getTags() const
{
    return m_Tags;
}
void Pet::setTags(std::vector<std::shared_ptr<Tag>> value)
{
	m_Tags = value;
}
std::string Pet::getStatus() const
{
    return m_Status;
}
void Pet::setStatus(std::string value)
{
	if (std::find(m_StatusEnum.begin(), m_StatusEnum.end(), value) != m_StatusEnum.end()) {
		m_Status = value;
	}
}

}
}
}
}

