<?php
/**
 * AbstractFakeApi
 *
 * PHP version 7
 *
 * @package OpenAPIServer\Api
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */

/**
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 * Do not edit the class manually.
 */
namespace OpenAPIServer\Api;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Exception;

/**
 * AbstractFakeApi Class Doc Comment
 *
 * @package OpenAPIServer\Api
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */
abstract class AbstractFakeApi
{

    /**
     * @var ContainerInterface Slim app container instance
     */
    protected $container;

    /**
     * Route Controller constructor receives container
     *
     * @param ContainerInterface $container Slim app container instance
     */
    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }


    /**
     * POST createXmlItem
     * Summary: creates an XmlItem
     * Notes: this route creates an XmlItem
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function createXmlItem(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing createXmlItem as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * POST fakeOuterBooleanSerialize
     * Notes: Test serialization of outer boolean types
     * Output-Formats: [*_/_*]
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function fakeOuterBooleanSerialize(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing fakeOuterBooleanSerialize as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * POST fakeOuterCompositeSerialize
     * Notes: Test serialization of object with outer number type
     * Output-Formats: [*_/_*]
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function fakeOuterCompositeSerialize(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing fakeOuterCompositeSerialize as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * POST fakeOuterNumberSerialize
     * Notes: Test serialization of outer number types
     * Output-Formats: [*_/_*]
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function fakeOuterNumberSerialize(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing fakeOuterNumberSerialize as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * POST fakeOuterStringSerialize
     * Notes: Test serialization of outer string types
     * Output-Formats: [*_/_*]
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function fakeOuterStringSerialize(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing fakeOuterStringSerialize as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * PUT testBodyWithFileSchema
     * Notes: For this test, the body for this request much reference a schema named &#x60;File&#x60;.
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testBodyWithFileSchema(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing testBodyWithFileSchema as a PUT method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * PUT testBodyWithQueryParams
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testBodyWithQueryParams(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $queryParams = $request->getQueryParams();
        $query = $request->getQueryParam('query');
        $body = $request->getParsedBody();
        $message = "How about implementing testBodyWithQueryParams as a PUT method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * PATCH testClientModel
     * Summary: To test \&quot;client\&quot; model
     * Notes: To test \&quot;client\&quot; model
     * Output-Formats: [application/json]
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testClientModel(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing testClientModel as a PATCH method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * POST testEndpointParameters
     * Summary: Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
     * Notes: Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testEndpointParameters(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $integer = $request->getParsedBodyParam('integer');
        $int32 = $request->getParsedBodyParam('int32');
        $int64 = $request->getParsedBodyParam('int64');
        $number = $request->getParsedBodyParam('number');
        $float = $request->getParsedBodyParam('float');
        $double = $request->getParsedBodyParam('double');
        $string = $request->getParsedBodyParam('string');
        $patternWithoutDelimiter = $request->getParsedBodyParam('pattern_without_delimiter');
        $byte = $request->getParsedBodyParam('byte');
        $binary = (key_exists('binary', $request->getUploadedFiles())) ? $request->getUploadedFiles()['binary'] : null;
        $date = $request->getParsedBodyParam('date');
        $dateTime = $request->getParsedBodyParam('dateTime');
        $password = $request->getParsedBodyParam('password');
        $callback = $request->getParsedBodyParam('callback');
        $message = "How about implementing testEndpointParameters as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * GET testEnumParameters
     * Summary: To test enum parameters
     * Notes: To test enum parameters
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testEnumParameters(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $headers = $request->getHeaders();
        $enumHeaderStringArray = $request->hasHeader('enum_header_string_array') ? $headers['enum_header_string_array'] : null;
        $enumHeaderString = $request->hasHeader('enum_header_string') ? $headers['enum_header_string'] : null;
        $queryParams = $request->getQueryParams();
        $enumQueryStringArray = $request->getQueryParam('enum_query_string_array');
        $enumQueryString = $request->getQueryParam('enum_query_string');
        $enumQueryInteger = $request->getQueryParam('enum_query_integer');
        $enumQueryDouble = $request->getQueryParam('enum_query_double');
        $enumFormStringArray = $request->getParsedBodyParam('enum_form_string_array');
        $enumFormString = $request->getParsedBodyParam('enum_form_string');
        $message = "How about implementing testEnumParameters as a GET method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * DELETE testGroupParameters
     * Summary: Fake endpoint to test group parameters (optional)
     * Notes: Fake endpoint to test group parameters (optional)
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testGroupParameters(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $headers = $request->getHeaders();
        $requiredBooleanGroup = $request->hasHeader('required_boolean_group') ? $headers['required_boolean_group'] : null;
        $booleanGroup = $request->hasHeader('boolean_group') ? $headers['boolean_group'] : null;
        $queryParams = $request->getQueryParams();
        $requiredStringGroup = $request->getQueryParam('required_string_group');
        $requiredInt64Group = $request->getQueryParam('required_int64_group');
        $stringGroup = $request->getQueryParam('string_group');
        $int64Group = $request->getQueryParam('int64_group');
        $message = "How about implementing testGroupParameters as a DELETE method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * POST testInlineAdditionalProperties
     * Summary: test inline additionalProperties
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testInlineAdditionalProperties(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $body = $request->getParsedBody();
        $message = "How about implementing testInlineAdditionalProperties as a POST method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * GET testJsonFormData
     * Summary: test json serialization of form data
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testJsonFormData(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $param = $request->getParsedBodyParam('param');
        $param2 = $request->getParsedBodyParam('param2');
        $message = "How about implementing testJsonFormData as a GET method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }

    /**
     * PUT testQueryParameterCollectionFormat
     * Notes: To test the collection format in query parameters
     *
     * @param ServerRequestInterface $request  Request
     * @param ResponseInterface      $response Response
     * @param array|null             $args     Path arguments
     *
     * @return ResponseInterface
     * @throws Exception to force implementation class to override this method
     */
    public function testQueryParameterCollectionFormat(ServerRequestInterface $request, ResponseInterface $response, array $args)
    {
        $queryParams = $request->getQueryParams();
        $pipe = $request->getQueryParam('pipe');
        $ioutil = $request->getQueryParam('ioutil');
        $http = $request->getQueryParam('http');
        $url = $request->getQueryParam('url');
        $context = $request->getQueryParam('context');
        $message = "How about implementing testQueryParameterCollectionFormat as a PUT method in OpenAPIServer\Api\FakeApi class?";
        throw new Exception($message);

        return $response->write($message)->withStatus(501);
    }
}
