<?php

/**
 * Order
 *
 * PHP version 7.1
 *
 * @package OpenAPIServer\Model
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 */
namespace OpenAPIServer\Model;

use OpenAPIServer\Interfaces\ModelInterface;

/**
 * Order
 *
 * @package OpenAPIServer\Model
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */
class Order implements ModelInterface
{
    private const MODEL_SCHEMA = <<<'SCHEMA'
{
  "type" : "object",
  "properties" : {
    "id" : {
      "type" : "integer",
      "format" : "int64"
    },
    "petId" : {
      "type" : "integer",
      "format" : "int64"
    },
    "quantity" : {
      "type" : "integer",
      "format" : "int32"
    },
    "shipDate" : {
      "type" : "string",
      "format" : "date-time"
    },
    "status" : {
      "type" : "string",
      "description" : "Order Status",
      "enum" : [ "placed", "approved", "delivered" ]
    },
    "complete" : {
      "type" : "boolean",
      "default" : false
    }
  },
  "xml" : {
    "name" : "Order"
  }
}
SCHEMA;

    /** @var int $id */
    private $id;

    /** @var int $petId */
    private $petId;

    /** @var int $quantity */
    private $quantity;

    /** @var \DateTime $shipDate */
    private $shipDate;

    /** @var string $status Order Status*/
    private $status;

    /** @var bool $complete */
    private $complete;

    /**
     * Returns model schema.
     *
     * @param bool $assoc When TRUE, returned objects will be converted into associative arrays. Default FALSE.
     *
     * @return array
     */
    public static function getOpenApiSchema($assoc = false)
    {
        return json_decode(static::MODEL_SCHEMA, $assoc);
    }
}
