<?php

/**
 * TypeHolderExample
 *
 * PHP version 7.1
 *
 * @package OpenAPIServer\Model
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 */
namespace OpenAPIServer\Model;

use OpenAPIServer\Interfaces\ModelInterface;

/**
 * TypeHolderExample
 *
 * @package OpenAPIServer\Model
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */
class TypeHolderExample implements ModelInterface
{
    private const MODEL_SCHEMA = <<<'SCHEMA'
{
  "required" : [ "array_item", "bool_item", "float_item", "integer_item", "number_item", "string_item" ],
  "type" : "object",
  "properties" : {
    "string_item" : {
      "type" : "string",
      "example" : "what"
    },
    "number_item" : {
      "type" : "number",
      "example" : 1.234
    },
    "float_item" : {
      "type" : "number",
      "format" : "float",
      "example" : 1.234
    },
    "integer_item" : {
      "type" : "integer",
      "example" : -2
    },
    "bool_item" : {
      "type" : "boolean",
      "example" : true
    },
    "array_item" : {
      "type" : "array",
      "example" : [ 0, 1, 2, 3 ],
      "items" : {
        "type" : "integer"
      }
    }
  }
}
SCHEMA;

    /** @var string $stringItem */
    private $stringItem;

    /** @var float $numberItem */
    private $numberItem;

    /** @var float $floatItem */
    private $floatItem;

    /** @var int $integerItem */
    private $integerItem;

    /** @var bool $boolItem */
    private $boolItem;

    /** @var int[] $arrayItem */
    private $arrayItem;

    /**
     * Returns model schema.
     *
     * @param bool $assoc When TRUE, returned objects will be converted into associative arrays. Default FALSE.
     *
     * @return array
     */
    public static function getOpenApiSchema($assoc = false)
    {
        return json_decode(static::MODEL_SCHEMA, $assoc);
    }
}
