<?php

/**
 * StringUtilsTraitTest
 *
 * PHP version 7.1
 *
 * @package OpenAPIServer
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 */

/**
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 * Do not edit the class manually.
 */
namespace OpenAPIServer\Utils;

use OpenAPIServer\Utils\StringUtilsTrait as StringUtils;
use PHPUnit\Framework\TestCase;

/**
 * StringUtilsTraitTest Class Doc Comment
 *
 * @package OpenAPIServer\Utils
 * @author  OpenAPI Generator team
 * @link    https://github.com/openapitools/openapi-generator
 * @coversDefaultClass \OpenAPIServer\Utils\StringUtilsTrait
 */
class StringUtilsTraitTest extends TestCase
{
    /**
     * @covers ::camelize
     * @dataProvider provideWordsForCamelizeTest
     */
    public function testCamelize($word, $lowercaseFirstLetter, $expectedWord)
    {
        $this->assertSame($expectedWord, StringUtils::camelize($word, $lowercaseFirstLetter));
    }

    public function provideWordsForCamelizeTest()
    {
        return [
            // fixtures from modules/openapi-generator/src/test/java/org/openapitools/codegen/utils/StringUtilsTest.java
            ['openApiServer/model/pet', null, 'OpenApiServerModelPet'],
            ['abcd', null, 'Abcd'],
            ['some-value', null, 'SomeValue'],
            ['some-Value', null, 'SomeValue'],
            ['some_value', null, 'SomeValue'],
            ['some_Value', null, 'SomeValue'],
            ['$type', null, '$Type'],

            ['abcd', true, 'abcd'],
            ['some-value', true, 'someValue'],
            ['some_value', true, 'someValue'],
            ['Abcd', true, 'abcd'],
            ['$type', true, '$type'],

            ['123', true, '123'],
            ['$123', true, '$123'],
        ];
    }

    /**
     * @covers ::isReservedWord
     * @dataProvider provideWordsForIsReservedTest
     */
    public function testisReservedWord($word, $expected)
    {
        $this->assertSame($expected, StringUtils::isReservedWord($word));
    }

    public function provideWordsForIsReservedTest()
    {
        return [
            ['return', true],
            ['switch', true],
            ['class', true],
            ['interface', true],
            ['ABSTRACT', true],
            ['Trait', true],
            ['final', true],
            ['foobar', false],
            ['DateTime', false],
            ['Pet', false],
            [123, false],
            [null, false],
        ];
    }
}
