# Rust API for openapi-v3

API under test

## Overview

This client/server was generated by the [openapi-generator]
(https://openapi-generator.tech) project.  By using the
[OpenAPI-Spec](https://github.com/OAI/OpenAPI-Specification) from a remote
server, you can easily generate a server stub.

To see how to make this your own, look here:

[README]((https://openapi-generator.tech))

- API version: 1.0.7




This autogenerated project defines an API crate `openapi-v3` which contains:
* An `Api` trait defining the API in Rust.
* Data types representing the underlying data model.
* A `Client` type which implements `Api` and issues HTTP requests for each operation.
* A router which accepts HTTP requests and invokes the appropriate `Api` method for each operation.

It also contains an example server and client which make use of `openapi-v3`:

* The example server starts up a web server using the `openapi-v3`
    router, and supplies a trivial implementation of `Api` which returns failure
    for every operation.
* The example client provides a CLI which lets you invoke
    any single operation on the `openapi-v3` client by passing appropriate
    arguments on the command line.

You can use the example server and client as a basis for your own code.
See below for [more detail on implementing a server](#writing-a-server).

## Examples

Run examples with:

```
cargo run --example <example-name>
```

To pass in arguments to the examples, put them after `--`, for example:

```
cargo run --example client -- --help
```

### Running the example server
To run the server, follow these simple steps:

```
cargo run --example server
```

### Running the example client
To run a client, follow one of the following simple steps:

```
cargo run --example client MultigetGet
cargo run --example client MultipleAuthSchemeGet
cargo run --example client ReadonlyAuthSchemeGet
cargo run --example client RequiredOctetStreamPut
cargo run --example client ResponsesWithHeadersGet
cargo run --example client UuidGet
cargo run --example client XmlExtraPost
cargo run --example client XmlOtherPost
cargo run --example client XmlOtherPut
cargo run --example client XmlPost
cargo run --example client XmlPut
```

### HTTPS
The examples can be run in HTTPS mode by passing in the flag `--https`, for example:

```
cargo run --example server -- --https
```

This will use the keys/certificates from the examples directory. Note that the
server chain is signed with `CN=localhost`.

## Using the generated library

The generated library has a few optional features that can be activated through Cargo.

* `server`
    * This defaults to enabled and creates the basic skeleton of a server implementation based on hyper
    * To create the server stack you'll need to provide an implementation of the API trait to provide the server function.
* `client`
    * This defaults to enabled and creates the basic skeleton of a client implementation based on hyper
    * The constructed client implements the API trait by making remote API call.
* `conversions`
    * This defaults to disabled and creates extra derives on models to allow "transmogrification" between objects of structurally similar types.

See https://doc.rust-lang.org/cargo/reference/manifest.html#the-features-section for how to use features in your `Cargo.toml`.

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[****](docs/default_api.md#) | **GET** /multiget | Get some stuff.
[****](docs/default_api.md#) | **GET** /multiple_auth_scheme | 
[****](docs/default_api.md#) | **GET** /readonly_auth_scheme | 
[****](docs/default_api.md#) | **PUT** /required_octet_stream | 
[****](docs/default_api.md#) | **GET** /responses_with_headers | 
[****](docs/default_api.md#) | **GET** /uuid | 
[****](docs/default_api.md#) | **POST** /xml_extra | 
[****](docs/default_api.md#) | **POST** /xml_other | 
[****](docs/default_api.md#) | **PUT** /xml_other | 
[****](docs/default_api.md#) | **POST** /xml | Post an array
[****](docs/default_api.md#) | **PUT** /xml | 


## Documentation For Models

 - [AnotherXmlArray](docs/AnotherXmlArray.md)
 - [AnotherXmlInner](docs/AnotherXmlInner.md)
 - [AnotherXmlObject](docs/AnotherXmlObject.md)
 - [DuplicateXmlObject](docs/DuplicateXmlObject.md)
 - [InlineResponse201](docs/InlineResponse201.md)
 - [UuidObject](docs/UuidObject.md)
 - [XmlArray](docs/XmlArray.md)
 - [XmlInner](docs/XmlInner.md)
 - [XmlObject](docs/XmlObject.md)


## Documentation For Authorization

## authScheme
- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: http://example.org
- **Scopes**: 
 - **test.read**: Allowed to read state.
 - **test.write**: Allowed to change state.

Example
```
```

Or via OAuth2 module to automatically refresh tokens and perform user authentication.
```
```

## Author



