# Rust API for petstore-with-fake-endpoints-models-for-testing

This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

## Overview

This client/server was generated by the [openapi-generator]
(https://openapi-generator.tech) project.  By using the
[OpenAPI-Spec](https://github.com/OAI/OpenAPI-Specification) from a remote
server, you can easily generate a server stub.

To see how to make this your own, look here:

[README]((https://openapi-generator.tech))

- API version: 1.0.0




This autogenerated project defines an API crate `petstore-with-fake-endpoints-models-for-testing` which contains:
* An `Api` trait defining the API in Rust.
* Data types representing the underlying data model.
* A `Client` type which implements `Api` and issues HTTP requests for each operation.
* A router which accepts HTTP requests and invokes the appropriate `Api` method for each operation.

It also contains an example server and client which make use of `petstore-with-fake-endpoints-models-for-testing`:

* The example server starts up a web server using the `petstore-with-fake-endpoints-models-for-testing`
    router, and supplies a trivial implementation of `Api` which returns failure
    for every operation.
* The example client provides a CLI which lets you invoke
    any single operation on the `petstore-with-fake-endpoints-models-for-testing` client by passing appropriate
    arguments on the command line.

You can use the example server and client as a basis for your own code.
See below for [more detail on implementing a server](#writing-a-server).

## Examples

Run examples with:

```
cargo run --example <example-name>
```

To pass in arguments to the examples, put them after `--`, for example:

```
cargo run --example client -- --help
```

### Running the example server
To run the server, follow these simple steps:

```
cargo run --example server
```

### Running the example client
To run a client, follow one of the following simple steps:

```
cargo run --example client TestSpecialTags
cargo run --example client FakeOuterBooleanSerialize
cargo run --example client FakeOuterCompositeSerialize
cargo run --example client FakeOuterNumberSerialize
cargo run --example client FakeOuterStringSerialize
cargo run --example client HyphenParam
cargo run --example client TestBodyWithQueryParams
cargo run --example client TestClientModel
cargo run --example client TestEndpointParameters
cargo run --example client TestEnumParameters
cargo run --example client TestInlineAdditionalProperties
cargo run --example client TestJsonFormData
cargo run --example client TestClassname
cargo run --example client AddPet
cargo run --example client DeletePet
cargo run --example client FindPetsByStatus
cargo run --example client FindPetsByTags
cargo run --example client GetPetById
cargo run --example client UpdatePet
cargo run --example client UpdatePetWithForm
cargo run --example client UploadFile
cargo run --example client DeleteOrder
cargo run --example client GetInventory
cargo run --example client GetOrderById
cargo run --example client PlaceOrder
cargo run --example client CreateUser
cargo run --example client CreateUsersWithArrayInput
cargo run --example client CreateUsersWithListInput
cargo run --example client DeleteUser
cargo run --example client GetUserByName
cargo run --example client LoginUser
cargo run --example client LogoutUser
cargo run --example client UpdateUser
```

### HTTPS
The examples can be run in HTTPS mode by passing in the flag `--https`, for example:

```
cargo run --example server -- --https
```

This will use the keys/certificates from the examples directory. Note that the
server chain is signed with `CN=localhost`.

## Using the generated library

The generated library has a few optional features that can be activated through Cargo.

* `server`
    * This defaults to enabled and creates the basic skeleton of a server implementation based on hyper
    * To create the server stack you'll need to provide an implementation of the API trait to provide the server function.
* `client`
    * This defaults to enabled and creates the basic skeleton of a client implementation based on hyper
    * The constructed client implements the API trait by making remote API call.
* `conversions`
    * This defaults to disabled and creates extra derives on models to allow "transmogrification" between objects of structurally similar types.

See https://doc.rust-lang.org/cargo/reference/manifest.html#the-features-section for how to use features in your `Cargo.toml`.

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io:80/v2*

Method | HTTP request | Description
------------- | ------------- | -------------
[**test_special_tags**](docs/another_fake_api.md#test_special_tags) | **PATCH** /another-fake/dummy | To test special tags
[**fakeOuterBooleanSerialize**](docs/fake_api.md#fakeOuterBooleanSerialize) | **POST** /fake/outer/boolean | 
[**fakeOuterCompositeSerialize**](docs/fake_api.md#fakeOuterCompositeSerialize) | **POST** /fake/outer/composite | 
[**fakeOuterNumberSerialize**](docs/fake_api.md#fakeOuterNumberSerialize) | **POST** /fake/outer/number | 
[**fakeOuterStringSerialize**](docs/fake_api.md#fakeOuterStringSerialize) | **POST** /fake/outer/string | 
[**hyphenParam**](docs/fake_api.md#hyphenParam) | **GET** /fake/hyphenParam/{hyphen-param} | 
[**testBodyWithQueryParams**](docs/fake_api.md#testBodyWithQueryParams) | **PUT** /fake/body-with-query-params | 
[**testClientModel**](docs/fake_api.md#testClientModel) | **PATCH** /fake | To test \"client\" model
[**testEndpointParameters**](docs/fake_api.md#testEndpointParameters) | **POST** /fake | Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
[**testEnumParameters**](docs/fake_api.md#testEnumParameters) | **GET** /fake | To test enum parameters
[**testInlineAdditionalProperties**](docs/fake_api.md#testInlineAdditionalProperties) | **POST** /fake/inline-additionalProperties | test inline additionalProperties
[**testJsonFormData**](docs/fake_api.md#testJsonFormData) | **GET** /fake/jsonFormData | test json serialization of form data
[**testClassname**](docs/fake_classname_tags123_api.md#testClassname) | **PATCH** /fake_classname_test | To test class name in snake case
[**addPet**](docs/pet_api.md#addPet) | **POST** /pet | Add a new pet to the store
[**deletePet**](docs/pet_api.md#deletePet) | **DELETE** /pet/{petId} | Deletes a pet
[**findPetsByStatus**](docs/pet_api.md#findPetsByStatus) | **GET** /pet/findByStatus | Finds Pets by status
[**findPetsByTags**](docs/pet_api.md#findPetsByTags) | **GET** /pet/findByTags | Finds Pets by tags
[**getPetById**](docs/pet_api.md#getPetById) | **GET** /pet/{petId} | Find pet by ID
[**updatePet**](docs/pet_api.md#updatePet) | **PUT** /pet | Update an existing pet
[**updatePetWithForm**](docs/pet_api.md#updatePetWithForm) | **POST** /pet/{petId} | Updates a pet in the store with form data
[**uploadFile**](docs/pet_api.md#uploadFile) | **POST** /pet/{petId}/uploadImage | uploads an image
[**deleteOrder**](docs/store_api.md#deleteOrder) | **DELETE** /store/order/{order_id} | Delete purchase order by ID
[**getInventory**](docs/store_api.md#getInventory) | **GET** /store/inventory | Returns pet inventories by status
[**getOrderById**](docs/store_api.md#getOrderById) | **GET** /store/order/{order_id} | Find purchase order by ID
[**placeOrder**](docs/store_api.md#placeOrder) | **POST** /store/order | Place an order for a pet
[**createUser**](docs/user_api.md#createUser) | **POST** /user | Create user
[**createUsersWithArrayInput**](docs/user_api.md#createUsersWithArrayInput) | **POST** /user/createWithArray | Creates list of users with given input array
[**createUsersWithListInput**](docs/user_api.md#createUsersWithListInput) | **POST** /user/createWithList | Creates list of users with given input array
[**deleteUser**](docs/user_api.md#deleteUser) | **DELETE** /user/{username} | Delete user
[**getUserByName**](docs/user_api.md#getUserByName) | **GET** /user/{username} | Get user by user name
[**loginUser**](docs/user_api.md#loginUser) | **GET** /user/login | Logs user into the system
[**logoutUser**](docs/user_api.md#logoutUser) | **GET** /user/logout | Logs out current logged in user session
[**updateUser**](docs/user_api.md#updateUser) | **PUT** /user/{username} | Updated user


## Documentation For Models

 - [AdditionalPropertiesClass](docs/AdditionalPropertiesClass.md)
 - [Animal](docs/Animal.md)
 - [AnimalFarm](docs/AnimalFarm.md)
 - [ApiResponse](docs/ApiResponse.md)
 - [ArrayOfArrayOfNumberOnly](docs/ArrayOfArrayOfNumberOnly.md)
 - [ArrayOfNumberOnly](docs/ArrayOfNumberOnly.md)
 - [ArrayTest](docs/ArrayTest.md)
 - [Capitalization](docs/Capitalization.md)
 - [Cat](docs/Cat.md)
 - [CatAllOf](docs/CatAllOf.md)
 - [Category](docs/Category.md)
 - [ClassModel](docs/ClassModel.md)
 - [Client](docs/Client.md)
 - [Dog](docs/Dog.md)
 - [DogAllOf](docs/DogAllOf.md)
 - [EnumArrays](docs/EnumArrays.md)
 - [EnumClass](docs/EnumClass.md)
 - [EnumTest](docs/EnumTest.md)
 - [FormatTest](docs/FormatTest.md)
 - [HasOnlyReadOnly](docs/HasOnlyReadOnly.md)
 - [List](docs/List.md)
 - [MapTest](docs/MapTest.md)
 - [MixedPropertiesAndAdditionalPropertiesClass](docs/MixedPropertiesAndAdditionalPropertiesClass.md)
 - [Model200Response](docs/Model200Response.md)
 - [ModelReturn](docs/ModelReturn.md)
 - [Name](docs/Name.md)
 - [NumberOnly](docs/NumberOnly.md)
 - [Order](docs/Order.md)
 - [OuterBoolean](docs/OuterBoolean.md)
 - [OuterComposite](docs/OuterComposite.md)
 - [OuterEnum](docs/OuterEnum.md)
 - [OuterNumber](docs/OuterNumber.md)
 - [OuterString](docs/OuterString.md)
 - [Pet](docs/Pet.md)
 - [ReadOnlyFirst](docs/ReadOnlyFirst.md)
 - [SpecialModelName](docs/SpecialModelName.md)
 - [Tag](docs/Tag.md)
 - [User](docs/User.md)


## Documentation For Authorization

## api_key
- **Type**: API key 

Example
```
```
## api_key_query
- **Type**: API key 

Example
```
```
## http_basic_test
- **Type**: HTTP basic authentication

Example
```
```
## petstore_auth
- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
 - **write:pets**: modify pets in your account
 - **read:pets**: read your pets

Example
```
```

Or via OAuth2 module to automatically refresh tokens and perform user authentication.
```
```

## Author



